/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.compatibility.AriKeysSupport;
import io.lumine.mythic.bukkit.compatibility.CitizensSupport;
import io.lumine.mythic.bukkit.compatibility.CosmeticsSupport;
import io.lumine.mythic.bukkit.compatibility.CrashClaimSupport;
import io.lumine.mythic.bukkit.compatibility.CrucibleSupport;
import io.lumine.mythic.bukkit.compatibility.GriefPreventionSupport;
import io.lumine.mythic.bukkit.compatibility.HeroesSupport;
import io.lumine.mythic.bukkit.compatibility.LandsSupport;
import io.lumine.mythic.bukkit.compatibility.LibsDisguisesSupport;
import io.lumine.mythic.bukkit.compatibility.MMOItemsSupport;
import io.lumine.mythic.bukkit.compatibility.MPetCompat;
import io.lumine.mythic.bukkit.compatibility.MythicDropsSupport;
import io.lumine.mythic.bukkit.compatibility.MythicLibSupport;
import io.lumine.mythic.bukkit.compatibility.MythicRPGSupport;
import io.lumine.mythic.bukkit.compatibility.NoCheatPlusSupport;
import io.lumine.mythic.bukkit.compatibility.OpenTerrainGeneratorSupport;
import io.lumine.mythic.bukkit.compatibility.PhatLootsSupport;
import io.lumine.mythic.bukkit.compatibility.PlaceholderAPISupport;
import io.lumine.mythic.bukkit.compatibility.ShopGUIPlusSupport;
import io.lumine.mythic.bukkit.compatibility.SkillAPISupport;
import io.lumine.mythic.bukkit.compatibility.VaultSupport;
import io.lumine.mythic.bukkit.compatibility.WorldGuardSupport;
import io.lumine.mythic.bukkit.compatibility.mcMMOSupport;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Optional;
import org.bukkit.Bukkit;

public class CompatibilityManager
implements Terminable {
    private Optional<CosmeticsSupport> cosmetics = Optional.empty();
    private Optional<CrucibleSupport> crucible = Optional.empty();
    private Optional<MythicRPGSupport> rpg = Optional.empty();
    private Optional<CitizensSupport> citizens = Optional.empty();
    private Optional<CrashClaimSupport> crashClaim = Optional.empty();
    private Optional<GriefPreventionSupport> griefPrevention = Optional.empty();
    private Optional<LandsSupport> lands = Optional.empty();
    private Optional<MPetCompat> miniaturePets = Optional.empty();
    private Optional<MMOItemsSupport> MMOItems = Optional.empty();
    private Optional<MythicLibSupport> mythicLib = Optional.empty();
    private Optional<NoCheatPlusSupport> noCheatPlus = Optional.empty();
    private Optional<OpenTerrainGeneratorSupport> openTerrainGenerator = Optional.empty();
    private Optional<PlaceholderAPISupport> placeholderAPI = Optional.empty();
    private Optional<VaultSupport> vault = Optional.empty();
    private Optional<WorldGuardSupport> worldGuard = Optional.empty();
    private Optional<AriKeysSupport> ariKeys = Optional.empty();
    private Optional<ShopGUIPlusSupport> shopGUIPlus = Optional.empty();
    private Optional<AbstractModelEngineSupport> ModelEngine = Optional.empty();
    public static HeroesSupport Heroes = null;
    public static LibsDisguisesSupport LibsDisguises = null;
    public static mcMMOSupport mcMMO = null;
    public static MythicDropsSupport MythicDrops = null;
    public static PhatLootsSupport PhatLoots = null;
    public static SkillAPISupport SkillAPI = null;

    public CompatibilityManager(MythicBukkit core) {
        this.registerCompatibility("Citizens", () -> {
            this.citizens = Optional.of(new CitizensSupport());
        });
        this.registerCompatibility("CrashClaim", () -> {
            this.crashClaim = Optional.of(new CrashClaimSupport(core));
        });
        this.registerCompatibility("AriKeys", () -> {
            this.ariKeys = Optional.of(new AriKeysSupport(core));
        });
        this.registerCompatibility("GriefPrevention", () -> {
            this.griefPrevention = Optional.of(new GriefPreventionSupport(core));
        });
        this.registerCompatibility("Heroes", () -> {
            Heroes = new HeroesSupport();
        });
        this.registerCompatibility("Lands", () -> {
            this.lands = Optional.of(new LandsSupport(core));
        });
        this.registerCompatibility("LibsDisguises", () -> {
            LibsDisguises = new LibsDisguisesSupport();
        });
        this.registerCompatibility("mcMMO", () -> {
            mcMMO = new mcMMOSupport();
        });
        this.registerCompatibility("MiniaturePets", () -> {
            this.miniaturePets = Optional.of(new MPetCompat());
        });
        this.registerCompatibility("MMOItems", () -> {
            this.MMOItems = Optional.of(new MMOItemsSupport(core));
        });
        this.registerCompatibility("MythicDrops", () -> {
            MythicDrops = new MythicDropsSupport();
        });
        this.registerCompatibility("NoCheatPlus", () -> {
            this.noCheatPlus = Optional.of(new NoCheatPlusSupport());
        });
        this.registerCompatibility("OpenTerrainGenerator", () -> {
            this.openTerrainGenerator = Optional.of(new OpenTerrainGeneratorSupport());
        });
        this.registerCompatibility("PhatLoots", () -> {
            PhatLoots = new PhatLootsSupport();
        });
        this.registerCompatibility("PlaceholderAPI", () -> {
            this.placeholderAPI = Optional.of(new PlaceholderAPISupport(core));
        });
        this.registerCompatibility("SkillAPI", () -> {
            SkillAPI = new SkillAPISupport();
        });
        this.registerCompatibility("Vault", () -> {
            this.vault = Optional.of(new VaultSupport());
        });
        this.registerCompatibility("WorldGuard", () -> {
            this.worldGuard = Optional.of(new WorldGuardSupport());
        });
        this.registerCompatibility("ShopGUIPlus", () -> {
            this.shopGUIPlus = Optional.of(new ShopGUIPlusSupport(core));
        });
    }

    @Override
    public void close() {
    }

    private void registerCompatibility(String name, Runnable run) {
        try {
            if (Bukkit.getPluginManager().getPlugin(name) != null) {
                run.run();
                MythicLogger.log("Mythic " + name + " Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicLogger.errorCompatibility(name, "Plugin not found/incompatible version");
            MythicLogger.handleMinorError(er);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to enable support for " + name + ". Is it up to date?");
            ex.printStackTrace();
        }
    }

    public void setupCosmeticsBridge(CosmeticsSupport bridge) {
        this.cosmetics = Optional.of(bridge);
        MythicLogger.log("MythicCosmetics Support has been enabled!");
    }

    public void setupCrucibleBridge(CrucibleSupport bridge) {
        this.crucible = Optional.of(bridge);
        MythicLogger.log("MythicCrucible Support has been enabled!");
    }

    public void setupRPGBridge(MythicRPGSupport bridge) {
        this.rpg = Optional.of(bridge);
        MythicLogger.log("MythicRPG Support has been enabled!");
    }

    public void setupMMOBridge(MythicLibSupport bridge) {
        this.mythicLib = Optional.of(bridge);
        MythicLogger.log("MMO Plugin Support has been enabled!");
    }

    public Optional<CosmeticsSupport> getCosmetics() {
        return this.cosmetics;
    }

    public Optional<CrucibleSupport> getCrucible() {
        return this.crucible;
    }

    public Optional<MythicRPGSupport> getRpg() {
        return this.rpg;
    }

    public Optional<CitizensSupport> getCitizens() {
        return this.citizens;
    }

    public Optional<CrashClaimSupport> getCrashClaim() {
        return this.crashClaim;
    }

    public Optional<GriefPreventionSupport> getGriefPrevention() {
        return this.griefPrevention;
    }

    public Optional<LandsSupport> getLands() {
        return this.lands;
    }

    public Optional<MPetCompat> getMiniaturePets() {
        return this.miniaturePets;
    }

    public Optional<MMOItemsSupport> getMMOItems() {
        return this.MMOItems;
    }

    public Optional<MythicLibSupport> getMythicLib() {
        return this.mythicLib;
    }

    public Optional<NoCheatPlusSupport> getNoCheatPlus() {
        return this.noCheatPlus;
    }

    public Optional<OpenTerrainGeneratorSupport> getOpenTerrainGenerator() {
        return this.openTerrainGenerator;
    }

    public Optional<PlaceholderAPISupport> getPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public Optional<VaultSupport> getVault() {
        return this.vault;
    }

    public Optional<WorldGuardSupport> getWorldGuard() {
        return this.worldGuard;
    }

    public Optional<AriKeysSupport> getAriKeys() {
        return this.ariKeys;
    }

    public Optional<ShopGUIPlusSupport> getShopGUIPlus() {
        return this.shopGUIPlus;
    }

    public Optional<AbstractModelEngineSupport> getModelEngine() {
        return this.ModelEngine;
    }

    public void setModelEngine(Optional<AbstractModelEngineSupport> ModelEngine) {
        this.ModelEngine = ModelEngine;
    }
}

