/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.volatilecode.VolatileAttribute;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.inventory.ItemStack;

public class BukkitBabyZombieVillager
extends BukkitEntityType {
    private final String headString = "";
    private final ItemStack head = ItemFactory.of(Material.ZOMBIE_HEAD).build();
    private double reinforcementChance = -1.0;
    private Villager.Type villagerType;
    private Villager.Profession villagerProfession;

    @Override
    public EntityType getBukkitType() {
        return EntityType.ZOMBIE_VILLAGER;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
        String prof = mc.getNamespacedString("Options.Profession", "nitwit");
        this.villagerProfession = (Villager.Profession)Registry.VILLAGER_PROFESSION.get(NamespacedKey.fromString((String)prof));
        if (prof != null && this.villagerProfession == null) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid villager profession configured");
        }
        String type = mc.getNamespacedString("Options.Type", "plains");
        this.villagerType = (Villager.Type)Registry.VILLAGER_TYPE.get(NamespacedKey.fromString((String)type));
        if (type != null && this.villagerType == null) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid villager type configured");
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        ZombieVillager e = (ZombieVillager)this.spawnEntity(location, EntityType.ZOMBIE_VILLAGER, reason, prespawnFunc);
        e.setBaby(true);
        e.setVillagerProfession(this.villagerProfession);
        e.setVillagerType(this.villagerType);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        ZombieVillager e = (ZombieVillager)entity;
        e.getAttribute(VolatileAttribute.SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
        return entity;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitBabyZombieVillager.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        if (e instanceof ZombieVillager) {
            return ((ZombieVillager)e).isBaby();
        }
        return false;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }
}

