/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import io.papermc.paper.world.WeatheringCopperState;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitCopperGolem
extends BukkitEntityType {
    private CopperGolem.Oxidizing oxidizingState;
    private WeatheringCopperState weatheringState;

    @Override
    public EntityType getBukkitType() {
        return EntityType.COPPER_GOLEM;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        String weatheringState;
        boolean waxed = mc.getBoolean("Options.Waxed", true);
        if (waxed) {
            this.oxidizingState = CopperGolem.Oxidizing.waxed();
        }
        if ((weatheringState = mc.getString("Options.WeatheringState", null)) != null) {
            try {
                this.weatheringState = WeatheringCopperState.valueOf((String)weatheringState);
            }
            catch (Throwable ex) {
                MythicLogger.errorEntityConfig(this, mc, "Invalid Weathering State");
            }
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        CopperGolem copperGolem = (CopperGolem)entity;
        if (this.oxidizingState != null) {
            copperGolem.setOxidizing(this.oxidizingState);
        }
        if (this.weatheringState != null) {
            copperGolem.setWeatheringState(this.weatheringState);
        }
        return copperGolem;
    }
}

