/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import org.bukkit.Material;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class BukkitCreeper
extends BukkitEntityType {
    private final String headString = "";
    private final ItemStack head = ItemFactory.of(Material.CREEPER_HEAD).build();
    private boolean powered = false;
    private boolean preventSuicide = false;
    private int explosionFuseTicks = -1;
    private int explosionRadius = -1;

    @Override
    public EntityType getBukkitType() {
        return EntityType.CREEPER;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.powered = mc.getBoolean("Options.SuperCharged", false);
        this.preventSuicide = mc.getBoolean("Options.PreventSuicide", false);
        this.explosionFuseTicks = mc.getInteger("Options.FuseTicks", -1);
        this.explosionRadius = mc.getInteger("Options.ExplosionRadius", -1);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Creeper e = (Creeper)entity;
        if (this.powered) {
            e.setPowered(true);
        }
        if (this.explosionFuseTicks >= 0) {
            e.setMaxFuseTicks(this.explosionFuseTicks);
        }
        if (this.explosionRadius >= 0) {
            e.setExplosionRadius(this.explosionRadius);
        }
        return e;
    }

    public boolean preventSuicide() {
        return this.preventSuicide;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isPreventSuicide() {
        return this.preventSuicide;
    }

    public int getExplosionFuseTicks() {
        return this.explosionFuseTicks;
    }

    public int getExplosionRadius() {
        return this.explosionRadius;
    }
}

