/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pig;

public class BukkitPig
extends BukkitEntityType {
    private boolean saddled = false;
    private NamespacedKey variant;

    @Override
    public EntityType getBukkitType() {
        return EntityType.PIG;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.registerProperty(new AgeableProperty(mc));
        this.saddled = mc.getBoolean("Options.Saddled", false);
        String variant = mc.getNamespacedString(new String[]{"Variant", "Options.Variant"}, null, new String[0]);
        if (variant != null) {
            this.variant = NamespacedKey.fromString((String)variant);
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Pig.Variant variant;
        Pig e = (Pig)entity;
        e.setSaddle(this.saddled);
        if (this.variant != null && (variant = (Pig.Variant)RegistryAccess.registryAccess().getRegistry(RegistryKey.PIG_VARIANT).get(this.variant)) != null) {
            e.setVariant(variant);
        }
        return e;
    }

    public boolean isSaddled() {
        return this.saddled;
    }

    public NamespacedKey getVariant() {
        return this.variant;
    }
}

