/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Set;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;

public class BukkitWolf
extends BukkitEntityType
implements TameableEntityType {
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private boolean angry = false;
    private DyeColor color = null;
    private boolean tameable = false;
    private String variant;
    private DyeColor collarColor;

    @Override
    public EntityType getBukkitType() {
        return EntityType.WOLF;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameableProperty = new TameableProperty(mc, (Set<Material>)Sets.immutableEnumSet((Enum)Material.BONE, (Enum[])new Material[0]));
        this.angry = mc.getBoolean("Options.Angry", false);
        this.variant = mc.getString(new String[]{"Options.Variant", "Options.WolfType"}, null, new String[0]);
        String collarColor = mc.getString(new String[]{"Options.Color", "Options.CollarColor"}, null, new String[0]);
        if (collarColor != null) {
            try {
                this.collarColor = DyeColor.valueOf((String)collarColor.toUpperCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Wolf e = (Wolf)entity;
        e = (Wolf)this.ageableProperty.applyProperties((Entity)e);
        e.setAngry(this.angry);
        if (this.variant != null) {
            this.getPlugin().getVolatileCodeHandler().getCompatibilityHandler().setWolfVariant(e, this.variant);
        }
        if (this.collarColor != null) {
            e.setCollarColor(this.collarColor);
        }
        return e;
    }

    public static AbstractPlayer getOwner(ActiveMob am) {
        Wolf w;
        Entity e = BukkitAdapter.adapt(am.getEntity());
        if (e instanceof Wolf && (w = (Wolf)e).getOwner() instanceof Player) {
            return BukkitAdapter.adapt((Player)w.getOwner());
        }
        return null;
    }

    public AgeableProperty getAgeableProperty() {
        return this.ageableProperty;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }

    public boolean isAngry() {
        return this.angry;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    public String getVariant() {
        return this.variant;
    }

    public DyeColor getCollarColor() {
        return this.collarColor;
    }
}

