/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities.properties;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.entities.properties.EntityPropertySet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Raider;

public class RaiderProperty
implements EntityPropertySet {
    private boolean canJoinRaid = true;
    private boolean patrolLeader = false;
    private boolean patrolSpawnPoint = false;

    public RaiderProperty(MythicConfig mc) {
        if (mc.isSet("Options.CanJoinRaid")) {
            this.canJoinRaid = mc.getBoolean("Options.CanJoinRaid", true);
        }
        if (mc.isSet("Options.PatrolLeader")) {
            this.patrolLeader = mc.getBoolean("Options.PatrolLeader", false);
        }
        if (mc.isSet("Options.PatrolSpawnPoint")) {
            this.patrolSpawnPoint = mc.getBoolean("Options.PatrolSpawnPoint", false);
        }
    }

    @Override
    public Entity applyProperties(Entity entity) {
        Raider raider = (Raider)entity;
        raider.setCanJoinRaid(this.canJoinRaid);
        raider.setPatrolLeader(this.patrolLeader);
        raider.setPatrolTarget(entity.getLocation().getBlock());
        return raider;
    }

    public boolean isCanJoinRaid() {
        return this.canJoinRaid;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public boolean isPatrolSpawnPoint() {
        return this.patrolSpawnPoint;
    }
}

