/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities.properties.display;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.entities.properties.display.DisplayProperty;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;

public class ItemDisplayProperty
extends DisplayProperty {
    private PlaceholderString item;
    private ItemDisplay.ItemDisplayTransform transform;

    public ItemDisplayProperty(MythicConfig config) {
        super(config);
        this.item = config.getPlaceholderString("DisplayOptions.Item", "grass_block");
        this.transform = config.getEnum("DisplayOptions.Transform", ItemDisplay.ItemDisplayTransform.class, ItemDisplay.ItemDisplayTransform.NONE);
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if ((entity = super.applyProperties(entity)) instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            AbstractItemStack itemStack = MythicBukkit.inst().getBootstrap().createItem(this.item.get());
            itemDisplay.setItemStack(BukkitAdapter.adapt(itemStack));
            itemDisplay.setItemDisplayTransform(this.transform);
        }
        return entity;
    }
}

