/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.events;

import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.utils.Events;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.jetbrains.annotations.NotNull;

public class MythicHealMechanicEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    boolean cancelled = false;
    @NotNull
    final Entity target;
    double healAmount;
    private final SkillMetadata metadata;

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public Entity getTarget() {
        return this.target;
    }

    public double getHealAmount() {
        return this.healAmount;
    }

    public void setHealAmount(double heal) {
        this.healAmount = heal;
    }

    public MythicHealMechanicEvent(@NotNull SkillMetadata metadata, @NotNull Entity caster, @NotNull Entity target, double healAmount) {
        super(caster);
        this.metadata = metadata;
        this.target = target;
        this.healAmount = healAmount;
    }

    public static MythicHealMechanicEvent call(@NotNull SkillMetadata metadata, @NotNull Entity caster, @NotNull Entity target, double healAmount) {
        MythicHealMechanicEvent mythicEvent = new MythicHealMechanicEvent(metadata, caster, target, healAmount);
        Events.callSync((Event)mythicEvent);
        if (mythicEvent.isCancelled()) {
            return mythicEvent;
        }
        EntityRegainHealthEvent bukkitEvent = new EntityRegainHealthEvent(target, mythicEvent.getHealAmount(), EntityRegainHealthEvent.RegainReason.CUSTOM);
        Events.callSync((Event)bukkitEvent);
        if (bukkitEvent.isCancelled()) {
            mythicEvent.setCancelled(true);
            return mythicEvent;
        }
        mythicEvent.setHealAmount(bukkitEvent.getAmount());
        return mythicEvent;
    }

    public SkillMetadata getMetadata() {
        return this.metadata;
    }
}

