/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.listeners;

import io.lumine.mythic.api.volatilecode.virtual.PacketItemDisplay;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.constants.ItemKeys;
import io.lumine.mythic.core.glow.GlowColor;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ItemDropEffectsListener
extends ReloadableModule<MythicBukkit>
implements Listener {
    private final Map<UUID, PacketItemDisplay> itemVfxBeams = new ConcurrentHashMap<UUID, PacketItemDisplay>();

    public ItemDropEffectsListener(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        if (ServerVersion.isPaper()) {
            Events.subscribe(PlayerAttemptPickupItemEvent.class).handler(event -> {
                Item item = event.getItem();
                if (!this.shouldRemoveFancyEffects(item)) {
                    return;
                }
                this.removeFancyEffects(item);
            }).bindWith(this);
        }
    }

    @Override
    public void unload() {
        for (PacketItemDisplay display : this.itemVfxBeams.values()) {
            display.destroy();
        }
        this.itemVfxBeams.clear();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemSpawn(ItemSpawnEvent event) {
        if (!((MythicBukkit)this.getPlugin()).getConfiguration().isFancyDropsEnabledEverywhere()) {
            return;
        }
        this.applyFancyEffects(event.getEntity());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrop(PlayerDropItemEvent event) {
        if (!((MythicBukkit)this.getPlugin()).getConfiguration().isFancyDropsEnabledEverywhere()) {
            return;
        }
        this.applyFancyEffects(event.getItemDrop());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemMerge(ItemMergeEvent event) {
        Item original = event.getEntity();
        Item target = event.getTarget();
        if (this.shouldRemoveFancyEffects(original)) {
            this.removeFancyEffects(original);
        }
        if (this.shouldRemoveFancyEffects(target)) {
            this.removeFancyEffects(target);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHopperPickup(InventoryPickupItemEvent event) {
        Item item = event.getItem();
        if (this.shouldRemoveFancyEffects(item)) {
            this.removeFancyEffects(item);
        }
    }

    private boolean shouldRemoveFancyEffects(Item item) {
        ItemMeta meta = item.getItemStack().getItemMeta();
        return meta != null && meta.getPersistentDataContainer().has(ItemKeys.FANCY_DROP, PersistentDataType.STRING);
    }

    private void removeFancyEffects(Item item) {
        if (this.itemVfxBeams.containsKey(item.getUniqueId())) {
            this.itemVfxBeams.get(item.getUniqueId()).destroy();
            this.itemVfxBeams.remove(item.getUniqueId());
        }
        ItemMeta meta = item.getItemStack().getItemMeta();
        meta.getPersistentDataContainer().remove(ItemKeys.FANCY_DROP);
        item.getItemStack().setItemMeta(meta);
    }

    private void applyFancyEffects(Item item) {
        String mythicType = ((MythicBukkit)this.getPlugin()).getItemManager().getMythicTypeFromItem(item.getItemStack());
        if (mythicType == null || mythicType.isEmpty()) {
            return;
        }
        Optional<MythicItem> mythicItem = ((MythicBukkit)this.getPlugin()).getItemManager().getItem(mythicType);
        if (mythicItem.isEmpty()) {
            return;
        }
        MythicItem mItem = mythicItem.get();
        Location location = item.getLocation();
        ItemMeta meta = item.getItemStack().getItemMeta();
        if (meta.getPersistentDataContainer().has(ItemKeys.FANCY_DROP)) {
            return;
        }
        meta.getPersistentDataContainer().set(ItemKeys.FANCY_DROP, PersistentDataType.STRING, (Object)item.getUniqueId().toString());
        item.getItemStack().setItemMeta(meta);
        if (mItem.isDropGlow()) {
            try {
                GlowColor color = mItem.getDropGlowColor() != null ? GlowColor.valueOf(mItem.getDropGlowColor()) : GlowColor.WHITE;
                Schedulers.of(location).runLater(() -> {
                    ((MythicBukkit)this.getPlugin()).getGlowManager().setColor(BukkitAdapter.adapt((Entity)item), color, ((MythicBukkit)this.getPlugin()).getBootstrap().getOnlinePlayers());
                    ((MythicBukkit)this.getPlugin()).getGlowManager().setGlowing(BukkitAdapter.adapt((Entity)item), true, ((MythicBukkit)this.getPlugin()).getBootstrap().getOnlinePlayers());
                }, 1L);
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid glow color for item " + mItem.getInternalName());
            }
        }
        if (mItem.isDropVFX()) {
            ItemFactory vfxItem = mItem.getDropVFXMaterial() == null ? ItemFactory.of(Material.POTION) : ItemFactory.of(Material.valueOf((String)mItem.getDropVFXMaterial())).model(mItem.getDropVFXData());
            if (mItem.getDropVFXColor() != null) {
                vfxItem.color(mItem.getDropVFXColor());
            }
            PacketItemDisplay packetItemDisplay = PacketItemDisplay.create().item(vfxItem.build()).billboard("VERTICAL").viewRange(Float.valueOf(200.0f)).build(BukkitAdapter.adapt(location));
            packetItemDisplay.getRenderer().spawn(() -> ((MythicBukkit)this.getPlugin()).getBootstrap().getOnlinePlayers());
            packetItemDisplay.getRenderer().mountEntity(BukkitAdapter.adapt((Entity)item));
            this.itemVfxBeams.put(item.getUniqueId(), packetItemDisplay);
            Schedulers.async().runRepeating(task -> {
                if (item.isDead() || task.getTimesRan() > 10000) {
                    if (this.itemVfxBeams.containsKey(item.getUniqueId())) {
                        this.itemVfxBeams.get(item.getUniqueId()).destroy();
                        this.itemVfxBeams.remove(item.getUniqueId());
                    }
                    task.terminate();
                } else {
                    packetItemDisplay.getRenderer().updateRenderedPlayers();
                    packetItemDisplay.getRenderer().mountEntity(BukkitAdapter.adapt((Entity)item));
                    packetItemDisplay.getRenderer().update();
                }
            }, 1L, 1L);
        }
        if (mItem.isDropBeam()) {
            Schedulers.async().runRepeating(task -> {
                if (item.isDead() || task.getTimesRan() > 1000) {
                    task.terminate();
                    return;
                }
                Color color = mItem.getDropBeamColor() != null ? mItem.getDropBeamColor().toBukkitColor() : Color.WHITE;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getWorld() != item.getWorld() || player.getLocation().distance(item.getLocation()) > 50.0) continue;
                    this.createParticleBeam(player, item.getLocation(), color);
                }
            }, 2L, 2L);
        }
    }

    private void createParticleBeam(Player player, Location itemLocation, Color color) {
        for (int i = 0; i < 20; ++i) {
            Location particleLocation = itemLocation.clone().add(0.0, 1.0 + (double)i * 0.1, 0.0);
            Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
            player.spawnParticle(Particle.DUST, particleLocation, 1, 0.0, 0.0, 0.0, 1.0, (Object)dustOptions);
        }
    }
}

