/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.listeners.triggers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.BukkitBee;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.PluginModule;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.EventExecutor;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.triggers.meta.DamagedMetadata;
import io.lumine.mythic.core.skills.triggers.meta.EntityAttackMetadata;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DamageTriggerListeners
extends PluginModule<MythicBukkit> {
    public DamageTriggerListeners(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.HIGHEST).handleSubclasses().filter(event -> !event.isCancelled()).handler(this::onCombatTrigger).bindWith(this);
        Events.subscribe(EntityDamageByBlockEvent.class, EventPriority.HIGHEST).filter(event -> !event.isCancelled()).handler(this::onDamagedTrigger).bindWith(this);
        Events.subscribe(EntityDamageEvent.class, EventPriority.HIGHEST).filter(event -> !event.isCancelled()).handler(this::onDamagedTrigger).bindWith(this);
        Events.subscribe(PlayerTeleportEvent.class, EventPriority.HIGHEST).filter(event -> !event.isCancelled()).handler(this::onTeleportTrigger).bindWith(this);
    }

    @Override
    public void unload() {
    }

    protected EventExecutor eventBus() {
        return ((MythicBukkit)this.getPlugin()).getSkillManager().getEventBus();
    }

    public void onCombatTrigger(EntityDamageByEntityEvent event) {
        TriggeredSkill ts;
        Optional<Object> maybeHitboxData;
        SkillMetadata damagedSkillData;
        EntityAttackMetadata triggerMetadata;
        SkillCaster damagerCaster;
        AbstractEntity damager;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityDamageByEntityEvent[eventName={0}] fired for {1}", event.getEventName(), event.getFinalDamage());
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getDamage() <= 0.0 && event.getClass() != EntityDamageByEntityEvent.class) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Is ZeroDamage subclass, skipping", new Object[0]);
            return;
        }
        SkillTrigger attackTrigger = SkillTriggers.ATTACK;
        if (event.getDamager() instanceof LivingEntity) {
            damager = BukkitAdapter.adapt(event.getDamager());
        } else {
            Entity entity = event.getDamager();
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                ProjectileSource ps = projectile.getShooter();
                attackTrigger = projectile instanceof Trident ? SkillTriggers.PROJECTILE_HIT : SkillTriggers.BOW_HIT;
                if (ps instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)ps;
                    damager = BukkitAdapter.adapt((Entity)livingEntity);
                } else {
                    damager = null;
                }
            } else {
                damager = null;
            }
        }
        AbstractEntity damaged = event.getEntity() instanceof LivingEntity ? BukkitAdapter.adapt(event.getEntity()) : null;
        SkillCaster damagedCaster = damaged == null ? null : ((MythicBukkit)this.getPlugin()).getSkillManager().getCasterNullable(damaged);
        SkillCaster skillCaster = damagerCaster = damager == null ? null : ((MythicBukkit)this.getPlugin()).getSkillManager().getCasterNullable(damager);
        if (damagedCaster == null && damagerCaster == null) {
            return;
        }
        StatRegistry damagedStatRegistry = damagedCaster == null ? null : damagedCaster.getStatRegistry();
        StatRegistry damagerStatRegistry = damagerCaster == null ? null : damagerCaster.getStatRegistry();
        Optional<Object> maybeData = damaged.getMetadata("skill-damage");
        if (maybeData.isPresent()) {
            DamageMetadata damageData = (DamageMetadata)maybeData.get();
            if (damageData.getDamageCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK || !damageData.getBoolean("melee")) {
                attackTrigger = SkillTriggers.SKILL_HIT;
            }
            triggerMetadata = new EntityAttackMetadata(event, damageData, damager, damaged);
        } else {
            triggerMetadata = new EntityAttackMetadata(event, null, damager, damaged);
        }
        AbstractLocation origin = damaged != null ? damaged.getLocation() : BukkitAdapter.adapt(event.getEntity().getLocation());
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "[+] Damage Trigger {0} received for {1} by {2}", attackTrigger.name(), triggerMetadata.getFinalDamage(), damaged == null ? "null" : damaged.getName());
        boolean preventVanillaDamage = false;
        if (damager != null && damagerCaster instanceof ActiveMob) {
            Entity entity;
            BukkitBee bukkitBee;
            BukkitEntityType bukkitEntityType;
            ActiveMob am = (ActiveMob)damagerCaster;
            if (am.getType().getPreventVanillaDamage().booleanValue() && maybeData.isEmpty()) {
                preventVanillaDamage = true;
                event.setCancelled(true);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - PreventVanillaDamage", new Object[0]);
            }
            if (am.getOwnerUUID().isPresent() && am.getOwnerUUID().get().equals(damaged.getUniqueId())) {
                event.setCancelled(true);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Hit Owner", new Object[0]);
                return;
            }
            if (event.getDamager() instanceof Creeper && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Setting Creeper Custom Damage", new Object[0]);
                if (am.getDamage() != -1.0) {
                    triggerMetadata.setDamage(am.getDamage());
                    triggerMetadata.putBoolean("explosion", true);
                }
            }
            if ((bukkitEntityType = am.getType().getMythicEntity()) instanceof BukkitBee && (bukkitBee = (BukkitBee)bukkitEntityType).isPreventStingerLoss() && (entity = event.getDamager()) instanceof Bee) {
                Bee bee = (Bee)entity;
                Schedulers.of(event.getEntity()).runLater(() -> bee.setHasStung(false), 1L);
            }
        }
        SkillMetadata damagerSkillData = damagerCaster == null ? null : this.eventBus().buildSkillMetadata(attackTrigger, triggerMetadata, damagerCaster, damaged, origin, true);
        SkillMetadata skillMetadata = damagedSkillData = damagedCaster == null ? null : this.eventBus().buildSkillMetadata(SkillTriggers.DAMAGED, triggerMetadata, damagedCaster, damager, origin, true);
        if (((MythicBukkit)this.getPlugin()).getCompatibility().getModelEngine().isPresent() && damaged.hasMetadata("hitbox") && (maybeHitboxData = damaged.getMetadata("hitbox")).isPresent()) {
            String megHitbox = (String)maybeHitboxData.get();
            if (damagerSkillData != null) {
                damagerSkillData.getVariables().putString("hitbox", megHitbox);
            }
            if (damagedSkillData != null) {
                damagedSkillData.getVariables().putString("hitbox", megHitbox);
            }
        }
        if (damaged != null && !preventVanillaDamage) {
            if (damagedCaster instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)damagedCaster;
                if (damager != null && damagerCaster instanceof ActiveMob) {
                    ActiveMob am2 = (ActiveMob)damagerCaster;
                    if (am.getUniqueId().equals(am2.getUniqueId())) {
                        if (am.isUsingDamageSkill()) {
                            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Mob Hit Self", new Object[0]);
                            return;
                        }
                    } else if (am.getFaction() != null && am2.getFaction() != null && am.getFaction().equals(am2.getFaction())) {
                        event.setCancelled(true);
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Same Faction", new Object[0]);
                        return;
                    }
                }
                if (am.getType().getMaxAttackableRange() > 0 && damager != null) {
                    if (!damaged.getWorld().equals(damager.getWorld())) {
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Damager is out of MaxCombatRange: different world, cancelling damage.", new Object[0]);
                        event.setCancelled(true);
                        return;
                    }
                    if (damaged.getLocation().distanceSquared(damager.getLocation()) > Math.pow(am.getType().getMaxAttackableRange(), 2.0)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Damager is out of MaxCombatRange, cancelling damage.", new Object[0]);
                        event.setCancelled(true);
                        return;
                    }
                } else if (am.getType().getMaxAttackableRange() == 0) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "MythicMob is not attackable, cancelling damage.", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (am.hasImmunityTable()) {
                    if (am.getImmunityTable().onCooldown(damager)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Immunity Table on Cooldown", new Object[0]);
                        event.setCancelled(true);
                        return;
                    }
                    if (event.getFinalDamage() > 0.0) {
                        am.getImmunityTable().setCooldown(damager);
                    }
                    Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(0), 1L);
                }
                if (am.getType().getShowNameOnDamaged()) {
                    event.getEntity().setCustomNameVisible(true);
                }
                if (am.getType().getDamageModifiers() != null) {
                    double modb;
                    String damageType = triggerMetadata.getDamageCause().toUpperCase();
                    double mod = am.getType().getDamageModifiers().getOrDefault(damageType, 1.0);
                    double damageModifier = triggerMetadata.getDamageModifier() * mod;
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "DamageModifierStat for type {0} is {1}, setting damage modifier to {2}", damageType, mod, damageModifier);
                    if (triggerMetadata.getBonusDamage() != null) {
                        for (Map.Entry entry : triggerMetadata.getBonusDamage().entrySet()) {
                            modb = am.getType().getDamageModifiers().getOrDefault(entry.getKey(), 1.0);
                            entry.setValue((Double)entry.getValue() * modb);
                        }
                    }
                    if (triggerMetadata.getTags() != null) {
                        for (String string : triggerMetadata.getTags()) {
                            modb = am.getType().getDamageModifiers().getOrDefault(string, 1.0);
                            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "DamageModifier for tag {0} is {1}, setting damage modifier to {2}", string, modb, damageModifier *= modb);
                        }
                    }
                    triggerMetadata.setDamageModifier(damageModifier);
                }
                if (am.getType().getEntityDamageModifiers() != null) {
                    double damage = triggerMetadata.getDamage();
                    double mod = am.getType().getEntityDamageModifiers().getOrDefault(event.getDamager().getType().toString(), 1.0);
                    if (mod != 1.0) {
                        damage *= mod;
                    }
                    triggerMetadata.setDamage(damage);
                }
            }
            if (damagerStatRegistry != null) {
                this.eventBus().processStatsPre(damagerSkillData, triggerMetadata, damagerStatRegistry);
            }
            if (damagedCaster != null && damagedStatRegistry != null) {
                this.eventBus().processStatsPre(damagedSkillData, triggerMetadata, damagedStatRegistry);
            }
            if (damaged.getBukkitEntity() instanceof ArmorStand) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Damaged ArmorStand - Returning", new Object[0]);
                return;
            }
        }
        if (damager != null && damagerCaster != null && (!damagerCaster.isUsingDamageSkill() || triggerMetadata.getBoolean("trigger_skills")) && (ts = this.eventBus().processTriggerMechanics(damagerSkillData, triggerMetadata)).getCancelled()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Cancelled by mechanics", new Object[0]);
            event.setCancelled(true);
        }
        if (damagedCaster != null && (ts = this.eventBus().processTriggerMechanics(damagedSkillData, triggerMetadata)).getCancelled()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Cancelled by Damaged's Skills", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (damager != null && !preventVanillaDamage) {
            if (damagerStatRegistry != null) {
                this.eventBus().processStatsPost(damagerSkillData, triggerMetadata, damagerStatRegistry);
            }
            if (damagedStatRegistry != null) {
                this.eventBus().processStatsPost(damagedSkillData, triggerMetadata, damagedStatRegistry);
            }
        }
        if (preventVanillaDamage) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Vanilla Damage Prevented", new Object[0]);
            return;
        }
        double damage = triggerMetadata.getFinalDamage();
        if (damage > 0.0) {
            event.setDamage(damage);
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Final Damage] is {0}", damage);
            if (damagedCaster instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)damagedCaster;
                Schedulers.sync().runLater(() -> am.signalDamaged(), 1L);
                if (damager != null) {
                    if (am.getType().usesThreatTable() && !am.getEntity().getUniqueId().equals(damager.getUniqueId()) && am.getType().getThreatTableUseDamageTaken()) {
                        am.getThreatTable().threatGain(damager, damage);
                    }
                    if (damager.isPlayer() && am.getType().getDamageLeaderboard().booleanValue()) {
                        am.recordPlayerDamage(damager.getUniqueId(), damage);
                    }
                }
            }
        } else if (damage == 0.0) {
            if (((MythicBukkit)this.plugin).getConfiguration().isCancelDamageIfZero()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Zero Damage and configured to cancel", new Object[0]);
                event.setCancelled(true);
                event.setDamage(0.0);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Final Damage] is Zero", new Object[0]);
                event.setDamage(0.0);
            }
        } else if (damage < 0.0) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Less Than Zero, Healing", new Object[0]);
            event.setDamage(0.0);
            event.setCancelled(true);
            if (damaged.getHealth() - damage > damaged.getMaxHealth()) {
                damaged.setHealth(damaged.getMaxHealth());
            } else {
                damaged.setHealth(damaged.getHealth() - damage);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "---------- [END] ----------", new Object[0]);
    }

    public void onDamagedTrigger(EntityDamageByBlockEvent event) {
        double damage;
        TriggeredSkill ts;
        Optional<Object> maybeHitboxData;
        SkillMetadata damagedSkillData;
        SkillCaster damagedCaster;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityDamageByBlockEvent fired for {0}", event.getFinalDamage());
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (((MythicBukkit)this.getPlugin()).getMobManager().isIgnoredEntity(event.getEntity().getUniqueId())) {
            return;
        }
        AbstractEntity damaged = BukkitAdapter.adapt(event.getEntity());
        SkillCaster skillCaster = damagedCaster = damaged == null ? null : ((MythicBukkit)this.getPlugin()).getSkillManager().getCasterNullable(damaged);
        if (damagedCaster == null) {
            return;
        }
        StatRegistry damagedStatRegistry = damagedCaster == null ? null : damagedCaster.getStatRegistry();
        DamagedMetadata triggerMetadata = new DamagedMetadata((EntityDamageEvent)event, damaged);
        AbstractLocation origin = damaged != null ? damaged.getLocation() : BukkitAdapter.adapt(event.getEntity().getLocation());
        SkillMetadata skillMetadata = damagedSkillData = damagedCaster == null ? null : this.eventBus().buildSkillMetadata(SkillTriggers.DAMAGED, triggerMetadata, damagedCaster, null, origin, true);
        if (((MythicBukkit)this.getPlugin()).getCompatibility().getModelEngine().isPresent() && damaged.hasMetadata("hitbox") && (maybeHitboxData = damaged.getMetadata("hitbox")).isPresent()) {
            String megHitbox = (String)maybeHitboxData.get();
            if (damagedSkillData != null) {
                damagedSkillData.getVariables().putString("hitbox", megHitbox);
            }
        }
        if (damagedCaster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)damagedCaster;
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "MythicMob " + am.getType().getInternalName() + " took damage!", new Object[0]);
            if (am.getType().getIsInvincible()) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MythicMob is Invincible, canceling damage.", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (am.hasImmunityTable()) {
                if (am.getImmunityTable().onCooldown(null)) {
                    event.setCancelled(true);
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MythicMob is currently immune to damage from non-player sources!", new Object[0]);
                    return;
                }
                am.getImmunityTable().setCooldown(null);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Setting MythicMob immune to damage from non-player sources!", new Object[0]);
            }
            if (am.getType().getDamageModifiers() != null) {
                String damageType = event.getCause().toString();
                double mod = am.getType().getDamageModifiers().getOrDefault(damageType.toUpperCase(), 1.0);
                if (mod != 1.0) {
                    double newdamage = triggerMetadata.getDamage() * mod;
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "DamageModifierStat for type {0} is {1}, setting damage to {2}", am.getMobType(), mod, newdamage);
                    triggerMetadata.setDamage(newdamage);
                }
            }
            if (am.hasImmunityTable()) {
                Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(0), 1L);
            } else if (am.getNoDamageTicks() != 20) {
                Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(am.getNoDamageTicks()), 1L);
            }
        }
        if (damagedStatRegistry != null) {
            this.eventBus().processStatsPre(damagedSkillData, triggerMetadata, damagedStatRegistry);
        }
        if ((ts = this.eventBus().processTriggerMechanics(damagedSkillData, triggerMetadata)).getCancelled()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Cancelled by Damaged's Skills", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (damagedStatRegistry != null) {
            this.eventBus().processStatsPost(damagedSkillData, triggerMetadata, damagedStatRegistry);
        }
        if ((damage = triggerMetadata.getFinalDamage()) > 0.0) {
            event.setDamage(damage);
            if (damagedCaster instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)damagedCaster;
                Schedulers.sync().runLater(() -> am.signalDamaged(), 1L);
            }
        } else if (damage == 0.0 && ((MythicBukkit)this.plugin).getConfiguration().isCancelDamageIfZero()) {
            event.setDamage(0.0);
            event.setCancelled(true);
        } else if (damage < 0.0) {
            event.setDamage(0.0);
            event.setCancelled(true);
            if (damaged.getHealth() - damage > damaged.getMaxHealth()) {
                damaged.setHealth(damaged.getMaxHealth());
            } else {
                damaged.setHealth(damaged.getHealth() - damage);
            }
        }
    }

    public void onDamagedTrigger(EntityDamageEvent event) {
        double damage;
        TriggeredSkill ts;
        Optional<Object> maybeHitboxData;
        SkillMetadata damagedSkillData;
        SkillCaster damagedCaster;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityDamageEvent fired for {0}", event.getFinalDamage());
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (((MythicBukkit)this.getPlugin()).getMobManager().isIgnoredEntity(event.getEntity().getUniqueId())) {
            return;
        }
        AbstractEntity damaged = BukkitAdapter.adapt(event.getEntity());
        SkillCaster skillCaster = damagedCaster = damaged == null ? null : ((MythicBukkit)this.getPlugin()).getSkillManager().getCasterNullable(damaged);
        if (damagedCaster == null) {
            return;
        }
        StatRegistry damagedStatRegistry = damagedCaster == null ? null : damagedCaster.getStatRegistry();
        DamagedMetadata triggerMetadata = new DamagedMetadata(event, damaged);
        AbstractLocation origin = damaged != null ? damaged.getLocation() : BukkitAdapter.adapt(event.getEntity().getLocation());
        SkillMetadata skillMetadata = damagedSkillData = damagedCaster == null ? null : this.eventBus().buildSkillMetadata(SkillTriggers.DAMAGED, triggerMetadata, damagedCaster, null, origin, true);
        if (((MythicBukkit)this.getPlugin()).getCompatibility().getModelEngine().isPresent() && damaged.hasMetadata("hitbox") && (maybeHitboxData = damaged.getMetadata("hitbox")).isPresent()) {
            String megHitbox = (String)maybeHitboxData.get();
            if (damagedSkillData != null) {
                damagedSkillData.getVariables().putString("hitbox", megHitbox);
            }
        }
        if (damagedCaster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)damagedCaster;
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "MythicMob " + am.getType().getInternalName() + " took damage!", new Object[0]);
            if (am.getType().getIsInvincible()) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MythicMob is Invincible, canceling damage.", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (am.hasImmunityTable()) {
                if (am.getImmunityTable().onCooldown(null)) {
                    event.setCancelled(true);
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MythicMob is currently immune to damage from non-player sources!", new Object[0]);
                    return;
                }
                am.getImmunityTable().setCooldown(null);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Setting MythicMob immune to damage from non-player sources!", new Object[0]);
            }
            if (am.getType().getDamageModifiers() != null) {
                String damageType = event.getCause().toString();
                double mod = am.getType().getDamageModifiers().getOrDefault(damageType.toUpperCase(), 1.0);
                if (mod != 1.0) {
                    double newdamage = triggerMetadata.getDamage() * mod;
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "DamageModifierStat for type {0} is {1}, setting damage to {2}", am.getMobType(), mod, newdamage);
                    triggerMetadata.setDamage(newdamage);
                }
            }
            if (am.hasImmunityTable()) {
                Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(0), 1L);
            } else if (am.getNoDamageTicks() != 20) {
                Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(am.getNoDamageTicks()), 1L);
            }
            if (am.getType().getDigOutOfGround().booleanValue() && event.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
                damaged.teleport(damaged.getLocation().add(0.0, 2.0, 0.0));
                event.setCancelled(true);
                return;
            }
        }
        if (damagedStatRegistry != null) {
            this.eventBus().processStatsPre(damagedSkillData, triggerMetadata, damagedStatRegistry);
        }
        if ((ts = this.eventBus().processTriggerMechanics(damagedSkillData, triggerMetadata)).getCancelled()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Cancelled by Damaged's Skills", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (damagedStatRegistry != null) {
            this.eventBus().processStatsPost(damagedSkillData, triggerMetadata, damagedStatRegistry);
        }
        if ((damage = triggerMetadata.getFinalDamage()) > 0.0) {
            event.setDamage(damage);
            if (damagedCaster instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)damagedCaster;
                Schedulers.sync().runLater(() -> am.signalDamaged(), 1L);
            }
        } else if (damage == 0.0 && ((MythicBukkit)this.plugin).getConfiguration().isCancelDamageIfZero()) {
            event.setDamage(0.0);
            event.setCancelled(true);
        } else if (damage < 0.0) {
            event.setDamage(0.0);
            event.setCancelled(true);
            if (damaged.getHealth() - damage > damaged.getMaxHealth()) {
                damaged.setHealth(damaged.getMaxHealth());
            } else {
                damaged.setHealth(damaged.getHealth() - damage);
            }
        }
    }

    public void onTeleportTrigger(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        AbstractPlayer aPlayer = BukkitAdapter.adapt(player);
        SkillCaster caster = ((MythicBukkit)this.getPlugin()).getSkillManager().getCaster(aPlayer);
        AbstractLocation origin = BukkitAdapter.adapt(event.getTo());
        if (caster == null) {
            return;
        }
        SkillMetadata meta = this.eventBus().buildSkillMetadata(SkillTriggers.TELEPORT, caster, caster.getEntity(), origin, true);
        meta.setMetadata("teleport-cause", (Object)event.getCause());
        TriggeredSkill ts = this.eventBus().processTriggerMechanics(meta);
        if (ts.getCancelled()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "[Cancel Damage] - Cancelled by Damaged's Skills", new Object[0]);
            event.setCancelled(true);
            return;
        }
    }
}

