/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.MaterialProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ItemProp
extends PropertyType<ItemStack> {
    private ItemStack defaultValue;
    private MaterialProp MATERIAL;
    private StringProp ITEM_MODEL;
    private IntProp AMOUNT;
    private StringProp DISPLAY;
    private StringListProp LORE;
    private BooleanProp HIDE_FLAGS;
    private StringProp COLOR;
    private StringProp SKULL_OWNER;
    private StringProp SKULL_TEXTURE;

    public ItemProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, (String)node);
        node = node == null || ((String)node).isEmpty() ? "" : (String)node + ".";
        this.MATERIAL = new MaterialProp(plugin, file, (String)node + "Material", Material.AIR);
        this.ITEM_MODEL = new StringProp(plugin, file, (String)node + "ItemModel", null);
        this.AMOUNT = new IntProp(plugin, file, (String)node + "Amount", 1);
        this.DISPLAY = new StringProp(plugin, file, (String)node + "Display", " ");
        this.LORE = new StringListProp(plugin, file, (String)node + "Lore");
        this.HIDE_FLAGS = new BooleanProp(plugin, file, (String)node + "HideFlags", false);
        this.COLOR = new StringProp(plugin, file, (String)node + "Color", null);
        this.SKULL_OWNER = new StringProp(plugin, file, (String)node + "SkullOwner", null);
        this.SKULL_TEXTURE = new StringProp(plugin, file, (String)node + "SkullTexture", null);
        this.defaultValue = new ItemStack(Material.STONE);
    }

    public ItemProp(LuminePlugin plugin, Object file, String node, ItemStack defaultValue) {
        super(plugin, file, node);
        this.defaultValue = defaultValue;
    }

    @Override
    protected ItemStack compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.defaultValue;
        }
        if (!section.isConfigurationSection(node)) {
            try {
                String str = section.getString(node);
                Material mat = Material.valueOf((String)str.toUpperCase());
                return new ItemStack(mat);
            }
            catch (Throwable ex) {
                return new ItemStack(Material.STONE);
            }
        }
        Material material = (Material)this.MATERIAL.get(section);
        String modelNode = node + "Model";
        if (material == Material.AIR) {
            if (section.isSet(modelNode)) {
                material = Material.PAPER;
            } else {
                return this.defaultValue;
            }
        }
        int amount = (Integer)this.AMOUNT.get(section);
        String display = (String)this.DISPLAY.get(section);
        List lore = (List)this.LORE.get(section);
        String itemModel = (String)this.ITEM_MODEL.get(section);
        boolean hideFlags = (Boolean)this.HIDE_FLAGS.get(section);
        String color = (String)this.COLOR.get(section);
        String skullOwner = (String)this.SKULL_OWNER.get(section);
        String skullTexture = (String)this.SKULL_TEXTURE.get(section);
        ItemFactory factory = ItemFactory.of(material).name(display).lore(lore).amount(amount);
        if (itemModel != null) {
            try {
                factory.itemModel(itemModel);
            }
            catch (IllegalArgumentException exception) {
                Log.error("Error while setting ItemProp item model " + itemModel + ": " + exception.getMessage());
            }
        }
        if (section.isSet(modelNode)) {
            if (section.isInt(modelNode)) {
                factory.model(section.getInt(modelNode));
            } else if (section.isString(modelNode)) {
                factory.itemModel(section.getString(modelNode));
            }
        }
        if (color != null) {
            factory.color(color);
        }
        if (hideFlags) {
            factory.hideAttributes();
        }
        if (skullOwner != null) {
            factory.skullOwner(skullOwner);
        }
        return factory.build();
    }

    @Override
    public void set(String holder, ItemStack value) {
        if (this.config == null) {
            return;
        }
    }

    @Override
    public ItemStack getDefaultValue() {
        return this.defaultValue;
    }
}

