/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.gson.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.lumine.mythic.bukkit.utils.annotation.NonnullByDefault;
import io.lumine.mythic.bukkit.utils.gson.converters.GsonConverter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@NonnullByDefault
abstract class AbstractGsonConverter<M extends Map<String, Object>, L extends List<Object>, S extends Set<Object>>
implements GsonConverter {
    AbstractGsonConverter() {
    }

    protected abstract MapBuilder<M, String, Object> newMapBuilder();

    protected abstract ListBuilder<L, Object> newListBuilder();

    protected abstract SetBuilder<S, Object> newSetBuilder();

    public M unwrapObject(JsonObject object) {
        MapBuilder<M, String, Object> builder = this.newMapBuilder();
        for (Map.Entry e : object.entrySet()) {
            builder.put((String)e.getKey(), this.unwrapElement((JsonElement)e.getValue()));
        }
        return builder.build();
    }

    public L unwrapArray(JsonArray array) {
        ListBuilder<L, Object> builder = this.newListBuilder();
        for (JsonElement element : array) {
            builder.add(this.unwrapElement(element));
        }
        return builder.build();
    }

    public S unwrapArrayToSet(JsonArray array) {
        SetBuilder<S, Object> builder = this.newSetBuilder();
        for (JsonElement element : array) {
            builder.add(this.unwrapElement(element));
        }
        return builder.build();
    }

    @Override
    public Object unwarpPrimitive(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf(primitive));
    }

    @Override
    @Nullable
    public Object unwrapElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonArray()) {
            return this.unwrapArray(element.getAsJsonArray());
        }
        if (element.isJsonObject()) {
            return this.unwrapObject(element.getAsJsonObject());
        }
        if (element.isJsonPrimitive()) {
            return this.unwarpPrimitive(element.getAsJsonPrimitive());
        }
        throw new IllegalArgumentException("Unknown element type: " + String.valueOf(element));
    }

    @Override
    public JsonElement wrap(Object object) {
        if (object instanceof JsonElement) {
            return (JsonElement)object;
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            JsonArray array = new JsonArray();
            for (Object o : iterable) {
                array.add(this.wrap(o));
            }
            return array;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            JsonObject obj = new JsonObject();
            for (Map.Entry e : map.entrySet()) {
                if (!(e.getKey() instanceof String)) continue;
                String key = (String)e.getKey();
                obj.add(key, this.wrap(e.getValue()));
            }
            return obj;
        }
        if (object instanceof String) {
            return new JsonPrimitive((String)object);
        }
        if (object instanceof Character) {
            return new JsonPrimitive((Character)object);
        }
        if (object instanceof Boolean) {
            return new JsonPrimitive((Boolean)object);
        }
        if (object instanceof Number) {
            return new JsonPrimitive((Number)object);
        }
        throw new IllegalArgumentException("Unable to wrap object: " + String.valueOf(object.getClass()));
    }

    protected static interface MapBuilder<M extends Map<K, V>, K, V> {
        public void put(@Nullable K var1, @Nullable V var2);

        public M build();
    }

    protected static interface ListBuilder<L extends List<E>, E> {
        public void add(@Nullable E var1);

        public L build();
    }

    protected static interface SetBuilder<S extends Set<E>, E> {
        public void add(@Nullable E var1);

        public S build();
    }
}

