/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.ConstraintEnforcementStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractName;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractNamed;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.PrimaryKeyConstraintImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

abstract class AbstractConstraint
extends AbstractNamed
implements ConstraintEnforcementStep {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONSTRAINT};
    static final Set<SQLDialect> NO_SUPPORT_NAMED = SQLDialect.supportedBy(new SQLDialect[0]);
    static final Set<SQLDialect> NO_SUPPORT_NAMED_PK = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);
    boolean enforced = true;

    AbstractConstraint() {
        this(null);
    }

    AbstractConstraint(Name name) {
        this(name, false);
    }

    AbstractConstraint(Name name, boolean enforced) {
        super(name, null);
        this.enforced = enforced;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean named;
        boolean bl = named = !this.getQualifiedName().equals(AbstractName.NO_NAME);
        if (named && Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE))) {
            ctx.visit(this.getQualifiedName());
        } else {
            if (!(!named || NO_SUPPORT_NAMED.contains((Object)ctx.dialect()) || this instanceof PrimaryKeyConstraintImpl && NO_SUPPORT_NAMED_PK.contains((Object)ctx.dialect()))) {
                ctx.visit(Keywords.K_CONSTRAINT).sql(' ').visit(this.getUnqualifiedName()).sql(' ');
            }
            this.accept0(ctx);
            if (!this.enforced) {
                AbstractConstraint.acceptEnforced(ctx, this.enforced);
            }
        }
    }

    abstract void accept0(Context<?> var1);

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    static void acceptEnforced(Context<?> ctx, boolean enforced) {
        switch (ctx.family()) {
            default: 
        }
        if (enforced) {
            ctx.sql(' ').visit(Keywords.K_ENFORCED);
        } else {
            ctx.sql(' ').visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_ENFORCED);
        }
    }

    abstract boolean supported(Context<?> var1, Table<?> var2);

    @Override
    public final AbstractConstraint enforced() {
        this.enforced = true;
        return this;
    }

    @Override
    public final AbstractConstraint notEnforced() {
        this.enforced = false;
        return this;
    }

    public final boolean $enforced() {
        return this.enforced;
    }
}

