/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Data;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.ParamMode;
import io.lumine.mythic.bukkit.utils.lib.jooq.QualifiedRecord;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractParamX;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultBinding;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Internal;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.LazyName;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SimpleQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.util.Arrays;
import java.util.Set;

abstract class AbstractParam<T>
extends AbstractParamX<T>
implements SimpleQueryPart {
    private static Set<SQLDialect> NO_SUPPORT_ARRAY_BINDS = SQLDialect.supportedBy(SQLDialect.TRINO);
    private static Set<SQLDialect> NO_SUPPORT_INTERVAL_BINDS = SQLDialect.supportedBy(SQLDialect.TRINO);
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD, Clause.FIELD_VALUE};
    private final String paramName;
    T value;
    private boolean inline;

    AbstractParam(T value, DataType<T> type) {
        this(value, type, null);
    }

    AbstractParam(T value, DataType<T> type, String paramName) {
        super(AbstractParam.name(value, paramName), type);
        this.paramName = paramName;
        this.value = value;
    }

    @Override
    final boolean isNullable() {
        return !this.inline || this.value == null;
    }

    static final Name name(Object value, String paramName) {
        return new LazyName(() -> {
            String string;
            if (paramName != null) {
                string = paramName;
            } else if (value instanceof QualifiedRecord) {
                QualifiedRecord q = (QualifiedRecord)value;
                string = q.getQualifier().getName();
            } else {
                string = AbstractParam.name(value);
            }
            return DSL.name(string);
        });
    }

    private static final String name(Object value) {
        if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            return "b_" + Internal.hash0(Arrays.hashCode(Arrays.copyOf(b, 16)));
        }
        if (value instanceof Object[]) {
            Object[] o = (Object[])value;
            return "a_" + Internal.hash0(Arrays.hashCode(Arrays.copyOf(o, 16)));
        }
        if (value instanceof Data) {
            Data d = (Data)value;
            return d.data();
        }
        return String.valueOf(value);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        return this.getBinding() instanceof DefaultBinding.InternalBinding && AbstractParam.positive(this.value);
    }

    private static boolean positive(Object value) {
        Number n;
        return value instanceof Number ? (n = (Number)value).doubleValue() >= 0.0 : false;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    final void setConverted0(Object value) {
        this.value = this.getDataType().convert(value);
    }

    @Override
    public final T getValue() {
        return this.value;
    }

    @Override
    public final String getParamName() {
        return this.paramName;
    }

    @Override
    final void setInline0(boolean inline) {
        this.inline = inline;
    }

    @Override
    public final boolean isInline() {
        return this.inline;
    }

    boolean isInline(Context<?> ctx) {
        return this.isInline() || ctx.paramType() == ParamType.INLINED || ctx.paramType() == ParamType.NAMED_OR_INLINED && StringUtils.isBlank(this.paramName) || NO_SUPPORT_ARRAY_BINDS.contains((Object)ctx.dialect()) && this.getDataType().isArray() || NO_SUPPORT_INTERVAL_BINDS.contains((Object)ctx.dialect()) && this.getDataType().isInterval();
    }

    @Override
    public final ParamType getParamType() {
        return this.inline ? ParamType.INLINED : (StringUtils.isBlank(this.paramName) ? ParamType.INDEXED : ParamType.NAMED);
    }

    @Override
    public final ParamMode getParamMode() {
        return ParamMode.IN;
    }

    @Override
    public void accept(Context<?> ctx) {
    }

    @Override
    public final T $value() {
        return this.value;
    }

    @Override
    public final boolean $inline() {
        return this.inline;
    }

    @Override
    public Param<T> $value(T newValue) {
        throw new QOM.NotYetImplementedException();
    }

    @Override
    public Param<T> $inline(boolean inline) {
        throw new QOM.NotYetImplementedException();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Param) {
            Param p = (Param)that;
            Object thatValue = p.getValue();
            if (this.value == null) {
                return thatValue == null;
            }
            if (this.value instanceof byte[] && thatValue instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])thatValue);
            }
            if (this.value instanceof Object[] && thatValue instanceof Object[]) {
                return Arrays.equals((Object[])this.value, (Object[])thatValue);
            }
            return this.value.equals(thatValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n;
        if (this.value == null) {
            n = 0;
        } else {
            T t2 = this.value;
            if (t2 instanceof byte[]) {
                byte[] a = (byte[])t2;
                n = Arrays.hashCode(a);
            } else {
                t2 = this.value;
                if (t2 instanceof Object[]) {
                    Object[] a = (Object[])t2;
                    n = Arrays.hashCode(a);
                } else {
                    n = this.value.hashCode();
                }
            }
        }
        return n;
    }
}

