/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SelectQueryImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.TableAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.List;

final class AliasedSelect<R extends Record>
extends AbstractTable<R>
implements QOM.UTransient {
    private final Select<R> query;
    private final boolean subquery;
    private final boolean ignoreOrderBy;
    private final boolean forceLimit;
    private final Name[] aliases;

    AliasedSelect(Select<R> query, boolean subquery, boolean ignoreOrderBy, boolean forceLimit, Name ... aliases) {
        super(TableOptions.expression(), Names.NQ_SELECT);
        this.query = query;
        this.subquery = subquery;
        this.ignoreOrderBy = ignoreOrderBy;
        this.forceLimit = forceLimit;
        this.aliases = aliases;
    }

    final Select<R> query() {
        return this.query;
    }

    @Override
    public final Table<R> as(Name alias) {
        SelectQueryImpl q = Tools.selectQueryImpl(this.query);
        List<Field<?>> f = q.getSelect();
        if (q != null && (this.ignoreOrderBy && !q.getOrderBy().isEmpty() || Tools.hasEmbeddedFields(f) || Tools.isEmpty(this.aliases))) {
            if (Tools.isEmpty(this.aliases)) {
                return this.query.asTable(alias, Tools.fieldNames(Tools.collect(Tools.flattenCollection(f)).size()));
            }
            return this.query.asTable(alias, this.aliases);
        }
        return new TableAlias(this, alias, true);
    }

    @Override
    public final Table<R> as(Name alias, Name ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, true);
    }

    @Override
    final FieldsImpl<R> fields0() {
        return new FieldsImpl(this.query.asTable(Names.N_T, this.aliases).fields());
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.query.getRecordType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.forceLimit) {
            ctx.data(Tools.BooleanDataKey.DATA_FORCE_LIMIT_WITH_ORDER_BY, true, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        SelectQueryImpl q = Tools.selectQueryImpl(this.query);
        if (ctx.family() == SQLDialect.DERBY && q != null && q.hasUnions()) {
            Tools.visitSubquery(ctx, DSL.selectFrom(this.query.asTable(Names.N_T, this.aliases)), 1, false);
        } else {
            ctx.data(Tools.SimpleDataKey.DATA_SELECT_ALIASES, this.aliases, this.subquery ? c -> Tools.visitSubquery(c, this.query, 1, false) : c -> c.visit(this.query));
        }
    }

    static final boolean avoidAliasPushdown(Context<?> ctx, Select<?> query) {
        SelectQueryImpl q = Tools.selectQueryImpl(query);
        return q != null && (ctx.family() == SQLDialect.DERBY && q.hasUnions() || !q.getOrderBy().isEmpty() || Tools.hasEmbeddedFields(q.getSelect()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

