/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class ArrayPrepend<T>
extends AbstractField<T[]>
implements QOM.ArrayPrepend<T> {
    final Field<T> prepend;
    final Field<T[]> array;

    ArrayPrepend(Field<T> prepend, Field<T[]> array) {
        super(Names.N_ARRAY_PREPEND, Tools.allNotNull(Tools.dataType(SQLDataType.OTHER.array(), array, false), prepend, array));
        this.prepend = Tools.nullSafeNotNull(prepend, SQLDataType.OTHER);
        this.array = Tools.nullSafeNotNull(array, SQLDataType.OTHER.array());
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: 
            case TRINO: {
                return false;
            }
            case CLICKHOUSE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: 
            case TRINO: {
                ctx.visit(DSL.arrayConcat(DSL.array(this.prepend), this.array));
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_arrayPushFront, this.getDataType(), this.array, this.prepend));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_ARRAY_PREPEND, this.getDataType(), this.prepend, this.array));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.prepend;
    }

    @Override
    public final Field<T[]> $arg2() {
        return this.array;
    }

    @Override
    public final QOM.ArrayPrepend<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T[]>)this.$arg2());
    }

    @Override
    public final QOM.ArrayPrepend<T> $arg2(Field<T[]> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T[]>, ? extends QOM.ArrayPrepend<T>> $constructor() {
        return (a1, a2) -> new ArrayPrepend(a1, (Field<T[]>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayPrepend) {
            QOM.ArrayPrepend o = (QOM.ArrayPrepend)that;
            return StringUtils.equals(this.$prepend(), o.$prepend()) && StringUtils.equals(this.$array(), o.$array());
        }
        return super.equals(that);
    }
}

