/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class ArrayRemove<T>
extends AbstractField<T[]>
implements QOM.ArrayRemove<T> {
    final Field<T[]> array;
    final Field<T> remove;

    ArrayRemove(Field<T[]> array, Field<T> remove) {
        super(Names.N_ARRAY_REMOVE, Tools.allNotNull(Tools.dataType(SQLDataType.OTHER.array(), array, false), array, remove));
        this.array = Tools.nullSafeNotNull(array, SQLDataType.OTHER.array());
        this.remove = Tools.nullSafeNotNull(remove, SQLDataType.OTHER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: 
            case H2: 
            case HSQLDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: 
            case H2: 
            case HSQLDB: {
                ctx.visit(DSL.arrayFilter(this.array, e -> e.ne(this.remove)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_ARRAY_REMOVE, this.getDataType(), this.array, this.remove));
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.array;
    }

    @Override
    public final Field<T> $arg2() {
        return this.remove;
    }

    @Override
    public final QOM.ArrayRemove<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.ArrayRemove<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T[]>, ? super Field<T>, ? extends QOM.ArrayRemove<T>> $constructor() {
        return (a1, a2) -> new ArrayRemove((Field<T[]>)a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayRemove) {
            QOM.ArrayRemove o = (QOM.ArrayRemove)that;
            return StringUtils.equals(this.$array(), o.$array()) && StringUtils.equals(this.$remove(), o.$remove());
        }
        return super.equals(that);
    }
}

