/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Comment;
import io.lumine.mythic.bukkit.utils.lib.jooq.CommentOnFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.CommentOnIsStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function5;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import java.util.Set;

final class CommentOnImpl
extends AbstractDDLQuery
implements QOM.CommentOn,
CommentOnIsStep,
CommentOnFinalStep {
    final Table<?> table;
    final boolean isView;
    final boolean isMaterializedView;
    final Field<?> field;
    Comment comment;
    private static final Set<SQLDialect> NO_SUPPORT_COMMENT_ON_VIEW = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE, SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_COMMENT_ON_MATERIALIZED_VIEW = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE, SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE, SQLDialect.TRINO);

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, boolean isMaterializedView, Field<?> field) {
        this(configuration, table, isView, isMaterializedView, field, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, boolean isMaterializedView) {
        this(configuration, table, isView, isMaterializedView, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, boolean isMaterializedView, Field<?> field, Comment comment) {
        super(configuration);
        this.table = table;
        this.isView = isView;
        this.isMaterializedView = isMaterializedView;
        this.field = field;
        this.comment = comment;
    }

    @Override
    public final CommentOnImpl is(String comment) {
        return this.is(DSL.comment(comment));
    }

    @Override
    public final CommentOnImpl is(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.table != null) {
                    this.acceptMySQL(ctx);
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            case CLICKHOUSE: {
                if (this.table != null) {
                    ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_MODIFY).sql(' ').visit(Keywords.K_COMMENT).sql(' ').visit(this.comment);
                    break;
                }
                ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(DSL.table(this.field.getQualifiedName().qualifier())).sql(' ').visit(Keywords.K_COMMENT).sql(' ').visit(Keywords.K_COLUMN).sql(' ').visit(DSL.field(this.field.getUnqualifiedName())).sql(' ').visit(this.comment);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptMySQL(Context<?> ctx) {
        ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_COMMENT).sql(" = ").visit(this.comment);
    }

    private final void acceptDefault(Context<?> ctx) {
        ctx.visit(Keywords.K_COMMENT).sql(' ').visit(Keywords.K_ON).sql(' ');
        if (this.table != null) {
            if (this.isView && !NO_SUPPORT_COMMENT_ON_VIEW.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_VIEW).sql(' ');
            } else if (this.isMaterializedView && !NO_SUPPORT_COMMENT_ON_MATERIALIZED_VIEW.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_MATERIALIZED).sql(' ').visit(Keywords.K_VIEW).sql(' ');
            } else {
                ctx.visit(Keywords.K_TABLE).sql(' ');
            }
            ctx.visit(this.table);
        } else if (this.field != null) {
            ctx.visit(Keywords.K_COLUMN).sql(' ').visit(this.field);
        } else {
            throw new IllegalStateException();
        }
        ctx.sql(' ').visit(Keywords.K_IS).sql(' ').visit(this.comment);
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }

    @Override
    public final boolean $isView() {
        return this.isView;
    }

    @Override
    public final boolean $isMaterializedView() {
        return this.isMaterializedView;
    }

    @Override
    public final Field<?> $field() {
        return this.field;
    }

    @Override
    public final Comment $comment() {
        return this.comment;
    }

    @Override
    public final QOM.CommentOn $table(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$isView(), this.$isMaterializedView(), this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $isView(boolean newValue) {
        return this.$constructor().apply(this.$table(), newValue, this.$isMaterializedView(), this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $isMaterializedView(boolean newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), newValue, this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $field(Field<?> newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), this.$isMaterializedView(), newValue, this.$comment());
    }

    @Override
    public final QOM.CommentOn $comment(Comment newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), this.$isMaterializedView(), this.$field(), newValue);
    }

    public final Function5<? super Table<?>, ? super Boolean, ? super Boolean, ? super Field<?>, ? super Comment, ? extends QOM.CommentOn> $constructor() {
        return (a1, a2, a3, a4, a5) -> new CommentOnImpl(this.configuration(), (Table<?>)a1, (boolean)a2, (boolean)a3, (Field<?>)a4, (Comment)a5);
    }
}

