/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.CommonTableExpression;
import io.lumine.mythic.bukkit.utils.lib.jooq.Condition;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DerivedColumnList;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Fields;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.ResultQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AliasedSelect;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DerivedColumnListImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsTrait;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Transformations;
import java.util.Set;

final class CommonTableExpressionImpl<R extends Record>
extends AbstractTable<R>
implements CommonTableExpression<R> {
    static final Set<SQLDialect> SUPPORT_MATERIALIZED = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_COLUMN_LIST = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);
    static final Set<SQLDialect> REQUIRE_EXPLICIT_ALIASING = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);
    private final DerivedColumnListImpl name;
    private final ResultQuery<R> query;
    private final FieldsImpl<R> fields;
    private final QOM.Materialized materialized;

    CommonTableExpressionImpl(DerivedColumnListImpl name, ResultQuery<R> query, QOM.Materialized materialized) {
        super(TableOptions.expression(), name.name);
        this.name = name;
        this.query = query;
        this.fields = this.fields1();
        this.materialized = materialized;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.query.getRecordType();
    }

    @Override
    public final boolean declaresCTE() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.declareCTE()) {
            Fields s2 = this.query;
            if (NO_SUPPORT_COLUMN_LIST.contains((Object)ctx.dialect()) && Tools.isNotEmpty(this.name.fieldNames)) {
                ctx.visit(this.name.name);
                ResultQuery<R> resultQuery = this.query;
                if (resultQuery instanceof Select) {
                    q = (Select)resultQuery;
                    s2 = new AliasedSelect(q, false, true, false, this.name.fieldNames);
                } else {
                    s2 = DSL.resultQuery("{0} union all {1}", DSL.select(Tools.map(this.name.fieldNames, n -> DSL.inline(null).as((Name)n))).where((Condition)DSL.falseCondition()), this.query);
                }
            } else if (REQUIRE_EXPLICIT_ALIASING.contains((Object)ctx.dialect()) && Tools.isEmpty(this.name.fieldNames)) {
                ctx.visit(this.name.name);
                ResultQuery<R> resultQuery = this.query;
                if (resultQuery instanceof Select) {
                    q = (Select)resultQuery;
                    s2 = new AliasedSelect(q, false, true, false, Tools.map(q.getSelect(), f -> f.getUnqualifiedName(), Name[]::new));
                }
            } else {
                ctx.visit(this.name);
            }
            ctx.sql(' ').visit(Keywords.K_AS).sql(' ');
            Object previous = null;
            if (this.materialized != null && SUPPORT_MATERIALIZED.contains((Object)ctx.dialect())) {
                if (this.materialized == QOM.Materialized.MATERIALIZED) {
                    ctx.visit(Keywords.K_MATERIALIZED).sql(' ');
                } else {
                    ctx.visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_MATERIALIZED).sql(' ');
                }
            }
            Tools.visitSubquery(ctx, s2, 1);
        } else if (!(ctx.declareTables() && this.query instanceof Select && Transformations.transformInlineCTE(ctx.configuration()))) {
            ctx.visit(this.name.name);
        }
    }

    @Override
    final FieldsImpl<R> fields0() {
        return this.fields;
    }

    final FieldsImpl<R> fields1() {
        Field<?>[] s2 = FieldsImpl.internalFieldsRow0((FieldsTrait)((Object)this.query)).fields();
        Field[] f = new Field[Tools.degree(this.query)];
        for (int i = 0; i < f.length; ++i) {
            f[i] = DSL.field(DSL.name(this.name.name, this.name.fieldNames.length > 0 ? this.name.fieldNames[i] : s2[i].getUnqualifiedName()), f.length == 1 ? Tools.scalarType(this.query) : s2[i].getDataType());
        }
        return new FieldsImpl(f);
    }

    @Override
    public final DerivedColumnList $derivedColumnList() {
        return this.name;
    }

    @Override
    public final ResultQuery<R> $query() {
        return this.query;
    }

    @Override
    public final QOM.Materialized $materialized() {
        return this.materialized;
    }
}

