/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.CreateViewAsStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.CreateViewFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function6;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Named;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.ResultQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQL;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartListView;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class CreateViewImpl<R extends Record>
extends AbstractDDLQuery
implements QOM.CreateView<R>,
CreateViewAsStep<R>,
CreateViewFinalStep {
    final Table<?> view;
    final QueryPartListView<? extends Field<?>> fields;
    final boolean orReplace;
    final boolean materialized;
    final boolean ifNotExists;
    ResultQuery<? extends R> query;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> NO_SUPPORT_COLUMN_RENAME = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE, SQLDialect.TRINO);
    private static final Set<SQLDialect> NO_SUPPORT_COLUMN_RENAME_MVIEW = SQLDialect.supportedBy(SQLDialect.H2);
    private transient Select<?> parsed;

    CreateViewImpl(Configuration configuration, Table<?> view, Collection<? extends Field<?>> fields, boolean orReplace, boolean materialized, boolean ifNotExists) {
        this(configuration, view, fields, orReplace, materialized, ifNotExists, null);
    }

    CreateViewImpl(Configuration configuration, Table<?> view, Collection<? extends Field<?>> fields, boolean orReplace, boolean materialized, boolean ifNotExists, ResultQuery<? extends R> query) {
        super(configuration);
        this.view = view;
        this.fields = new QueryPartList((Iterable<Field<?>>)fields);
        this.orReplace = orReplace;
        this.materialized = materialized;
        this.ifNotExists = ifNotExists;
        this.query = query;
    }

    @Override
    public final CreateViewImpl<R> as(ResultQuery<? extends R> query) {
        this.query = query;
        return this;
    }

    @Override
    public final CreateViewImpl<R> as(String query, QueryPart ... parts) {
        return this.as(DSL.resultQuery(query, parts));
    }

    @Override
    public final CreateViewImpl<R> as(String query, Object ... bindings) {
        return this.as(DSL.resultQuery(query, bindings));
    }

    @Override
    public final CreateViewImpl<R> as(String query) {
        return this.as(DSL.resultQuery(query));
    }

    @Override
    public final CreateViewImpl<R> as(SQL query) {
        return this.as(DSL.resultQuery(query));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_VIEW, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        this.acceptDefault(ctx);
    }

    private final void acceptDefault(Context<?> ctx) {
        QueryPartListView<Field<?>> f = this.fields;
        boolean rename = f != null && f.size() > 0;
        boolean renameSupported = this.materialized && !NO_SUPPORT_COLUMN_RENAME_MVIEW.contains((Object)ctx.dialect()) || !this.materialized && !NO_SUPPORT_COLUMN_RENAME.contains((Object)ctx.dialect());
        boolean replaceSupported = false;
        ctx.start(Clause.CREATE_VIEW_NAME).visit(replaceSupported && this.orReplace ? Keywords.K_REPLACE : Keywords.K_CREATE);
        if (this.orReplace && !replaceSupported) {
            ctx.sql(' ').visit(Keywords.K_OR);
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.sql(' ').visit(Keywords.K_ALTER);
                    break;
                }
                default: {
                    ctx.sql(' ').visit(Keywords.K_REPLACE);
                }
            }
        }
        if (this.materialized) {
            ctx.sql(' ').visit(Keywords.K_MATERIALIZED);
        }
        ctx.sql(' ').visit(Keywords.K_VIEW).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        if (rename && renameSupported) {
            ctx.sql('(').visit(QueryPartListView.wrap(f).qualify(false)).sql(')');
        }
        ctx.end(Clause.CREATE_VIEW_NAME).formatSeparator().visit(Keywords.K_AS).formatSeparator().start(Clause.CREATE_VIEW_AS).visit(rename && !renameSupported ? CreateViewImpl.renameSelect(this.parsed(), f) : this.query, ParamType.INLINED).end(Clause.CREATE_VIEW_AS);
    }

    static final Select<?> renameSelect(Select<?> s2, List<? extends Field<?>> f) {
        return DSL.selectFrom(s2.asTable(DSL.name("t"), Tools.map(f, Named::getUnqualifiedName, Name[]::new)));
    }

    final Select<?> parsed() {
        if (this.parsed != null) {
            return this.parsed;
        }
        ResultQuery<? extends R> resultQuery = this.query;
        if (resultQuery instanceof Select) {
            Select s2;
            this.parsed = s2 = (Select)resultQuery;
            return this.parsed;
        }
        DSLContext dsl = this.configuration().dsl();
        return dsl.parser().parseSelect(dsl.renderInlined(this.query));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> $view() {
        return this.view;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $fields() {
        return QOM.unmodifiable(this.fields);
    }

    @Override
    public final boolean $orReplace() {
        return this.orReplace;
    }

    @Override
    public final boolean $materialized() {
        return this.materialized;
    }

    @Override
    public final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public final ResultQuery<? extends R> $query() {
        return this.query;
    }

    @Override
    public final QOM.CreateView<R> $view(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$fields(), this.$orReplace(), this.$materialized(), this.$ifNotExists(), this.$query());
    }

    @Override
    public final QOM.CreateView<R> $fields(Collection<? extends Field<?>> newValue) {
        return this.$constructor().apply(this.$view(), newValue, this.$orReplace(), this.$materialized(), this.$ifNotExists(), this.$query());
    }

    @Override
    public final QOM.CreateView<R> $orReplace(boolean newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), newValue, this.$materialized(), this.$ifNotExists(), this.$query());
    }

    @Override
    public final QOM.CreateView<R> $materialized(boolean newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), this.$orReplace(), newValue, this.$ifNotExists(), this.$query());
    }

    @Override
    public final QOM.CreateView<R> $ifNotExists(boolean newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), this.$orReplace(), this.$materialized(), newValue, this.$query());
    }

    @Override
    public final QOM.CreateView<R> $query(ResultQuery<? extends R> newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), this.$orReplace(), this.$materialized(), this.$ifNotExists(), newValue);
    }

    public final Function6<? super Table<?>, ? super Collection<? extends Field<?>>, ? super Boolean, ? super Boolean, ? super Boolean, ? super ResultQuery<? extends R>, ? extends QOM.CreateView<R>> $constructor() {
        return (a1, a2, a3, a4, a5, a6) -> new CreateViewImpl<R>(this.configuration(), (Table<?>)a1, (Collection<Field<?>>)a2, (boolean)a3, (boolean)a4, (boolean)a5, a6);
    }
}

