/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.ConnectionProvider;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataAccessException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;

public class DataSourceConnectionProvider
implements ConnectionProvider {
    private final DataSource dataSource;

    public DataSourceConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DataSource dataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public Connection acquire() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new DataAccessException("Error getting connection from data source " + String.valueOf(this.dataSource), e);
        }
    }

    @Override
    public void release(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            throw new DataAccessException("Error closing connection " + String.valueOf(connection), e);
        }
    }
}

