/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function1;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.math.BigDecimal;
import java.util.Set;

final class Digits
extends AbstractField<String>
implements QOM.Digits {
    final Field<? extends Number> value;
    private static final Set<SQLDialect> NO_SUPPORT_DIGITS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);

    Digits(Field<? extends Number> value) {
        super(Names.N_DIGITS, Tools.allNotNull(SQLDataType.VARCHAR, value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_DIGITS.contains((Object)ctx.dialect())) {
            DataType t2 = this.value.getDataType();
            if (t2.getType() == Byte.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.BYTE_PRECISION)), DSL.inline(DefaultDataType.BYTE_PRECISION), DSL.inline("0")));
            } else if (t2.getType() == Short.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.SHORT_PRECISION)), DSL.inline(DefaultDataType.SHORT_PRECISION), DSL.inline("0")));
            } else if (t2.getType() == Integer.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.INTEGER_PRECISION)), DSL.inline(DefaultDataType.INTEGER_PRECISION), DSL.inline("0")));
            } else if (t2.getType() == Long.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.LONG_PRECISION)), DSL.inline(DefaultDataType.LONG_PRECISION), DSL.inline("0")));
            } else if (t2.scaleDefined()) {
                ctx.visit(DSL.lpad(DSL.abs(this.value.mul(DSL.inline(BigDecimal.TEN.pow(t2.scale())))).cast(t2.scale(0)).cast(SQLDataType.VARCHAR(t2.precision())), DSL.inline(t2.precision()), DSL.inline("0")));
            } else {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(t2.precision())), DSL.inline(t2.precision()), DSL.inline("0")));
            }
        } else {
            ctx.visit(Names.N_DIGITS).sql('(').visit(this.value).sql(')');
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.value;
    }

    @Override
    public final QOM.Digits $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue);
    }

    @Override
    public final Function1<? super Field<? extends Number>, ? extends QOM.Digits> $constructor() {
        return a1 -> new Digits((Field<? extends Number>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Digits) {
            QOM.Digits o = (QOM.Digits)that;
            return StringUtils.equals(this.$value(), o.$value());
        }
        return super.equals(that);
    }
}

