/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Commit;
import io.lumine.mythic.bukkit.utils.lib.jooq.Commits;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.HistoryVersion;
import io.lumine.mythic.bukkit.utils.lib.jooq.Schema;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.Version;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.InterpreterSearchSchema;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.MappedCatalog;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.MappedSchema;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.MigrationSchema;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.RenderMapping;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataMigrationVerificationException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.History;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.HistoryRecord;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.HistoryResolution;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.HistoryStatus;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.MigrationImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.JooqLogger;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class HistoryImpl
extends AbstractScope
implements io.lumine.mythic.bukkit.utils.lib.jooq.History {
    private static final JooqLogger log = JooqLogger.getLogger(HistoryImpl.class);
    final DSLContext ctx;
    final DSLContext historyCtx;
    final Commits commits;
    final List<HistoryVersion> versions;

    HistoryImpl(Configuration configuration) {
        super(configuration);
        this.ctx = configuration.dsl();
        this.historyCtx = HistoryImpl.initCtx(configuration, configuration.settings().getMigrationHistorySchema()).dsl();
        this.commits = configuration.commitProvider().provide();
        this.versions = this.initVersions();
    }

    @Override
    public final Iterator<HistoryVersion> iterator() {
        return Collections.unmodifiableList(this.versions).iterator();
    }

    @Override
    public final boolean available() {
        return !Tools.isEmpty(this.versions);
    }

    @Override
    public final HistoryVersion root() {
        if (this.available()) {
            return this.versions.get(0);
        }
        throw new DataMigrationVerificationException("No versions are available");
    }

    @Override
    public final HistoryVersion current() {
        if (this.available()) {
            return this.versions.get(this.versions.size() - 1);
        }
        throw new DataMigrationVerificationException("No versions are available");
    }

    final Set<Schema> schemas() {
        LinkedHashSet<Schema> set = new LinkedHashSet<Schema>();
        for (MigrationSchema schema : this.configuration.settings().getMigrationSchemata()) {
            this.addSchema(set, schema);
        }
        if (this.configuration.settings().getMigrationDefaultSchema() != null) {
            this.addSchema(set, this.configuration.settings().getMigrationDefaultSchema());
            set.add(DSL.schema(""));
        }
        return set;
    }

    private final void addSchema(Set<Schema> set, MigrationSchema schema) {
        if (schema != null) {
            set.addAll(this.lookup(Arrays.asList(MigrationImpl.schema(schema))));
        }
    }

    final Collection<Schema> lookup(List<Schema> schemas) {
        Collection<Schema> result = schemas;
        List<InterpreterSearchSchema> searchPath = this.configuration().settings().getInterpreterSearchPath();
        if (!searchPath.isEmpty()) {
            result = new HashSet();
            Schema defaultSchema = DSL.schema(DSL.name(searchPath.get(0).getCatalog(), searchPath.get(0).getSchema()));
            for (Schema schema : schemas) {
                if (schema.getQualifiedName().empty()) {
                    result.add(defaultSchema);
                    continue;
                }
                result.add(schema);
            }
        }
        return result;
    }

    static final Configuration initCtx(Configuration configuration, MigrationSchema defaultSchema) {
        if (defaultSchema != null) {
            Configuration result = configuration.derive();
            if (!StringUtils.isBlank(defaultSchema.getCatalog())) {
                result.settings().withRenderMapping(new RenderMapping().withCatalogs(new MappedCatalog().withInput("").withOutput(defaultSchema.getCatalog()).withSchemata(new MappedSchema().withInput("").withOutput(defaultSchema.getSchema()))));
            } else if (!StringUtils.isBlank(defaultSchema.getSchema())) {
                result.settings().withRenderMapping(new RenderMapping().withSchemata(new MappedSchema().withInput("").withOutput(defaultSchema.getSchema())));
            }
            result.settings().withInterpreterSearchPath(new InterpreterSearchSchema().withCatalog(defaultSchema.getCatalog()).withSchema(defaultSchema.getSchema()));
            return result;
        }
        return configuration;
    }

    @Nullable
    final HistoryRecord currentHistoryRecord(boolean successOnly) {
        return this.existsHistory() ? (HistoryRecord)this.historyCtx.selectFrom(History.HISTORY).where(successOnly ? History.HISTORY.STATUS.eq(DSL.inline(HistoryStatus.SUCCESS)) : History.HISTORY.STATUS.eq(DSL.inline(HistoryStatus.SUCCESS)).or(History.HISTORY.RESOLUTION.eq(HistoryResolution.OPEN))).orderBy(History.HISTORY.MIGRATED_AT.desc(), History.HISTORY.ID.desc()).limit(1).fetchOne() : null;
    }

    final boolean existsHistory() {
        Table<HistoryRecord> h2 = this.historyCtx.map(History.HISTORY);
        return !this.historyCtx.meta().filterSchemas(s2 -> h2.getSchema() == null || s2.getName().equals(h2.getSchema().getName())).filterTables(t2 -> t2.getName().equals(h2.getName())).getTables().isEmpty();
    }

    private final List<HistoryVersion> initVersions() {
        ArrayList<HistoryVersion> result = new ArrayList<HistoryVersion>();
        if (this.existsHistory()) {
            result.add(new HistoryVersionImpl(this, this.commits.root().version(), null));
            for (HistoryRecord r : this.historyCtx.selectFrom(History.HISTORY).where(History.HISTORY.STATUS.eq(DSL.inline(HistoryStatus.SUCCESS))).orderBy(History.HISTORY.ID.asc())) {
                Commit commit = this.commits.get(r.getMigratedTo());
                if (commit != null) {
                    result.add(new HistoryVersionImpl(this, commit.version(), r.getMigratedAt().toInstant()));
                    continue;
                }
                throw new DataMigrationVerificationException("CommitProvider didn't provide version for ID: {id}\n\nThis may happen if a successful migration has happened in a database, but the source\nfor this migration is not available.\n".replace("{id}", r.getMigratedTo()));
            }
        }
        return result;
    }

    final void init() {
        if (!this.existsHistory()) {
            if (Boolean.TRUE.equals(this.historyCtx.settings().isMigrationHistorySchemaCreateSchemaIfNotExists()) && this.historyCtx.settings().getMigrationHistorySchema() != null || Boolean.TRUE.equals(this.historyCtx.settings().isMigrationSchemataCreateSchemaIfNotExists()) && this.historyCtx.settings().getMigrationDefaultSchema() != null) {
                this.historyCtx.createSchemaIfNotExists("").execute();
            }
            log.info("Initialising history table: " + String.valueOf(this.historyCtx.map(History.HISTORY)));
            this.historyCtx.meta(History.HISTORY).ddl().executeBatch();
        }
    }

    @Override
    public final void resolve(String message) {
        HistoryRecord h2 = this.currentHistoryRecord(false);
        if (h2 == null) {
            throw new DataMigrationVerificationException("No current history record found to resolve");
        }
        h2.setResolution(HistoryResolution.RESOLVED).setResolutionMessage(message).update();
    }

    public int hashCode() {
        return this.versions.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HistoryImpl) {
            HistoryImpl h2 = (HistoryImpl)obj;
            return this.versions.equals(h2.versions);
        }
        return false;
    }

    public String toString() {
        if (this.available()) {
            return "History [" + String.valueOf(this.current()) + "]";
        }
        return "History []";
    }

    record HistoryVersionImpl(io.lumine.mythic.bukkit.utils.lib.jooq.History history, Version version, Instant migratedAt) implements HistoryVersion
    {
        @Override
        public int hashCode() {
            return Objects.hash(this.version);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoryVersionImpl other = (HistoryVersionImpl)obj;
            return Objects.equals(this.version, other.version);
        }

        @Override
        public String toString() {
            return "HistoryVersion [version=" + String.valueOf(this.version) + ", migratedAt=" + String.valueOf(this.migratedAt) + "]";
        }
    }
}

