/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Condition;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Index;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.OrderField;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.SortField;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractNamed;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CommentImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QualifiedImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class IndexImpl
extends AbstractNamed
implements Index,
QOM.UNotYetImplemented {
    private static final Set<SQLDialect> NO_SUPPORT_INDEX_QUALIFICATION = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final Table<?> table;
    private final SortField<?>[] fields;
    private final Condition where;
    private final boolean unique;

    IndexImpl(Name name) {
        this(name, null, Tools.EMPTY_SORTFIELD, null, false);
    }

    IndexImpl(Name name, Table<?> table, OrderField<?>[] fields, Condition where, boolean unique) {
        super(name.empty() ? name : IndexImpl.qualify(table, name), CommentImpl.NO_COMMENT);
        this.table = table;
        this.fields = Tools.sortFields(fields);
        this.where = where;
        this.unique = unique;
    }

    final SortField<?>[] $fields() {
        return this.fields;
    }

    final boolean $unique() {
        return this.unique;
    }

    final Condition $where() {
        return this.where;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_INDEX_QUALIFICATION.contains((Object)ctx.dialect())) {
            ctx.visit(this.getUnqualifiedName());
        } else if (this.getTable() == null) {
            ctx.visit(new QualifiedImpl(this.getQualifiedName()));
        } else {
            ctx.visit(new QualifiedImpl(DSL.name(this.getTable().getQualifiedName().qualifier(), this.getUnqualifiedName())));
        }
    }

    @Override
    public final Table<?> getTable() {
        return this.table;
    }

    @Override
    public final List<SortField<?>> getFields() {
        return Arrays.asList(this.fields);
    }

    @Override
    public final Condition getWhere() {
        return this.where;
    }

    @Override
    public boolean getUnique() {
        return this.unique;
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }
}

