/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONB;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class JSONBKeyExists
extends AbstractCondition
implements QOM.JSONBKeyExists {
    final Field<JSONB> json;
    final Field<String> key;

    JSONBKeyExists(Field<JSONB> json, Field<String> key) {
        this.json = Tools.nullSafeNotNull(json, SQLDataType.JSONB);
        this.key = Tools.nullSafeNotNull(key, SQLDataType.VARCHAR);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: 
            case DUCKDB: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case TRINO: {
                return false;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: 
            case DUCKDB: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case TRINO: {
                ctx.visit(DSL.jsonbGetAttribute(this.json, this.key).isNotNull());
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.sql('(').visit(this.json).sql(" ?? ").visit(this.key).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_JSONB_KEY_EXISTS, SQLDataType.BOOLEAN, this.json, this.key));
            }
        }
    }

    @Override
    public final Field<JSONB> $arg1() {
        return this.json;
    }

    @Override
    public final Field<String> $arg2() {
        return this.key;
    }

    @Override
    public final QOM.JSONBKeyExists $arg1(Field<JSONB> newValue) {
        return this.$constructor().apply((Field<JSONB>)newValue, (Field<String>)this.$arg2());
    }

    @Override
    public final QOM.JSONBKeyExists $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<JSONB>)this.$arg1(), (Field<String>)newValue);
    }

    @Override
    public final Function2<? super Field<JSONB>, ? super Field<String>, ? extends QOM.JSONBKeyExists> $constructor() {
        return (a1, a2) -> new JSONBKeyExists((Field<JSONB>)a1, (Field<String>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONBKeyExists) {
            QOM.JSONBKeyExists o = (QOM.JSONBKeyExists)that;
            return StringUtils.equals(this.$json(), o.$json()) && StringUtils.equals(this.$key(), o.$key());
        }
        return super.equals(that);
    }
}

