/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.ArrayAggOrderByStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSON;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONArrayAggOrderByStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONB;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Result;
import io.lumine.mythic.bukkit.utils.lib.jooq.Row;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectField;
import io.lumine.mythic.bukkit.utils.lib.jooq.XML;
import io.lumine.mythic.bukkit.utils.lib.jooq.XMLAggOrderByStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractAggregateFunction;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Multiset;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.MultisetDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

final class MultisetAgg<R extends Record>
extends AbstractAggregateFunction<Result<R>>
implements QOM.MultisetAgg<R> {
    private final AbstractRow<R> row;

    MultisetAgg(boolean distinct, SelectField<R> row) {
        super(distinct, Names.N_MULTISET_AGG, new MultisetDataType((AbstractRow)row, null), ((AbstractRow)row).fields());
        this.row = (AbstractRow)row;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONDITION))) {
            ctx.data().remove(Tools.BooleanDataKey.DATA_MULTISET_CONDITION);
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, true));
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONDITION, true);
        } else {
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, false));
        }
    }

    private final void accept0(Context<?> ctx, boolean multisetCondition) {
        switch (Tools.emulateMultiset(ctx.configuration())) {
            case JSON: {
                Field f;
                JSONArrayAggOrderByStep<JSON> order = Multiset.jsonArrayaggEmulation(ctx, this.row, true, this.distinct);
                Field field = f = multisetCondition ? this.fo((AbstractAggregateFunction)Multiset.returningClob(ctx, order.orderBy(this.row.fields()))) : this.ofo((AbstractAggregateFunction)Multiset.returningClob(ctx, order));
                if (multisetCondition && Multiset.NO_SUPPORT_JSON_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(f.cast(SQLDataType.VARCHAR));
                    break;
                }
                ctx.visit(f);
                break;
            }
            case JSONB: {
                Field f;
                JSONArrayAggOrderByStep<JSONB> order = Multiset.jsonbArrayaggEmulation(ctx, this.row, true, this.distinct);
                Field field = f = multisetCondition ? this.fo((AbstractAggregateFunction)Multiset.returningClob(ctx, order.orderBy(this.row.fields()))) : this.ofo((AbstractAggregateFunction)Multiset.returningClob(ctx, order));
                if (multisetCondition && Multiset.NO_SUPPORT_JSONB_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(f.cast(SQLDataType.VARCHAR));
                    break;
                }
                ctx.visit(f);
                break;
            }
            case XML: {
                XMLAggOrderByStep<XML> order = Multiset.xmlaggEmulation(ctx, this.row, true);
                Field<XML> f = DSL.xmlelement(Multiset.nResult(ctx), multisetCondition ? this.fo((AbstractAggregateFunction)order.orderBy(this.row.fields())) : this.ofo((AbstractAggregateFunction)((Object)order)));
                if (multisetCondition && Multiset.NO_SUPPORT_XML_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.xmlserializeContent(f, SQLDataType.VARCHAR));
                    break;
                }
                ctx.visit(f);
                break;
            }
            case NATIVE: {
                ArrayAggOrderByStep<?> order = Multiset.arrayAggEmulation(this.row, true);
                ctx.visit(multisetCondition ? this.fo(order.orderBy(this.row.fields())) : this.ofo((AbstractAggregateFunction)order));
                break;
            }
        }
    }

    @Override
    public final Row $row() {
        return this.row;
    }
}

