/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class Nvl<T>
extends AbstractField<T>
implements QOM.Nvl<T> {
    final Field<T> value;
    final Field<T> defaultValue;

    Nvl(Field<T> value, Field<T> defaultValue) {
        super(Names.N_NVL, Tools.anyNotNull(Tools.dataType(value), value, defaultValue));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.OTHER);
        this.defaultValue = Tools.nullSafeNotNull(defaultValue, SQLDataType.OTHER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                return false;
            }
            case CUBRID: 
            case DUCKDB: 
            case FIREBIRD: 
            case IGNITE: 
            case POSTGRES: 
            case TRINO: 
            case YUGABYTEDB: {
                return true;
            }
            case CLICKHOUSE: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                return true;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(DSL.coalesce(this.value, this.defaultValue));
                break;
            }
            case CUBRID: 
            case DUCKDB: 
            case FIREBIRD: 
            case IGNITE: 
            case POSTGRES: 
            case TRINO: 
            case YUGABYTEDB: {
                ctx.visit(DSL.function(Names.N_COALESCE, this.getDataType(), this.value, this.defaultValue));
                break;
            }
            case CLICKHOUSE: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_IFNULL, this.getDataType(), this.value, this.defaultValue));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_NVL, this.getDataType(), this.value, this.defaultValue));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<T> $arg2() {
        return this.defaultValue;
    }

    @Override
    public final QOM.Nvl<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.Nvl<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.Nvl<T>> $constructor() {
        return (a1, a2) -> new Nvl(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Nvl) {
            QOM.Nvl o = (QOM.Nvl)that;
            return StringUtils.equals(this.$value(), o.$value()) && StringUtils.equals(this.$defaultValue(), o.$defaultValue());
        }
        return super.equals(that);
    }
}

