/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.CharacterSet;
import io.lumine.mythic.bukkit.utils.lib.jooq.Collation;
import io.lumine.mythic.bukkit.utils.lib.jooq.ConverterContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Generator;
import io.lumine.mythic.bukkit.utils.lib.jooq.Nullability;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Row;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRecord;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.sql.Struct;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class RecordDataType<R extends Record>
extends DefaultDataType<R> {
    final AbstractRow<R> row;

    RecordDataType(Row row) {
        this(row, Tools.recordType(row.size()), "record");
    }

    RecordDataType(Row row, Class<R> recordType, String name) {
        super(null, recordType, name, RecordDataType.nullability(row));
        this.row = (AbstractRow)row;
    }

    static final Nullability nullability(Row row) {
        return Tools.anyMatch(row.fields(), f -> f.getDataType().nullable()) ? Nullability.NULL : Nullability.NOT_NULL;
    }

    RecordDataType(DefaultDataType<R> t2, AbstractRow<R> row, Integer precision, Integer scale, Integer length, Nullability nullability, boolean hidden, boolean readonly, Generator<?, ?, R> generatedAlwaysAs, QOM.GenerationOption generationOption, QOM.GenerationLocation generationLocation, Collation collation, CharacterSet characterSet, boolean identity, Field<R> defaultValue) {
        super(t2, precision, scale, length, nullability, hidden, readonly, generatedAlwaysAs, generationOption, generationLocation, collation, characterSet, identity, defaultValue);
        this.row = row;
    }

    @Override
    DefaultDataType<R> construct(Integer newPrecision, Integer newScale, Integer newLength, Nullability newNullability, boolean newHidden, boolean newReadonly, Generator<?, ?, R> newGeneratedAlwaysAs, QOM.GenerationOption newGenerationOption, QOM.GenerationLocation newGenerationLocation, Collation newCollation, CharacterSet newCharacterSet, boolean newIdentity, Field<R> newDefaultValue) {
        return new RecordDataType<R>(this, this.row, newPrecision, newScale, newLength, newNullability, newHidden, newReadonly, newGeneratedAlwaysAs, newGenerationOption, newGenerationLocation, newCollation, newCharacterSet, newIdentity, newDefaultValue);
    }

    @Override
    public final Row getRow() {
        return this.row;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.getType();
    }

    @Override
    final R convert(Object object, ConverterContext cc) {
        if (object instanceof Record && ((Record)object).fieldsRow().equals(this.row)) {
            return (R)((Record)object);
        }
        if (object instanceof Record || object instanceof Map || object instanceof List || object instanceof Struct) {
            return (R)Tools.newRecord(true, cc.configuration(), this.getRecordType(), this.row).operate(r -> {
                if (object instanceof Record) {
                    ((AbstractRecord)r).fromArray(((Record)object).intoArray());
                } else if (object instanceof Map) {
                    r.from(((Map)object).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList()));
                } else {
                    r.from(object);
                }
                return r;
            });
        }
        return (R)((Record)super.convert(object, cc));
    }
}

