/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Comparator;
import io.lumine.mythic.bukkit.utils.lib.jooq.Condition;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Row;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class RowCondition
extends AbstractCondition
implements QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private static final Set<SQLDialect> EMULATE_EQ_AND_NE = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> EMULATE_RANGES = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD);
    private final Row left;
    private final Row right;
    private final Comparator comparator;
    private final boolean forceEmulation;

    RowCondition(Row left, Row right, Comparator comparator) {
        this(left, right, comparator, false);
    }

    RowCondition(Row left, Row right, Comparator comparator, boolean forceEmulation) {
        this.left = ((AbstractRow)left).convertTo(right);
        this.right = ((AbstractRow)right).convertTo(left);
        this.comparator = comparator;
        this.forceEmulation = forceEmulation;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.forceEmulation) {
            ctx.visit(this.emulation());
        } else if (EMULATE_EQ_AND_NE.contains((Object)ctx.dialect()) && (this.comparator == Comparator.EQUALS || this.comparator == Comparator.NOT_EQUALS)) {
            ctx.visit(this.emulation());
        } else if (EMULATE_RANGES.contains((Object)ctx.dialect()) && (this.comparator == Comparator.GREATER || this.comparator == Comparator.GREATER_OR_EQUAL || this.comparator == Comparator.LESS || this.comparator == Comparator.LESS_OR_EQUAL)) {
            ctx.visit(this.emulation());
        } else {
            boolean extraParentheses = false;
            ctx.visit(this.left).sql(' ').sql(this.comparator.toSQL()).sql(' ').sql(extraParentheses ? "(" : "").visit(this.right).sql(extraParentheses ? ")" : "");
        }
    }

    Condition emulation() {
        switch (this.comparator) {
            case EQUALS: 
            case NOT_EQUALS: {
                Field[] rightFields = this.right.fields();
                Condition result = DSL.and(Tools.map(this.left.fields(), (f, i) -> f.eq(rightFields[i])));
                if (this.comparator == Comparator.NOT_EQUALS) {
                    result = result.not();
                }
                return result;
            }
            case GREATER: 
            case GREATER_OR_EQUAL: 
            case LESS: 
            case LESS_OR_EQUAL: {
                Comparator order;
                Comparator comparator = this.comparator == Comparator.GREATER ? Comparator.GREATER : (this.comparator == Comparator.GREATER_OR_EQUAL ? Comparator.GREATER : (this.comparator == Comparator.LESS ? Comparator.LESS : (order = this.comparator == Comparator.LESS_OR_EQUAL ? Comparator.LESS : null)));
                Comparator factoredOrder = this.comparator == Comparator.GREATER ? Comparator.GREATER_OR_EQUAL : (this.comparator == Comparator.GREATER_OR_EQUAL ? Comparator.GREATER_OR_EQUAL : (this.comparator == Comparator.LESS ? Comparator.LESS_OR_EQUAL : (this.comparator == Comparator.LESS_OR_EQUAL ? Comparator.LESS_OR_EQUAL : null)));
                Field<?>[] leftFields = this.left.fields();
                Field<?>[] rightFields = this.right.fields();
                Condition result = RowCondition.emulate(this.left, this.right, order, this.comparator);
                if (leftFields.length > 1) {
                    result = leftFields[0].compare(factoredOrder, rightFields[0]).and(result);
                }
                return result;
            }
        }
        throw new UnsupportedOperationException("Emulation not available for: " + String.valueOf((Object)this.comparator));
    }

    private static final Condition emulate(Row r1, Row r2, Comparator comp, Comparator last) {
        Condition result = r1.field(r1.size() - 1).compare(last, r2.field(r1.size() - 1));
        for (int i = r1.size() - 2; i >= 0; --i) {
            Field<?> e1 = r1.field(i);
            Field<?> e2 = r2.field(i);
            result = e1.compare(comp, e2).or(e1.eq(e2).and(result));
        }
        return result;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

