/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Comparator;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Row;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectLimitAfterOffsetStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CustomField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RowCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RowSubqueryCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class RowIsDistinctFrom
extends AbstractCondition
implements QOM.UNotYetImplemented {
    static final Set<SQLDialect> EMULATE_DISTINCT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY);
    static final Set<SQLDialect> EMULATE_WITH_ARRAYS = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);
    static final Set<SQLDialect> EMULATE_WITH_UNION = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    static final Set<SQLDialect> EMULATE_DISTINCT_SELECT = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> SUPPORT_DISTINCT_WITH_ARROW = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Row lhs;
    private final Row rhsRow;
    private final Select<?> rhsSelect;
    private final boolean not;

    RowIsDistinctFrom(Row lhs, Row rhs, boolean not) {
        this.lhs = ((AbstractRow)lhs).convertTo(rhs);
        this.rhsRow = ((AbstractRow)rhs).convertTo(lhs);
        this.rhsSelect = null;
        this.not = not;
    }

    RowIsDistinctFrom(Row lhs, Select<?> rhs, boolean not) {
        this.lhs = lhs;
        this.rhsRow = null;
        this.rhsSelect = rhs;
        this.not = not;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_DISTINCT.contains((Object)ctx.dialect()) || this.rhsSelect != null && EMULATE_DISTINCT_SELECT.contains((Object)ctx.dialect())) {
            Select intersect = DSL.select(this.lhs.fields()).intersect(this.rhsSelect != null ? this.rhsSelect : DSL.select(this.rhsRow.fields()));
            ctx.visit(this.not ? DSL.exists(intersect) : DSL.notExists(intersect));
        } else if (EMULATE_WITH_UNION.contains((Object)ctx.dialect())) {
            SelectLimitAfterOffsetStep union = DSL.select(this.lhs.fields()).union(this.rhsSelect != null ? this.rhsSelect : DSL.select(this.rhsRow.fields())).offset(DSL.one());
            ctx.visit(this.not ? DSL.notExists(union) : DSL.exists(union));
        } else if (SUPPORT_DISTINCT_WITH_ARROW.contains((Object)ctx.dialect())) {
            if (!this.not) {
                ctx.visit(Keywords.K_NOT).sql('(');
            }
            ctx.visit(this.lhs).sql(" <=> ");
            if (this.rhsRow != null) {
                ctx.visit(this.rhsRow);
            } else {
                Tools.visitSubquery(ctx, this.rhsSelect, 256);
            }
            if (!this.not) {
                ctx.sql(')');
            }
        } else if (EMULATE_WITH_ARRAYS.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.function(Names.N_arrayUniq, SQLDataType.INTEGER, DSL.array(this.lhs, this.rhsRow != null ? this.rhsRow : CustomField.of(Names.NQ_SELECT, SQLDataType.RECORD, c -> Tools.visitSubquery(c, this.rhsSelect, 256)))).eq(DSL.inline(this.not ? 1 : 2)));
        } else if (SQLDialect.SQLITE == ctx.family()) {
            ctx.visit(this.lhs).sql(' ').visit(Keywords.K_IS).sql(' ');
            if (!this.not) {
                ctx.visit(Keywords.K_NOT).sql(' ');
            }
            if (this.rhsRow != null) {
                ctx.visit(this.rhsRow);
            } else {
                Tools.visitSubquery(ctx, this.rhsSelect, 256);
            }
        } else {
            ctx.visit(this.rhsRow != null ? new RowCondition(this.lhs, this.rhsRow, this.not ? Comparator.IS_NOT_DISTINCT_FROM : Comparator.IS_DISTINCT_FROM) : new RowSubqueryCondition(this.lhs, this.rhsSelect, this.not ? Comparator.IS_NOT_DISTINCT_FROM : Comparator.IS_DISTINCT_FROM));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

