/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function1;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.util.UUID;

final class UuidToBin
extends AbstractField<byte[]>
implements QOM.UuidToBin {
    final Field<UUID> uuid;

    UuidToBin(Field<UUID> uuid) {
        super(Names.N_UUID_TO_BIN, Tools.allNotNull(SQLDataType.VARBINARY, uuid));
        this.uuid = Tools.nullSafeNotNull(uuid, SQLDataType.UUID);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: {
                return false;
            }
            case H2: 
            case HSQLDB: {
                return false;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_UUIDStringToNum, SQLDataType.BINARY(16), DSL.cast(this.uuid, SQLDataType.VARCHAR)));
                break;
            }
            case H2: 
            case HSQLDB: {
                ctx.visit(DSL.cast(this.uuid, SQLDataType.BINARY(16)));
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(DSL.function(Names.N_DECODE, SQLDataType.UUID, DSL.replace(DSL.cast(this.uuid, SQLDataType.VARCHAR), DSL.inline("-"), DSL.inline("")), DSL.inline("hex")));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_UUID_TO_BIN, this.getDataType(), this.uuid));
            }
        }
    }

    @Override
    public final Field<UUID> $arg1() {
        return this.uuid;
    }

    @Override
    public final QOM.UuidToBin $arg1(Field<UUID> newValue) {
        return this.$constructor().apply((Field<UUID>)newValue);
    }

    @Override
    public final Function1<? super Field<UUID>, ? extends QOM.UuidToBin> $constructor() {
        return a1 -> new UuidToBin((Field<UUID>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.UuidToBin) {
            QOM.UuidToBin o = (QOM.UuidToBin)that;
            return StringUtils.equals(this.$uuid(), o.$uuid());
        }
        return super.equals(that);
    }
}

