/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.GroupField;
import io.lumine.mythic.bukkit.utils.lib.jooq.OrderField;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.SortField;
import io.lumine.mythic.bukkit.utils.lib.jooq.WindowSpecificationExcludeStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.WindowSpecificationFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.WindowSpecificationOrderByStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.WindowSpecificationPartitionByStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.WindowSpecificationRowsAndStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractWindowFunction;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CumeDist;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DenseRank;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.GroupFieldList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Lag;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Lead;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Ntile;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.PercentRank;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Rank;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SortFieldList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.WindowDefinitionImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

final class WindowSpecificationImpl
extends AbstractQueryPart
implements WindowSpecificationPartitionByStep,
WindowSpecificationRowsAndStep,
WindowSpecificationExcludeStep {
    private static final Set<SQLDialect> REQUIRES_DEFAULT_FRAME_IN_LEAD_LAG_ORDER_BY = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);
    private static final Set<SQLDialect> REQUIRES_ORDER_BY_IN_LEAD_LAG = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.TRINO);
    private static final Set<SQLDialect> REQUIRES_ORDER_BY_IN_NTILE = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE, SQLDialect.H2);
    private static final Set<SQLDialect> REQUIRES_ORDER_BY_IN_RANK_DENSE_RANK = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.MARIADB);
    private static final Set<SQLDialect> REQUIRES_ORDER_BY_IN_PERCENT_RANK_CUME_DIST = SQLDialect.supportedBy(SQLDialect.MARIADB);
    private final WindowDefinitionImpl windowDefinition;
    private final GroupFieldList partitionBy;
    private final SortFieldList orderBy;
    private Integer frameStart;
    private Integer frameEnd;
    private QOM.FrameUnits frameUnits;
    private QOM.FrameExclude exclude;

    WindowSpecificationImpl() {
        this(null);
    }

    WindowSpecificationImpl(WindowDefinitionImpl windowDefinition) {
        this.windowDefinition = windowDefinition;
        this.partitionBy = new GroupFieldList();
        this.orderBy = new SortFieldList();
    }

    WindowSpecificationImpl copy() {
        WindowSpecificationImpl copy = new WindowSpecificationImpl(this.windowDefinition);
        copy.partitionBy.addAll(this.partitionBy);
        copy.orderBy.addAll(this.orderBy);
        copy.frameStart = this.frameStart;
        copy.frameEnd = this.frameEnd;
        copy.frameUnits = this.frameUnits;
        copy.exclude = this.exclude;
        return copy;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean indent;
        SortFieldList o = this.orderBy;
        AbstractWindowFunction w = (AbstractWindowFunction)ctx.data(Tools.ExtendedDataKey.DATA_WINDOW_FUNCTION);
        if (o.isEmpty()) {
            boolean ordered;
            boolean bl = ordered = w instanceof Ntile && REQUIRES_ORDER_BY_IN_NTILE.contains((Object)ctx.dialect()) || w instanceof Lead && REQUIRES_ORDER_BY_IN_LEAD_LAG.contains((Object)ctx.dialect()) || w instanceof Lag && REQUIRES_ORDER_BY_IN_LEAD_LAG.contains((Object)ctx.dialect()) || w instanceof Rank && REQUIRES_ORDER_BY_IN_RANK_DENSE_RANK.contains((Object)ctx.dialect()) || w instanceof DenseRank && REQUIRES_ORDER_BY_IN_RANK_DENSE_RANK.contains((Object)ctx.dialect()) || w instanceof PercentRank && REQUIRES_ORDER_BY_IN_PERCENT_RANK_CUME_DIST.contains((Object)ctx.dialect()) || w instanceof CumeDist && REQUIRES_ORDER_BY_IN_PERCENT_RANK_CUME_DIST.contains((Object)ctx.dialect());
            if (ordered) {
                switch (ctx.family()) {
                    default: 
                }
                Field<Integer> constant = DSL.field(DSL.select(DSL.one()));
                o = new SortFieldList();
                o.add(constant.sortDefault());
            }
        }
        boolean requiresDefaultFrame = w instanceof Lead && REQUIRES_DEFAULT_FRAME_IN_LEAD_LAG_ORDER_BY.contains((Object)ctx.dialect()) || w instanceof Lag && REQUIRES_DEFAULT_FRAME_IN_LEAD_LAG_ORDER_BY.contains((Object)ctx.dialect());
        boolean hasWindowDefinitions = this.windowDefinition != null;
        boolean hasPartitionBy = !this.partitionBy.isEmpty();
        boolean hasOrderBy = !o.isEmpty();
        boolean hasFrame = this.frameStart != null || hasOrderBy && requiresDefaultFrame;
        int clauses = 0;
        if (hasWindowDefinitions) {
            ++clauses;
        }
        if (hasPartitionBy) {
            ++clauses;
        }
        if (hasOrderBy) {
            ++clauses;
        }
        if (hasFrame) {
            ++clauses;
        }
        boolean bl = indent = clauses > 1;
        if (indent) {
            ctx.formatIndentStart().formatNewLine();
        }
        if (this.windowDefinition != null) {
            ctx.declareWindows(false, c -> c.visit(this.windowDefinition));
        }
        if (hasPartitionBy) {
            if (hasWindowDefinitions) {
                ctx.formatSeparator();
            }
            ctx.visit(Keywords.K_PARTITION_BY).separatorRequired(true).visit(this.partitionBy);
        }
        if (hasOrderBy) {
            if (hasWindowDefinitions || hasPartitionBy) {
                ctx.formatSeparator();
            }
            ctx.visit(Keywords.K_ORDER_BY).separatorRequired(true).visit(o);
        }
        if (hasFrame) {
            if (hasWindowDefinitions || hasPartitionBy || hasOrderBy) {
                ctx.formatSeparator();
            }
            QOM.FrameUnits u = this.frameUnits;
            Integer s2 = this.frameStart;
            Integer e = this.frameEnd;
            if (s2 == null && requiresDefaultFrame) {
                u = QOM.FrameUnits.RANGE;
                s2 = Integer.MIN_VALUE;
                e = Integer.MAX_VALUE;
            }
            ctx.visit(u.keyword).sql(' ');
            if (e != null) {
                ctx.visit(Keywords.K_BETWEEN).sql(' ');
                this.toSQLRows(ctx, s2);
                ctx.sql(' ').visit(Keywords.K_AND).sql(' ');
                this.toSQLRows(ctx, e);
            } else {
                this.toSQLRows(ctx, s2);
            }
            if (this.exclude != null) {
                ctx.sql(' ').visit(Keywords.K_EXCLUDE).sql(' ').visit(this.exclude.keyword);
            }
        }
        if (indent) {
            ctx.formatIndentEnd().formatNewLine();
        }
    }

    private final void toSQLRows(Context<?> ctx, Integer rows) {
        if (rows == Integer.MIN_VALUE) {
            ctx.visit(Keywords.K_UNBOUNDED_PRECEDING);
        } else if (rows == Integer.MAX_VALUE) {
            ctx.visit(Keywords.K_UNBOUNDED_FOLLOWING);
        } else if (rows < 0) {
            ctx.sql(-rows.intValue()).sql(' ').visit(Keywords.K_PRECEDING);
        } else if (rows > 0) {
            ctx.sql(rows).sql(' ').visit(Keywords.K_FOLLOWING);
        } else {
            ctx.visit(Keywords.K_CURRENT_ROW);
        }
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(GroupField ... fields) {
        return this.partitionBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(Collection<? extends GroupField> fields) {
        this.partitionBy.addAll(fields);
        return this;
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(OrderField<?> ... fields) {
        return this.orderBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(Collection<? extends OrderField<?>> fields) {
        this.orderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsUnboundedPreceding() {
        this.frameUnits = QOM.FrameUnits.ROWS;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsPreceding(int number) {
        this.frameUnits = QOM.FrameUnits.ROWS;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsCurrentRow() {
        this.frameUnits = QOM.FrameUnits.ROWS;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsUnboundedFollowing() {
        this.frameUnits = QOM.FrameUnits.ROWS;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsFollowing(int number) {
        this.frameUnits = QOM.FrameUnits.ROWS;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedPreceding() {
        this.rowsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenPreceding(int number) {
        this.rowsPreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenCurrentRow() {
        this.rowsCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedFollowing() {
        this.rowsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenFollowing(int number) {
        this.rowsFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeUnboundedPreceding() {
        this.frameUnits = QOM.FrameUnits.RANGE;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangePreceding(int number) {
        this.frameUnits = QOM.FrameUnits.RANGE;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeCurrentRow() {
        this.frameUnits = QOM.FrameUnits.RANGE;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeUnboundedFollowing() {
        this.frameUnits = QOM.FrameUnits.RANGE;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeFollowing(int number) {
        this.frameUnits = QOM.FrameUnits.RANGE;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenUnboundedPreceding() {
        this.rangeUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenPreceding(int number) {
        this.rangePreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenCurrentRow() {
        this.rangeCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenUnboundedFollowing() {
        this.rangeUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenFollowing(int number) {
        this.rangeFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsUnboundedPreceding() {
        this.frameUnits = QOM.FrameUnits.GROUPS;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsPreceding(int number) {
        this.frameUnits = QOM.FrameUnits.GROUPS;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsCurrentRow() {
        this.frameUnits = QOM.FrameUnits.GROUPS;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsUnboundedFollowing() {
        this.frameUnits = QOM.FrameUnits.GROUPS;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsFollowing(int number) {
        this.frameUnits = QOM.FrameUnits.GROUPS;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenUnboundedPreceding() {
        this.groupsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenPreceding(int number) {
        this.groupsPreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenCurrentRow() {
        this.groupsCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenUnboundedFollowing() {
        this.groupsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenFollowing(int number) {
        this.groupsFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andUnboundedPreceding() {
        this.frameEnd = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andPreceding(int number) {
        this.frameEnd = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andCurrentRow() {
        this.frameEnd = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andUnboundedFollowing() {
        this.frameEnd = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andFollowing(int number) {
        this.frameEnd = number;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeCurrentRow() {
        this.exclude = QOM.FrameExclude.CURRENT_ROW;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeGroup() {
        this.exclude = QOM.FrameExclude.GROUP;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeTies() {
        this.exclude = QOM.FrameExclude.TIES;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeNoOthers() {
        this.exclude = QOM.FrameExclude.NO_OTHERS;
        return this;
    }

    @Override
    public final WindowDefinitionImpl $windowDefinition() {
        return this.windowDefinition;
    }

    public final QOM.UnmodifiableList<? extends Field<?>> $partitionBy() {
        return QOM.unmodifiable(this.partitionBy);
    }

    @Override
    public final QOM.UnmodifiableList<? extends SortField<?>> $orderBy() {
        return QOM.unmodifiable(this.orderBy);
    }

    @Override
    public final QOM.FrameUnits $frameUnits() {
        return this.frameUnits;
    }

    @Override
    public final Integer $frameStart() {
        return this.frameStart;
    }

    @Override
    public final Integer $frameEnd() {
        return this.frameEnd;
    }

    @Override
    public final QOM.FrameExclude $exclude() {
        return this.exclude;
    }
}

