/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.tools.json;

import io.lumine.mythic.bukkit.utils.lib.jooq.tools.json.JSONArray;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.json.JSONObject;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.json.JSONParser;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.json.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JSONValue {
    public static void writeJSONString(Object value, Writer out) throws IOException {
        if (value == null) {
            out.write("null");
            return;
        }
        if (value instanceof String) {
            String s2 = (String)value;
            out.write(34);
            out.write(JSONValue.escape(s2));
            out.write(34);
            return;
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            if (d.isInfinite() || d.isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            if (f.isInfinite() || f.isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Number) {
            out.write(value.toString());
            return;
        }
        if (value instanceof Boolean) {
            out.write(value.toString());
            return;
        }
        if (value instanceof Map) {
            Map m4 = (Map)value;
            JSONObject.writeJSONString(m4, out);
            return;
        }
        if (value instanceof List) {
            List l = (List)value;
            JSONArray.writeJSONString(l, out);
            return;
        }
        if (value instanceof Object[]) {
            Object[] a = (Object[])value;
            JSONArray.writeJSONString(Arrays.asList(a), out);
            return;
        }
        out.write(34);
        out.write(JSONValue.escape(value.toString()));
        out.write(34);
    }

    public static String toJSONString(Object value) {
        StringWriter w = new StringWriter();
        try {
            JSONValue.writeJSONString(value, w);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)w).toString();
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        JSONValue.escape(s2, sb);
        return sb.toString();
    }

    static void escape(String s2, StringBuffer sb) {
        block10: for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in);
    }

    public static Object parseWithException(String s2) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s2);
    }
}

