/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.ml.neuralnet;

import io.lumine.mythic.bukkit.utils.lib.math3.analysis.UnivariateFunction;
import io.lumine.mythic.bukkit.utils.lib.math3.analysis.function.Constant;
import io.lumine.mythic.bukkit.utils.lib.math3.distribution.RealDistribution;
import io.lumine.mythic.bukkit.utils.lib.math3.distribution.UniformRealDistribution;
import io.lumine.mythic.bukkit.utils.lib.math3.ml.neuralnet.FeatureInitializer;
import io.lumine.mythic.bukkit.utils.lib.math3.random.RandomGenerator;

public class FeatureInitializerFactory {
    private FeatureInitializerFactory() {
    }

    public static FeatureInitializer uniform(RandomGenerator rng, double min2, double max) {
        return FeatureInitializerFactory.randomize(new UniformRealDistribution(rng, min2, max), FeatureInitializerFactory.function(new Constant(0.0), 0.0, 0.0));
    }

    public static FeatureInitializer uniform(double min2, double max) {
        return FeatureInitializerFactory.randomize(new UniformRealDistribution(min2, max), FeatureInitializerFactory.function(new Constant(0.0), 0.0, 0.0));
    }

    public static FeatureInitializer function(final UnivariateFunction f, final double init, final double inc) {
        return new FeatureInitializer(){
            private double arg;
            {
                this.arg = init;
            }

            public double value() {
                double result = f.value(this.arg);
                this.arg += inc;
                return result;
            }
        };
    }

    public static FeatureInitializer randomize(final RealDistribution random, final FeatureInitializer orig) {
        return new FeatureInitializer(){

            public double value() {
                return orig.value() + random.sample();
            }
        };
    }
}

