/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.ode.nonstiff;

import io.lumine.mythic.bukkit.utils.lib.math3.exception.DimensionMismatchException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.MaxCountExceededException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.NoBracketingException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.NumberIsTooSmallException;
import io.lumine.mythic.bukkit.utils.lib.math3.ode.AbstractIntegrator;
import io.lumine.mythic.bukkit.utils.lib.math3.ode.ExpandableStatefulODE;
import io.lumine.mythic.bukkit.utils.lib.math3.ode.FirstOrderDifferentialEquations;
import io.lumine.mythic.bukkit.utils.lib.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import io.lumine.mythic.bukkit.utils.lib.math3.util.FastMath;

public abstract class RungeKuttaIntegrator
extends AbstractIntegrator {
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final RungeKuttaStepInterpolator prototype;
    private final double step;

    protected RungeKuttaIntegrator(String name, double[] c, double[][] a, double[] b, RungeKuttaStepInterpolator prototype, double step) {
        super(name);
        this.c = c;
        this.a = a;
        this.b = b;
        this.prototype = prototype;
        this.step = FastMath.abs(step);
    }

    public void integrate(ExpandableStatefulODE equations, double t2) throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException {
        this.sanityChecks(equations, t2);
        this.setEquations(equations);
        boolean forward = t2 > equations.getTime();
        double[] y0 = equations.getCompleteState();
        double[] y = (double[])y0.clone();
        int stages = this.c.length + 1;
        double[][] yDotK = new double[stages][];
        for (int i = 0; i < stages; ++i) {
            yDotK[i] = new double[y0.length];
        }
        double[] yTmp = (double[])y0.clone();
        double[] yDotTmp = new double[y0.length];
        RungeKuttaStepInterpolator interpolator = (RungeKuttaStepInterpolator)this.prototype.copy();
        interpolator.reinitialize(this, yTmp, yDotK, forward, equations.getPrimaryMapper(), equations.getSecondaryMappers());
        interpolator.storeTime(equations.getTime());
        this.stepStart = equations.getTime();
        this.stepSize = forward ? (this.stepStart + this.step >= t2 ? t2 - this.stepStart : this.step) : (this.stepStart - this.step <= t2 ? t2 - this.stepStart : -this.step);
        this.initIntegration(equations.getTime(), y0, t2);
        this.isLastStep = false;
        do {
            boolean nextIsLast;
            interpolator.shift();
            this.computeDerivatives(this.stepStart, y, yDotK[0]);
            for (int k = 1; k < stages; ++k) {
                for (int j = 0; j < y0.length; ++j) {
                    double sum = this.a[k - 1][0] * yDotK[0][j];
                    for (int l = 1; l < k; ++l) {
                        sum += this.a[k - 1][l] * yDotK[l][j];
                    }
                    yTmp[j] = y[j] + this.stepSize * sum;
                }
                this.computeDerivatives(this.stepStart + this.c[k - 1] * this.stepSize, yTmp, yDotK[k]);
            }
            for (int j = 0; j < y0.length; ++j) {
                double sum = this.b[0] * yDotK[0][j];
                for (int l = 1; l < stages; ++l) {
                    sum += this.b[l] * yDotK[l][j];
                }
                yTmp[j] = y[j] + this.stepSize * sum;
            }
            interpolator.storeTime(this.stepStart + this.stepSize);
            System.arraycopy(yTmp, 0, y, 0, y0.length);
            System.arraycopy(yDotK[stages - 1], 0, yDotTmp, 0, y0.length);
            this.stepStart = this.acceptStep(interpolator, y, yDotTmp, t2);
            if (this.isLastStep) continue;
            interpolator.storeTime(this.stepStart);
            double nextT = this.stepStart + this.stepSize;
            boolean bl = forward ? nextT >= t2 : (nextIsLast = nextT <= t2);
            if (!nextIsLast) continue;
            this.stepSize = t2 - this.stepStart;
        } while (!this.isLastStep);
        equations.setTime(this.stepStart);
        equations.setCompleteState(y);
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
    }

    public double[] singleStep(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t2) {
        double[] y = (double[])y0.clone();
        int stages = this.c.length + 1;
        double[][] yDotK = new double[stages][];
        for (int i = 0; i < stages; ++i) {
            yDotK[i] = new double[y0.length];
        }
        double[] yTmp = (double[])y0.clone();
        double h2 = t2 - t0;
        equations.computeDerivatives(t0, y, yDotK[0]);
        for (int k = 1; k < stages; ++k) {
            for (int j = 0; j < y0.length; ++j) {
                double sum = this.a[k - 1][0] * yDotK[0][j];
                for (int l = 1; l < k; ++l) {
                    sum += this.a[k - 1][l] * yDotK[l][j];
                }
                yTmp[j] = y[j] + h2 * sum;
            }
            equations.computeDerivatives(t0 + this.c[k - 1] * h2, yTmp, yDotK[k]);
        }
        int j = 0;
        while (j < y0.length) {
            double sum = this.b[0] * yDotK[0][j];
            for (int l = 1; l < stages; ++l) {
                sum += this.b[l] * yDotK[l][j];
            }
            int n = j++;
            y[n] = y[n] + h2 * sum;
        }
        return y;
    }
}

