/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.optim.nonlinear.scalar;

import io.lumine.mythic.bukkit.utils.lib.math3.analysis.UnivariateFunction;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.MaxEval;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.nonlinear.scalar.GoalType;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.univariate.BracketFinder;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.univariate.BrentOptimizer;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.univariate.SearchInterval;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.univariate.SimpleUnivariateValueChecker;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.univariate.UnivariateObjectiveFunction;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.univariate.UnivariateOptimizer;
import io.lumine.mythic.bukkit.utils.lib.math3.optim.univariate.UnivariatePointValuePair;

public class LineSearch {
    private static final double REL_TOL_UNUSED = 1.0E-15;
    private static final double ABS_TOL_UNUSED = Double.MIN_VALUE;
    private final UnivariateOptimizer lineOptimizer;
    private final BracketFinder bracket = new BracketFinder();
    private final double initialBracketingRange;
    private final MultivariateOptimizer mainOptimizer;

    public LineSearch(MultivariateOptimizer optimizer, double relativeTolerance, double absoluteTolerance, double initialBracketingRange) {
        this.mainOptimizer = optimizer;
        this.lineOptimizer = new BrentOptimizer(1.0E-15, Double.MIN_VALUE, new SimpleUnivariateValueChecker(relativeTolerance, absoluteTolerance));
        this.initialBracketingRange = initialBracketingRange;
    }

    public UnivariatePointValuePair search(final double[] startPoint, final double[] direction) {
        final int n = startPoint.length;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double alpha) {
                double[] x = new double[n];
                for (int i = 0; i < n; ++i) {
                    x[i] = startPoint[i] + alpha * direction[i];
                }
                double obj = LineSearch.this.mainOptimizer.computeObjectiveValue(x);
                return obj;
            }
        };
        GoalType goal = this.mainOptimizer.getGoalType();
        this.bracket.search(f, goal, 0.0, this.initialBracketingRange);
        return this.lineOptimizer.optimize(new MaxEval(Integer.MAX_VALUE), new UnivariateObjectiveFunction(f), goal, new SearchInterval(this.bracket.getLo(), this.bracket.getHi(), this.bracket.getMid()));
    }
}

