/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

import io.lumine.mythic.bukkit.utils.numbers.AngleUnit;

public class Angle {
    private final double radians;

    public Angle(double value, AngleUnit unit) {
        this.radians = unit.toRadians(value);
    }

    public static Angle fromDegrees(double deg) {
        return new Angle(deg, AngleUnit.DEGREES);
    }

    public static Angle fromRadians(double rad) {
        return new Angle(rad, AngleUnit.RADIANS);
    }

    public double getDegrees() {
        return AngleUnit.DEGREES.fromRadians(this.radians);
    }

    public double getRadians() {
        return this.radians;
    }

    public double getSlope() {
        return AngleUnit.SLOPE.fromRadians(this.radians);
    }

    public static Angle parse(String input, AngleUnit defaultUnit) {
        double value;
        int i;
        if (input == null || input.isBlank()) {
            throw new IllegalArgumentException("Empty angle string");
        }
        String s2 = input.trim();
        for (i = s2.length() - 1; i >= 0 && (Character.isLetter(s2.charAt(i)) || s2.charAt(i) == '\u00b0'); --i) {
        }
        String numPart = s2.substring(0, i + 1).trim();
        String sufPart = s2.substring(i + 1).trim();
        try {
            value = Double.parseDouble(numPart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number in angle: " + numPart, e);
        }
        if (sufPart.isEmpty()) {
            return new Angle(value, defaultUnit);
        }
        AngleUnit unit = AngleUnit.fromSuffix(sufPart);
        if (unit == null) {
            throw new IllegalArgumentException("Unknown angle suffix: " + sufPart);
        }
        return new Angle(value, unit);
    }

    public static boolean isAngle(String input) {
        int i;
        if (input == null || input.isBlank()) {
            return false;
        }
        String s2 = input.trim();
        for (i = s2.length() - 1; i >= 0 && (Character.isLetter(s2.charAt(i)) || s2.charAt(i) == '\u00b0'); --i) {
        }
        String numPart = s2.substring(0, i + 1).trim();
        String sufPart = s2.substring(i + 1).trim();
        try {
            Double.parseDouble(numPart);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (sufPart.isEmpty()) {
            return true;
        }
        return AngleUnit.fromSuffix(sufPart) != null;
    }

    public String toString() {
        return String.format("Angle{degrees=%.2f,radians=%.4f}", this.getDegrees(), this.getRadians());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Angle)) {
            return false;
        }
        Angle other = (Angle)obj;
        return Double.compare(this.radians, other.radians) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.radians);
    }
}

