/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

import io.lumine.mythic.bukkit.utils.numbers.Angle;
import io.lumine.mythic.bukkit.utils.numbers.AngleUnit;
import java.util.Random;

public class RandomAngle {
    private static final Random RANDOM = new Random();
    private boolean isStatic;
    private final Angle min;
    private final Angle max;

    public RandomAngle(Angle angle) {
        this.min = angle;
        this.max = angle;
        this.isStatic = true;
    }

    public RandomAngle(Angle min2, Angle max) {
        this.min = min2;
        this.max = max;
        this.isStatic = false;
    }

    public RandomAngle(String value, AngleUnit defaultUnit) {
        Angle b;
        Angle a;
        String v = value.trim();
        try {
            if (v.contains("to")) {
                String[] parts = v.split("to", 2);
                a = Angle.parse(parts[0], defaultUnit);
                b = Angle.parse(parts[1], defaultUnit);
                this.isStatic = false;
            } else if (!v.startsWith("-") && v.contains("-")) {
                String[] parts = v.split("-", 2);
                a = Angle.parse(parts[0], defaultUnit);
                b = Angle.parse(parts[1], defaultUnit);
                this.isStatic = false;
            } else {
                b = a = Angle.parse(v, defaultUnit);
                this.isStatic = true;
            }
        }
        catch (Exception e) {
            b = a = Angle.fromDegrees(0.0);
            this.isStatic = true;
            e.printStackTrace();
        }
        this.min = a;
        this.max = b;
    }

    public RandomAngle(String value) {
        this(value, AngleUnit.DEGREES);
    }

    public Angle get() {
        if (this.isStatic) {
            return this.min;
        }
        double lo = this.min.getRadians();
        double hi = this.max.getRadians();
        double randRad = lo + RANDOM.nextDouble() * (hi - lo);
        return Angle.fromRadians(randRad);
    }

    public String toString() {
        return "RandomAngle{" + String.valueOf(this.min) + " to " + String.valueOf(this.max) + "}";
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public static boolean matches(String value) {
        return Angle.isAngle(value);
    }

    public static boolean matchesRange(String value) {
        if (value == null) {
            return false;
        }
        String v = value.trim();
        if (v.contains("to")) {
            String[] p = v.split("to", 2);
            return Angle.isAngle(p[0]) && Angle.isAngle(p[1]);
        }
        if (!v.startsWith("-") && v.contains("-")) {
            String[] p = v.split("-", 2);
            return Angle.isAngle(p[0]) && Angle.isAngle(p[1]);
        }
        return false;
    }

    public Angle getMin() {
        return this.min;
    }

    public Angle getMax() {
        return this.max;
    }
}

