/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedLong {
    protected final Operation op;
    protected long min;
    protected long max;

    public RangedLong(String value) {
        this(value, false);
    }

    public RangedLong(String value, boolean squared) {
        if (value.startsWith(">=")) {
            long v;
            this.min = v = Long.parseLong(value.substring(2));
            this.max = Long.MAX_VALUE;
            this.op = Operation.GREATER_THAN_OR_EQUAL;
        } else if (value.startsWith("<=")) {
            long v = Long.parseLong(value.substring(2));
            this.min = Long.MIN_VALUE;
            this.max = v;
            this.op = Operation.LESS_THAN_OR_EQUAL;
        } else if (value.startsWith(">")) {
            long v;
            this.min = v = Long.parseLong(value.substring(1));
            this.max = Long.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            long v = Long.parseLong(value.substring(1));
            this.min = Long.MIN_VALUE;
            this.max = v;
            this.op = Operation.LESS_THAN;
        } else if (value.contains("to")) {
            String[] split = value.split("to");
            this.min = Long.parseLong(split[0]);
            this.max = Long.parseLong(split[1]);
            this.op = Operation.RANGE;
        } else if (!value.startsWith("-") && value.contains("-")) {
            String[] split = value.split("-");
            this.min = Long.parseLong(split[0]);
            this.max = Long.parseLong(split[1]);
            this.op = Operation.RANGE;
        } else {
            long v;
            this.min = v = Long.parseLong(value);
            this.max = v;
            this.op = Operation.EQUALS;
        }
        if (this.min > this.max) {
            long tmp = this.min;
            this.min = this.max;
            this.max = tmp;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Number)) {
            return false;
        }
        long d = ((Number)o).longValue();
        switch (this.op.ordinal()) {
            case 0: {
                return d == this.min;
            }
            case 1: {
                return d > this.min;
            }
            case 2: {
                return d >= this.min;
            }
            case 3: {
                return d < this.max;
            }
            case 4: {
                return d <= this.max;
            }
            case 5: {
                return d >= this.min && d <= this.max;
            }
        }
        return false;
    }

    public String toString() {
        return "RangedLong{min=" + this.min + ", max=" + this.max + ", op=" + String.valueOf((Object)this.op) + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        RANGE;

    }
}

