/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles;

import io.lumine.mythic.bukkit.utils.particles.reflection.MappedReflectionAccessor;
import io.lumine.mythic.bukkit.utils.particles.reflection.ReflectionAccessor;
import io.lumine.mythic.bukkit.utils.particles.reflection.TransparentReflectionAccessor;
import io.lumine.mythic.bukkit.utils.particles.reflection.Version;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.Mappings;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files.MappingFileReader;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files.ProguardMapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public abstract class Laser {
    protected final int distanceSquared;
    protected final int duration;
    protected boolean durationInTicks = false;
    protected Location start;
    protected Location end;
    protected Plugin plugin;
    protected BukkitRunnable main;
    protected BukkitTask startMove;
    protected BukkitTask endMove;
    protected Set<Player> show = ConcurrentHashMap.newKeySet();
    private Set<Player> seen = new HashSet<Player>();
    private List<Runnable> executeEnd = new ArrayList<Runnable>(1);

    protected Laser(Location start, Location end, int duration, int distance) {
        Packets.ensureInitialized();
        if (start.getWorld() != end.getWorld()) {
            throw new IllegalArgumentException("Locations do not belong to the same worlds.");
        }
        this.start = start.clone();
        this.end = end.clone();
        this.duration = duration;
        this.distanceSquared = distance < 0 ? -1 : distance * distance;
    }

    public Laser executeEnd(Runnable runnable) {
        this.executeEnd.add(runnable);
        return this;
    }

    public Laser durationInTicks() {
        this.durationInTicks = true;
        return this;
    }

    public void start(Plugin plugin) {
        if (this.main != null) {
            throw new IllegalStateException("Task already started");
        }
        this.plugin = plugin;
        this.main = new BukkitRunnable(){
            int time = 0;

            public void run() {
                try {
                    if (this.time == Laser.this.duration) {
                        this.cancel();
                        return;
                    }
                    if (!Laser.this.durationInTicks || this.time % 20 == 0) {
                        for (Player p : Laser.this.start.getWorld().getPlayers()) {
                            if (Laser.this.isCloseEnough(p)) {
                                if (!Laser.this.show.add(p)) continue;
                                Laser.this.sendStartPackets(p, !Laser.this.seen.add(p));
                                continue;
                            }
                            if (!Laser.this.show.remove(p)) continue;
                            Laser.this.sendDestroyPackets(p);
                        }
                    }
                    ++this.time;
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                Laser.this.main = null;
                try {
                    for (Player p : Laser.this.show) {
                        Laser.this.sendDestroyPackets(p);
                    }
                    Laser.this.show.clear();
                    Laser.this.executeEnd.forEach(Runnable::run);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
        };
        this.main.runTaskTimerAsynchronously(plugin, 0L, this.durationInTicks ? 1L : 20L);
    }

    public void stop() {
        if (this.main == null) {
            throw new IllegalStateException("Task not started");
        }
        this.main.cancel();
    }

    public boolean isStarted() {
        return this.main != null;
    }

    public abstract LaserType getLaserType();

    public abstract void moveStart(Location var1) throws ReflectiveOperationException;

    public abstract void moveEnd(Location var1) throws ReflectiveOperationException;

    public Location getStart() {
        return this.start.clone();
    }

    public Location getEnd() {
        return this.end.clone();
    }

    public void moveStart(Location location, int ticks, Runnable callback) {
        this.startMove = this.moveInternal(location, ticks, this.startMove, this.getStart(), this::moveStart, callback);
    }

    public void moveEnd(Location location, int ticks, Runnable callback) {
        this.endMove = this.moveInternal(location, ticks, this.endMove, this.getEnd(), this::moveEnd, callback);
    }

    private BukkitTask moveInternal(final Location location, final int ticks, BukkitTask oldTask, final Location from, final ReflectiveConsumer<Location> moveConsumer, final Runnable callback) {
        if (ticks <= 0) {
            throw new IllegalArgumentException("Ticks must be a positive value");
        }
        if (this.plugin == null) {
            throw new IllegalStateException("The laser must have been started a least once");
        }
        if (oldTask != null && !oldTask.isCancelled()) {
            oldTask.cancel();
        }
        return new BukkitRunnable(){
            double xPerTick;
            double yPerTick;
            double zPerTick;
            Location loc;
            int elapsed;
            {
                this.xPerTick = (location.getX() - from.getX()) / (double)ticks;
                this.yPerTick = (location.getY() - from.getY()) / (double)ticks;
                this.zPerTick = (location.getZ() - from.getZ()) / (double)ticks;
                this.loc = from.clone();
                this.elapsed = 0;
            }

            public void run() {
                try {
                    this.loc.add(this.xPerTick, this.yPerTick, this.zPerTick);
                    moveConsumer.accept(this.loc);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    this.cancel();
                    return;
                }
                if (++this.elapsed == ticks) {
                    this.cancel();
                    if (callback != null) {
                        callback.run();
                    }
                }
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    protected void moveFakeEntity(Location location, Object fakeEntity) throws ReflectiveOperationException {
        if (fakeEntity != null) {
            Packets.moveFakeEntity(fakeEntity, location);
        }
        if (this.main == null) {
            return;
        }
        Object packet = Packets.createPacketMoveEntity(fakeEntity);
        for (Player p : this.show) {
            Packets.sendPackets(p, packet);
        }
    }

    protected abstract void sendStartPackets(Player var1, boolean var2) throws ReflectiveOperationException;

    protected abstract void sendDestroyPackets(Player var1) throws ReflectiveOperationException;

    protected boolean isCloseEnough(Player player) {
        if (this.distanceSquared == -1) {
            return true;
        }
        Location location = player.getLocation();
        return this.getStart().distanceSquared(location) <= (double)this.distanceSquared || this.getEnd().distanceSquared(location) <= (double)this.distanceSquared;
    }

    protected static class Packets {
        private static AtomicInteger lastIssuedEID = new AtomicInteger(2000000000);
        private static Logger logger;
        private static String cpack;
        private static Version version;
        private static boolean isEnabled;
        private static boolean hasInitialized;
        private static Throwable initializationError;
        private static Object squidType;
        private static Object guardianType;
        private static Constructor<?> crystalConstructor;
        private static Constructor<?> squidConstructor;
        private static Constructor<?> guardianConstructor;
        private static Object dataAccessorFlags;
        private static Object dataAccessorGuardianMoving;
        private static Object dataAccessorGuardianTarget;
        private static Object dataAccessorCrystalTarget;
        private static Object dataAccessorCrystalBottom;
        private static ReflectionAccessor.ClassAccessor dataWatcherClass;
        private static ReflectionAccessor.ClassAccessor dataAccessorClass;
        private static Method watcherSet;
        private static Method watcherDirty;
        private static Method watcherPack;
        private static Constructor<?> blockPositionConstructor;
        private static Constructor<?> packetSpawnLiving;
        private static Constructor<?> packetSpawnNormal;
        private static Constructor<?> packetRemove;
        private static Constructor<?> packetTeleport;
        private static Method packetTeleportOf;
        private static Constructor<?> packetMetadata;
        private static ReflectionAccessor.ClassAccessor packetTeam;
        private static Method createTeamPacket;
        private static Constructor<?> createTeam;
        private static Constructor<?> createScoreboard;
        private static Method setTeamPush;
        private static Object pushNever;
        private static Method getTeamPlayers;
        private static Method getPlayerHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Method getData;
        private static Field entityBlockPosition;
        private static Method setLocation;
        private static Method setUUID;
        private static Method setID;
        private static Object nmsWorld;

        protected Packets() {
        }

        static int generateEID() {
            return lastIssuedEID.getAndIncrement();
        }

        protected static void ensureInitialized() {
            if (!hasInitialized) {
                Packets.initialize();
            }
            if (!isEnabled) {
                throw new IllegalStateException("The GuardianBeam API is disabled. An error has occured during first initialization.", initializationError);
            }
        }

        private static void initialize() {
            hasInitialized = true;
            try {
                ReflectionAccessor reflection;
                boolean remapped;
                logger = new Logger("GuardianBeam", null){

                    @Override
                    public void log(LogRecord logRecord) {
                        logRecord.setMessage("[GuardianBeam] " + logRecord.getMessage());
                        super.log(logRecord);
                    }
                };
                logger.setParent(Bukkit.getServer().getLogger());
                logger.setLevel(Level.ALL);
                String versionString = Bukkit.getBukkitVersion().split("-R")[0];
                Version serverVersion = Version.parse(versionString);
                logger.info("Found server version " + serverVersion);
                cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
                boolean bl = remapped = Bukkit.getServer().getClass().getPackage().getName().split("\\.").length == 3;
                if (remapped) {
                    version = serverVersion;
                    reflection = new TransparentReflectionAccessor();
                    logger.info("Loaded transparent mappings.");
                } else {
                    String mappingsFile = new String(Laser.class.getResourceAsStream("mappings/spigot.txt").readAllBytes());
                    MappingFileReader mappingsReader = new MappingFileReader(new ProguardMapping(false), mappingsFile.lines().toList());
                    mappingsReader.readAvailableVersions();
                    Optional<Version> foundVersion = mappingsReader.keepBestMatchedVersion(serverVersion);
                    if (foundVersion.isEmpty()) {
                        throw new UnsupportedOperationException("Cannot find mappings to match server version");
                    }
                    if (!foundVersion.get().is(serverVersion)) {
                        logger.warning("Loaded not matching version of the mappings for your server version");
                    }
                    version = foundVersion.get();
                    mappingsReader.parseMappings();
                    Mappings mappings = mappingsReader.getParsedMappings(foundVersion.get());
                    logger.info("Loaded mappings for " + version);
                    reflection = new MappedReflectionAccessor(mappings);
                }
                Packets.loadReflection(reflection, version);
                isEnabled = true;
            }
            catch (Exception ex) {
                initializationError = ex;
                String errorMsg = "Lasers reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getBukkitVersion() + ") is supported.";
                if (logger == null) {
                    ex.printStackTrace();
                    System.err.println(errorMsg);
                }
                logger.log(Level.SEVERE, errorMsg, ex);
            }
        }

        protected static void loadReflection(@NotNull ReflectionAccessor reflection, @NotNull Version version) throws ReflectiveOperationException {
            Type[] typeArray;
            Type[] typeArray2;
            ReflectionAccessor.ClassAccessor entityTypesClass = Packets.getNMSClass(reflection, "world.entity", "EntityType");
            ReflectionAccessor.ClassAccessor entityClass = Packets.getNMSClass(reflection, "world.entity", "Entity");
            ReflectionAccessor.ClassAccessor crystalClass = Packets.getNMSClass(reflection, "world.entity.boss.enderdragon", "EndCrystal");
            ReflectionAccessor.ClassAccessor squidClass = Packets.getNMSClass(reflection, "world.entity.animal", "Squid");
            ReflectionAccessor.ClassAccessor guardianClass = Packets.getNMSClass(reflection, "world.entity.monster", "Guardian");
            ReflectionAccessor.ClassAccessor blockPosClass = Packets.getNMSClass(reflection, "core", "BlockPos");
            dataAccessorFlags = entityClass.getField("DATA_SHARED_FLAGS_ID").get(null);
            dataAccessorGuardianMoving = guardianClass.getField("DATA_ID_MOVING").get(null);
            dataAccessorGuardianTarget = guardianClass.getField("DATA_ID_ATTACK_TARGET").get(null);
            dataAccessorCrystalTarget = crystalClass.getField("DATA_BEAM_TARGET").get(null);
            dataAccessorCrystalBottom = crystalClass.getField("DATA_SHOW_BOTTOM").get(null);
            squidType = entityTypesClass.getField("SQUID").get(null);
            guardianType = entityTypesClass.getField("GUARDIAN").get(null);
            dataWatcherClass = Packets.getNMSClass(reflection, "network.syncher", "SynchedEntityData");
            dataAccessorClass = Packets.getNMSClass(reflection, "network.syncher", "EntityDataAccessor");
            if (version.isAfter(1, 19, 4)) {
                watcherSet = dataWatcherClass.getMethodInstance("set", new Type[]{dataAccessorClass, Object.class, Boolean.TYPE});
                watcherPack = dataWatcherClass.getMethodInstance("packDirty", new Type[0]);
            } else {
                watcherSet = dataWatcherClass.getMethodInstance("set", new Type[]{dataAccessorClass, Object.class});
                if (cpack != null) {
                    watcherDirty = dataWatcherClass.getClassInstance().getDeclaredMethod("markDirty", dataAccessorClass.getClassInstance());
                }
            }
            ReflectionAccessor.ClassAccessor classAccessor = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundAddEntityPacket");
            if (version.isBefore(1, 21, 0)) {
                Type[] typeArray3 = new Type[1];
                typeArray2 = typeArray3;
                typeArray3[0] = entityClass;
            } else {
                Type[] typeArray4 = new Type[3];
                typeArray4[0] = entityClass;
                typeArray4[1] = Integer.TYPE;
                typeArray2 = typeArray4;
                typeArray4[2] = blockPosClass;
            }
            packetSpawnNormal = classAccessor.getConstructorInstance(typeArray2);
            if (version.isBefore(1, 19, 0)) {
                packetSpawnLiving = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundAddMobPacket").getConstructorInstance(Packets.getNMSClass(reflection, "world.entity", "LivingEntity"));
            }
            packetRemove = version.is(1, 17, 0) ? Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundRemoveEntityPacket").getConstructorInstance(Integer.TYPE) : Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundRemoveEntitiesPacket").getConstructorInstance(new Type[]{int[].class});
            ReflectionAccessor.ClassAccessor classAccessor2 = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundSetEntityDataPacket");
            if (version.isBefore(1, 19, 3)) {
                Type[] typeArray5 = new Type[3];
                typeArray5[0] = Integer.TYPE;
                typeArray5[1] = dataWatcherClass;
                typeArray = typeArray5;
                typeArray5[2] = Boolean.TYPE;
            } else {
                Type[] typeArray6 = new Type[2];
                typeArray6[0] = Integer.TYPE;
                typeArray = typeArray6;
                typeArray6[1] = List.class;
            }
            packetMetadata = classAccessor2.getConstructorInstance(typeArray);
            if (version.isBefore(1, 21, 2)) {
                packetTeleport = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundTeleportEntityPacket").getConstructorInstance(entityClass);
            } else {
                packetTeleportOf = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundEntityPositionSyncPacket").getMethodInstance("of", entityClass);
            }
            blockPositionConstructor = Packets.getNMSClass(reflection, "core", "BlockPos").getConstructorInstance(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            ReflectionAccessor.ClassAccessor levelClass = Packets.getNMSClass(reflection, "world.level", "Level");
            squidConstructor = squidClass.getConstructorInstance(entityTypesClass, levelClass);
            guardianConstructor = guardianClass.getConstructorInstance(entityTypesClass, levelClass);
            crystalConstructor = crystalClass.getConstructorInstance(levelClass, Double.TYPE, Double.TYPE, Double.TYPE);
            playerConnection = Packets.getNMSClass(reflection, "server.level", "ServerPlayer").getFieldInstance("connection");
            ReflectionAccessor.ClassAccessor packetListenerClass = Packets.getNMSClass(reflection, "server.network", version.isAfter(1, 20, 2) ? "ServerCommonPacketListenerImpl" : "ServerGamePacketListenerImpl");
            sendPacket = packetListenerClass.getMethodInstance("send", Packets.getNMSClass(reflection, "network.protocol", "Packet"));
            getData = entityClass.getMethodInstance("getEntityData", new Type[0]);
            setLocation = entityClass.getMethodInstance("absMoveTo", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            entityBlockPosition = entityClass.getFieldInstance("blockPosition");
            setUUID = entityClass.getMethodInstance("setUUID", new Type[]{UUID.class});
            setID = entityClass.getMethodInstance("setId", Integer.TYPE);
            ReflectionAccessor.ClassAccessor scoreboardClass = Packets.getNMSClass(reflection, "world.scores", "Scoreboard");
            ReflectionAccessor.ClassAccessor teamClass = Packets.getNMSClass(reflection, "world.scores", "PlayerTeam");
            ReflectionAccessor.ClassAccessor pushClass = Packets.getNMSClass(reflection, "world.scores", "Team$CollisionRule");
            packetTeam = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundSetPlayerTeamPacket");
            createTeamPacket = packetTeam.getMethodInstance("createAddOrModifyPacket", teamClass, Boolean.TYPE);
            createTeam = teamClass.getConstructorInstance(new Type[]{scoreboardClass, String.class});
            createScoreboard = scoreboardClass.getConstructorInstance(new Type[0]);
            setTeamPush = teamClass.getMethodInstance("setCollisionRule", pushClass);
            pushNever = pushClass.getField("NEVER").get(null);
            getTeamPlayers = teamClass.getMethodInstance("getPlayers", new Type[0]);
            if (cpack != null) {
                getPlayerHandle = Class.forName(cpack + "entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
                nmsWorld = Class.forName(cpack + "CraftWorld").getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
            }
        }

        public static void sendPackets(Player p, Object ... packets) throws ReflectiveOperationException {
            Object connection = playerConnection.get(getPlayerHandle.invoke((Object)p, new Object[0]));
            for (Object packet : packets) {
                if (packet == null) continue;
                sendPacket.invoke(connection, packet);
            }
        }

        public static Object createSquid(Location location, UUID uuid, int id) throws ReflectiveOperationException {
            Object entity = squidConstructor.newInstance(squidType, nmsWorld);
            Packets.setEntityIDs(entity, uuid, id);
            Packets.moveFakeEntity(entity, location);
            Object data = Packets.getEntityData(entity);
            Packets.setEntityData(data, dataAccessorFlags, (byte)32);
            return entity;
        }

        public static Object createGuardian(Location location, UUID uuid, int id) throws ReflectiveOperationException {
            Object entity = guardianConstructor.newInstance(guardianType, nmsWorld);
            Packets.setEntityIDs(entity, uuid, id);
            Packets.moveFakeEntity(entity, location);
            return entity;
        }

        public static Object createCrystal(Location location, UUID uuid, int id) throws ReflectiveOperationException {
            Object entity = crystalConstructor.newInstance(nmsWorld, location.getX(), location.getY(), location.getZ());
            Packets.setEntityIDs(entity, uuid, id);
            return entity;
        }

        public static Object getEntityData(Object entity) throws ReflectiveOperationException {
            return getData.invoke(entity, new Object[0]);
        }

        public static Object createPacketEntitySpawnLiving(Object entity) throws ReflectiveOperationException {
            if (packetSpawnLiving == null) {
                return Packets.createPacketEntitySpawnNormal(entity);
            }
            return packetSpawnLiving.newInstance(entity);
        }

        public static Object createPacketEntitySpawnNormal(Object entity) throws ReflectiveOperationException {
            if (version.isAfter(1, 21, 0)) {
                Object entityPos = entityBlockPosition.get(entity);
                return packetSpawnNormal.newInstance(entity, 0, entityPos);
            }
            return packetSpawnNormal.newInstance(entity);
        }

        public static void setGuardianTarget(Object watcher, int targetId) throws ReflectiveOperationException {
            Packets.setEntityData(watcher, dataAccessorGuardianTarget, targetId);
            Packets.setEntityData(watcher, dataAccessorFlags, (byte)32);
            Packets.setEntityData(watcher, dataAccessorGuardianMoving, Boolean.FALSE);
        }

        public static void setCrystalTarget(Object watcher, Location target) throws ReflectiveOperationException {
            Object blockPosition = blockPositionConstructor.newInstance(target.getBlockX(), target.getBlockY(), target.getBlockZ());
            Packets.setEntityData(watcher, dataAccessorCrystalTarget, Optional.of(blockPosition));
            Packets.setEntityData(watcher, dataAccessorCrystalBottom, Boolean.FALSE);
        }

        public static Object[] createPacketsRemoveEntities(int ... entitiesId) throws ReflectiveOperationException {
            Object[] packets;
            if (version.is(1, 17, 0)) {
                packets = new Object[entitiesId.length];
                for (int i = 0; i < entitiesId.length; ++i) {
                    packets[i] = packetRemove.newInstance(entitiesId[i]);
                }
            } else {
                packets = new Object[]{packetRemove.newInstance(new Object[]{entitiesId})};
            }
            return packets;
        }

        public static void setEntityIDs(Object entity, UUID uuid, int id) throws ReflectiveOperationException {
            setUUID.invoke(entity, uuid);
            setID.invoke(entity, id);
        }

        public static void moveFakeEntity(Object entity, Location location) throws ReflectiveOperationException {
            setLocation.invoke(entity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        }

        public static Object createPacketMoveEntity(Object entity) throws ReflectiveOperationException {
            if (version.isBefore(1, 21, 2)) {
                return packetTeleport.newInstance(entity);
            }
            return packetTeleportOf.invoke(null, entity);
        }

        public static Object createPacketTeamCreate(String teamName, UUID ... entities) throws ReflectiveOperationException {
            Object team = createTeam.newInstance(createScoreboard.newInstance(new Object[0]), teamName);
            setTeamPush.invoke(team, pushNever);
            Collection players = (Collection)getTeamPlayers.invoke(team, new Object[0]);
            for (UUID entity : entities) {
                players.add(entity.toString());
            }
            return createTeamPacket.invoke(null, team, true);
        }

        private static Object createPacketMetadata(int entityId, Object watcher) throws ReflectiveOperationException {
            if (version.isBefore(1, 19, 3)) {
                return packetMetadata.newInstance(entityId, watcher, false);
            }
            return packetMetadata.newInstance(entityId, watcherPack.invoke(watcher, new Object[0]));
        }

        private static void setEntityData(Object watcher, Object watcherObject, Object watcherData) throws ReflectiveOperationException {
            if (version.isAfter(1, 19, 3)) {
                watcherSet.invoke(watcher, watcherObject, watcherData, true);
            } else {
                watcherSet.invoke(watcher, watcherObject, watcherData);
                watcherDirty.invoke(watcher, watcherObject);
            }
        }

        @NotNull
        private static ReflectionAccessor.ClassAccessor getNMSClass(@NotNull ReflectionAccessor reflection, @NotNull String className) throws ClassNotFoundException {
            return reflection.getClass("net.minecraft." + className);
        }

        @NotNull
        private static ReflectionAccessor.ClassAccessor getNMSClass(@NotNull ReflectionAccessor reflection, @NotNull String nmPackage, @NotNull String className) throws ClassNotFoundException {
            return reflection.getClass("net.minecraft." + nmPackage + "." + className);
        }

        static {
            isEnabled = false;
            hasInitialized = false;
            initializationError = null;
        }
    }

    @FunctionalInterface
    public static interface ReflectiveConsumer<T> {
        public void accept(T var1) throws ReflectiveOperationException;
    }

    public static enum LaserType {
        GUARDIAN,
        ENDER_CRYSTAL;


        public Laser create(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            switch (this) {
                case ENDER_CRYSTAL: {
                    return new CrystalLaser(start, end, duration, distance);
                }
                case GUARDIAN: {
                    return new GuardianLaser(start, end, duration, distance);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class CrystalLaser
    extends Laser {
        private Object createCrystalPacket;
        private Object metadataPacketCrystal;
        private Object[] destroyPackets;
        private final Object crystal;
        private final int crystalID = Packets.generateEID();
        private final Object crystalWatcher;

        public CrystalLaser(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            super(start, new Location(end.getWorld(), (double)end.getBlockX(), (double)end.getBlockY(), (double)end.getBlockZ()), duration, distance);
            this.crystal = Packets.createCrystal(start, UUID.randomUUID(), this.crystalID);
            this.crystalWatcher = Packets.getEntityData(this.crystal);
            Packets.setCrystalTarget(this.crystalWatcher, end);
            this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.crystalWatcher);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.crystalID);
        }

        private Object getCrystalSpawnPacket() throws ReflectiveOperationException {
            if (this.createCrystalPacket == null) {
                this.createCrystalPacket = Packets.createPacketEntitySpawnNormal(this.crystal);
            }
            return this.createCrystalPacket;
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.ENDER_CRYSTAL;
        }

        @Override
        protected void sendStartPackets(Player p, boolean hasSeen) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.getCrystalSpawnPacket());
            Packets.sendPackets(p, this.metadataPacketCrystal);
        }

        @Override
        protected void sendDestroyPackets(Player p) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) throws ReflectiveOperationException {
            this.start = location.clone();
            this.createCrystalPacket = null;
            this.moveFakeEntity(this.start, this.crystal);
        }

        @Override
        public void moveEnd(Location location) throws ReflectiveOperationException {
            if (this.end.equals((Object)(location = new Location(location.getWorld(), (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ())))) {
                return;
            }
            this.end = location;
            if (this.main != null) {
                Packets.setCrystalTarget(this.crystalWatcher, location);
                this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.crystalWatcher);
                for (Player p : this.show) {
                    Packets.sendPackets(p, this.metadataPacketCrystal);
                }
            }
        }
    }

    public static class GuardianLaser
    extends Laser {
        private static AtomicInteger teamID = new AtomicInteger(ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE));
        private final UUID squidUUID = UUID.randomUUID();
        private final int squidID = Packets.generateEID();
        private Object squid;
        private Object squidData;
        private Object createSquidPacket;
        private Object metadataPacketSquid;
        private final UUID guardianUUID = UUID.randomUUID();
        private final int guardianID = Packets.generateEID();
        private Object guardian;
        private Object guardianData;
        private Object createGuardianPacket;
        private Object metadataPacketGuardian;
        private int targetID;
        private UUID targetUUID;
        private Object teamCreatePacket;
        private Object[] destroyPackets;
        protected LivingEntity endEntity;
        private Location correctStart;
        private Location correctEnd;

        public GuardianLaser(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            super(start, end, duration, distance);
            this.initSquid();
            this.initLaser();
            this.setTargetEntity(this.squidUUID, this.squidID);
        }

        public GuardianLaser(Location start, LivingEntity endEntity, int duration, int distance) throws ReflectiveOperationException {
            super(start, endEntity.getLocation(), duration, distance);
            this.initLaser();
            this.setTargetEntity(endEntity.getUniqueId(), endEntity.getEntityId());
        }

        private void initLaser() throws ReflectiveOperationException {
            this.guardian = Packets.createGuardian(this.getCorrectStart(), this.guardianUUID, this.guardianID);
            this.guardianData = Packets.getEntityData(this.guardian);
            this.teamCreatePacket = Packets.createPacketTeamCreate("noclip" + teamID.getAndIncrement(), this.squidUUID, this.guardianUUID);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.squidID, this.guardianID);
        }

        private void initSquid() throws ReflectiveOperationException {
            this.squid = Packets.createSquid(this.getCorrectEnd(), this.squidUUID, this.squidID);
            this.squidData = Packets.getEntityData(this.squid);
            this.metadataPacketSquid = Packets.createPacketMetadata(this.squidID, this.squidData);
        }

        private Object getGuardianSpawnPacket() throws ReflectiveOperationException {
            if (this.createGuardianPacket == null) {
                this.createGuardianPacket = Packets.createPacketEntitySpawnLiving(this.guardian);
            }
            return this.createGuardianPacket;
        }

        private Object getSquidSpawnPacket() throws ReflectiveOperationException {
            if (this.createSquidPacket == null) {
                this.createSquidPacket = Packets.createPacketEntitySpawnLiving(this.squid);
            }
            return this.createSquidPacket;
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.GUARDIAN;
        }

        public void attachEndEntity(LivingEntity entity) throws ReflectiveOperationException {
            if (entity.getWorld() != this.start.getWorld()) {
                throw new IllegalArgumentException("Attached entity is not in the same world as the laser.");
            }
            this.endEntity = entity;
            this.setTargetEntity(entity.getUniqueId(), entity.getEntityId());
        }

        public Entity getEndEntity() {
            return this.endEntity;
        }

        private void setTargetEntity(UUID uuid, int id) throws ReflectiveOperationException {
            this.targetUUID = uuid;
            this.targetID = id;
            Packets.setGuardianTarget(this.guardianData, this.targetID);
            this.metadataPacketGuardian = Packets.createPacketMetadata(this.guardianID, this.guardianData);
            for (Player p : this.show) {
                Packets.sendPackets(p, this.metadataPacketGuardian);
            }
        }

        @Override
        public Location getEnd() {
            return this.endEntity == null ? this.end : this.endEntity.getLocation();
        }

        protected Location getCorrectStart() {
            if (this.correctStart == null) {
                this.correctStart = this.start.clone();
                this.correctStart.subtract(0.0, 0.5, 0.0);
            }
            return this.correctStart;
        }

        protected Location getCorrectEnd() {
            if (this.correctEnd == null) {
                this.correctEnd = this.end.clone();
                this.correctEnd.subtract(0.0, 0.5, 0.0);
                Vector corrective = this.correctEnd.toVector().subtract(this.getCorrectStart().toVector()).normalize();
                if (Double.isNaN(corrective.getX())) {
                    corrective.setX(0);
                }
                if (Double.isNaN(corrective.getY())) {
                    corrective.setY(0);
                }
                if (Double.isNaN(corrective.getZ())) {
                    corrective.setZ(0);
                }
                this.correctEnd.subtract(corrective);
            }
            return this.correctEnd;
        }

        @Override
        protected boolean isCloseEnough(Player player) {
            return player == this.endEntity || super.isCloseEnough(player);
        }

        @Override
        protected void sendStartPackets(Player p, boolean hasSeen) throws ReflectiveOperationException {
            if (this.squid == null) {
                Packets.sendPackets(p, this.getGuardianSpawnPacket(), this.metadataPacketGuardian);
            } else {
                Packets.sendPackets(p, this.getGuardianSpawnPacket(), this.getSquidSpawnPacket(), this.metadataPacketGuardian, this.metadataPacketSquid);
            }
            if (!hasSeen) {
                Packets.sendPackets(p, this.teamCreatePacket);
            }
        }

        @Override
        protected void sendDestroyPackets(Player p) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) throws ReflectiveOperationException {
            this.start = location.clone();
            this.correctStart = null;
            this.createGuardianPacket = null;
            this.moveFakeEntity(this.getCorrectStart(), this.guardian);
            if (this.squid != null) {
                this.correctEnd = null;
                this.createSquidPacket = null;
                this.moveFakeEntity(this.getCorrectEnd(), this.squid);
            }
        }

        @Override
        public void moveEnd(Location location) throws ReflectiveOperationException {
            this.end = location.clone();
            this.createSquidPacket = null;
            this.correctEnd = null;
            if (this.squid == null) {
                this.initSquid();
                for (Player p : this.show) {
                    Packets.sendPackets(p, this.getSquidSpawnPacket(), this.metadataPacketSquid);
                }
            } else {
                this.moveFakeEntity(this.getCorrectEnd(), this.squid);
            }
            if (this.targetUUID != this.squidUUID) {
                this.endEntity = null;
                this.setTargetEntity(this.squidUUID, this.squidID);
            }
        }

        public void callColorChange() throws ReflectiveOperationException {
            for (Player p : this.show) {
                Packets.sendPackets(p, this.metadataPacketGuardian);
            }
        }
    }
}

