/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ReflectionAccessor {
    @NotNull
    public ClassAccessor getClass(@NotNull String var1) throws ClassNotFoundException;

    default public Class<?> getClassInstance(@NotNull String name) throws ClassNotFoundException {
        return this.getClass(name).getClassInstance();
    }

    public static boolean areSameParameters(@NotNull @NotNull Type @NotNull [] types1, @NotNull @NotNull Type @NotNull [] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            if (types1[i].getTypeName().equals(types2[i].getTypeName())) continue;
            return false;
        }
        return true;
    }

    public static interface ClassAccessor
    extends Type {
        @Override
        @NotNull
        public String getTypeName();

        @NotNull
        public Type getArrayType();

        @NotNull
        public Class<?> getClassInstance() throws ClassNotFoundException;

        @NotNull
        public FieldAccessor getField(@NotNull String var1) throws NoSuchFieldException;

        @NotNull
        default public Field getFieldInstance(@NotNull String original) throws NoSuchFieldException, SecurityException, ClassNotFoundException {
            return this.getField(original).getFieldInstance();
        }

        @NotNull
        public MethodAccessor getMethod(@NotNull String var1, Type ... var2) throws NoSuchMethodException, ClassNotFoundException;

        @NotNull
        default public Method getMethodInstance(@NotNull String original, Type ... parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
            return this.getMethod(original, parameterTypes).getMethodInstance();
        }

        @NotNull
        public ConstructorAccessor getConstructor(Type ... var1) throws NoSuchMethodException, SecurityException, ClassNotFoundException;

        @NotNull
        default public Constructor<?> getConstructorInstance(Type ... parameterTypes) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
            return this.getConstructor(parameterTypes).getConstructorInstance();
        }

        public static interface FieldAccessor {
            public Field getFieldInstance() throws NoSuchFieldException, SecurityException, ClassNotFoundException;

            public Object get(@Nullable Object var1) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException;

            public void set(@Nullable Object var1, Object var2) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException;
        }

        public static interface MethodAccessor {
            public Method getMethodInstance() throws NoSuchMethodException, SecurityException, ClassNotFoundException;

            public Object invoke(@Nullable Object var1, Object ... var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException;
        }

        public static interface ConstructorAccessor {
            public Constructor<?> getConstructorInstance();

            public Object newInstance(Object ... var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;
        }
    }
}

