/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files;

import io.lumine.mythic.bukkit.utils.particles.reflection.Version;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.Mappings;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files.MappingType;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingFileReader {
    public static final String VERSIONS_NOTICE = "# reflection-remapper | AVAILABLE VERSIONS";
    private static final Pattern VERSION_PATTERN = Pattern.compile("# reflection-remapper \\| (?<major>\\d+)\\.(?<minor>\\d+)\\.(?<patch>\\d+) (?<firstline>\\d+)-(?<lastline>\\d+)");
    @NotNull
    private final MappingType mappingType;
    @NotNull
    private final List<String> lines;
    @Nullable
    private List<VersionPart> mappings;

    public MappingFileReader(@NotNull MappingType mappingType, @NotNull List<String> lines) throws IOException {
        this.mappingType = mappingType;
        this.lines = lines;
    }

    public MappingFileReader(@NotNull MappingType mappingType, @NotNull List<String> lines, @NotNull Version version) throws IOException {
        this(mappingType, lines);
        this.mappings = List.of(new VersionPart(version, -1, -1));
    }

    @NotNull
    public List<Version> readAvailableVersions() {
        if (this.mappings != null) {
            throw new IllegalStateException("Versions are already known");
        }
        for (String line : this.lines) {
            Matcher versionMatcher;
            if (line.equals(VERSIONS_NOTICE)) {
                if (this.mappings == null) {
                    this.mappings = new ArrayList<VersionPart>();
                    continue;
                }
                return this.getAvailableVersions();
            }
            if (this.mappings == null || !(versionMatcher = VERSION_PATTERN.matcher(line)).matches()) continue;
            this.mappings.add(new VersionPart(new Version(Integer.parseInt(versionMatcher.group("major")), Integer.parseInt(versionMatcher.group("minor")), Integer.parseInt(versionMatcher.group("patch"))), Integer.parseInt(versionMatcher.group("firstline")), Integer.parseInt(versionMatcher.group("lastline"))));
        }
        if (this.mappings == null) {
            throw new IllegalArgumentException("File does not contain version information");
        }
        throw new IllegalArgumentException("Invalid syntax: no end to the version informations");
    }

    @NotNull
    public List<Version> getAvailableVersions() {
        if (this.mappings == null) {
            throw new IllegalStateException("No versions are available for now");
        }
        return this.mappings.stream().map(x -> x.version).sorted().toList();
    }

    public boolean keepOnlyVersion(@NotNull Version version) {
        for (VersionPart mapping : this.mappings) {
            if (!version.equals(mapping.version)) continue;
            this.mappings = List.of(mapping);
            return true;
        }
        return false;
    }

    @NotNull
    public Optional<Version> keepBestMatchedVersion(@NotNull Version targetVersion) {
        Optional<Version> foundVersion = MappingFileReader.getBestMatchedVersion(targetVersion, this.getAvailableVersions());
        if (foundVersion.isPresent()) {
            this.keepOnlyVersion(foundVersion.get());
        }
        return foundVersion;
    }

    public void parseMappings() {
        for (VersionPart version : this.mappings) {
            List<String> linesToParse = version.firstLine == -1 && version.lastLine == -1 ? this.lines : this.lines.subList(version.firstLine, version.lastLine + 1);
            version.mappings = this.mappingType.parse(linesToParse);
        }
    }

    @NotNull
    public Mappings getParsedMappings(@NotNull Version version) {
        return this.mappings.stream().filter((Predicate<VersionPart>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getParsedMappings$1(io.lumine.mythic.bukkit.utils.particles.reflection.Version io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files.MappingFileReader$VersionPart ), (Lio/lumine/mythic/bukkit/utils/particles/reflection/mappings/files/MappingFileReader$VersionPart;)Z)((Version)version)).findAny().orElseThrow().mappings;
    }

    @NotNull
    public static Optional<Version> getBestMatchedVersion(@NotNull Version targetVersion, @NotNull @NotNull List<@NotNull Version> availableVersions) {
        Version lastVersion = null;
        for (Version version : availableVersions) {
            if (version.is(targetVersion)) {
                return Optional.of(version);
            }
            if (version.isBefore(targetVersion)) {
                lastVersion = version;
            }
            if (!version.isAfter(targetVersion)) continue;
            break;
        }
        return Optional.ofNullable(lastVersion);
    }

    private static /* synthetic */ boolean lambda$getParsedMappings$1(Version version, VersionPart x) {
        return x.version.equals(version);
    }

    private class VersionPart {
        private final Version version;
        private final int firstLine;
        private final int lastLine;
        private Mappings mappings;

        private VersionPart(Version version, int firstLine, int lastLine) {
            this.version = version;
            this.firstLine = firstLine;
            this.lastLine = lastLine;
        }
    }
}

