/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.redis.jedis;

import io.lumine.mythic.bukkit.utils.redis.jedis.Jedis;
import io.lumine.mythic.bukkit.utils.redis.jedis.JedisClusterConnectionHandler;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisAskDataException;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisClusterMaxAttemptsException;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisClusterOperationException;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisConnectionException;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisException;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisMovedDataException;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisNoReachableClusterNodeException;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisRedirectionException;
import io.lumine.mythic.bukkit.utils.redis.jedis.util.JedisClusterCRC16;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JedisClusterCommand<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JedisClusterCommand.class);
    private final JedisClusterConnectionHandler connectionHandler;
    private final int maxAttempts;
    private final Duration maxTotalRetriesDuration;

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int maxAttempts) {
        this(connectionHandler, maxAttempts, Duration.ofMillis(2000L * (long)maxAttempts));
    }

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int maxAttempts, Duration maxTotalRetriesDuration) {
        this.connectionHandler = connectionHandler;
        this.maxAttempts = maxAttempts;
        this.maxTotalRetriesDuration = maxTotalRetriesDuration;
    }

    public abstract T execute(Jedis var1);

    public T run(String key) {
        return this.runWithRetries(JedisClusterCRC16.getSlot(key));
    }

    public T run(int keyCount, String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster.");
        }
        int slot = JedisClusterCRC16.getSlot(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keyCount; ++i) {
                int nextSlot = JedisClusterCRC16.getSlot(keys[i]);
                if (slot == nextSlot) continue;
                throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster because keys have different slots.");
            }
        }
        return this.runWithRetries(slot);
    }

    public T runBinary(byte[] key) {
        return this.runWithRetries(JedisClusterCRC16.getSlot(key));
    }

    public T runBinary(int keyCount, byte[] ... keys) {
        if (keys == null || keys.length == 0) {
            throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster.");
        }
        int slot = JedisClusterCRC16.getSlot(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keyCount; ++i) {
                int nextSlot = JedisClusterCRC16.getSlot(keys[i]);
                if (slot == nextSlot) continue;
                throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster because keys have different slots.");
            }
        }
        return this.runWithRetries(slot);
    }

    public T runWithAnyNode() {
        Jedis connection = null;
        try {
            connection = this.connectionHandler.getConnection();
            T t2 = this.execute(connection);
            return t2;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T runWithRetries(int slot) {
        Instant deadline = Instant.now().plus(this.maxTotalRetriesDuration);
        JedisRedirectionException redirect = null;
        int consecutiveConnectionFailures = 0;
        JedisException lastException = null;
        int attemptsLeft = this.maxAttempts;
        while (true) {
            T t2;
            if (attemptsLeft <= 0) {
                JedisClusterMaxAttemptsException maxAttemptsException = new JedisClusterMaxAttemptsException("No more cluster attempts left.");
                maxAttemptsException.addSuppressed(lastException);
                throw maxAttemptsException;
            }
            Jedis connection = null;
            try {
                if (redirect != null) {
                    connection = this.connectionHandler.getConnectionFromNode(redirect.getTargetNode());
                    if (redirect instanceof JedisAskDataException) {
                        connection.asking();
                    }
                } else {
                    connection = this.connectionHandler.getConnectionFromSlot(slot);
                }
                t2 = this.execute(connection);
            }
            catch (JedisNoReachableClusterNodeException jnrcne) {
                throw jnrcne;
                catch (JedisConnectionException jce) {
                    lastException = jce;
                    LOG.debug("Failed connecting to Redis: {}", (Object)connection, (Object)jce);
                    boolean reset = this.handleConnectionProblem(attemptsLeft - 1, ++consecutiveConnectionFailures, deadline);
                    if (reset) {
                        consecutiveConnectionFailures = 0;
                        redirect = null;
                    }
                    this.releaseConnection(connection);
                }
                catch (JedisRedirectionException jre) {
                    try {
                        if (lastException == null || lastException instanceof JedisRedirectionException) {
                            lastException = jre;
                        }
                        LOG.debug("Redirected by server to {}", (Object)jre.getTargetNode());
                        consecutiveConnectionFailures = 0;
                        redirect = jre;
                        if (jre instanceof JedisMovedDataException) {
                            this.connectionHandler.renewSlotCache(connection);
                        }
                        this.releaseConnection(connection);
                    }
                    catch (Throwable throwable) {
                        this.releaseConnection(connection);
                        throw throwable;
                    }
                }
            }
            this.releaseConnection(connection);
            return t2;
            if (Instant.now().isAfter(deadline)) {
                throw new JedisClusterOperationException("Cluster retry deadline exceeded.");
            }
            --attemptsLeft;
        }
    }

    private boolean handleConnectionProblem(int attemptsLeft, int consecutiveConnectionFailures, Instant doneDeadline) {
        if (this.maxAttempts < 3) {
            if (attemptsLeft == 0) {
                this.connectionHandler.renewSlotCache();
                return true;
            }
            return false;
        }
        if (consecutiveConnectionFailures < 2) {
            return false;
        }
        this.sleep(JedisClusterCommand.getBackoffSleepMillis(attemptsLeft, doneDeadline));
        this.connectionHandler.renewSlotCache();
        return true;
    }

    private static long getBackoffSleepMillis(int attemptsLeft, Instant deadline) {
        if (attemptsLeft <= 0) {
            return 0L;
        }
        long millisLeft = Duration.between(Instant.now(), deadline).toMillis();
        if (millisLeft < 0L) {
            throw new JedisClusterOperationException("Cluster retry deadline exceeded.");
        }
        return millisLeft / (long)(attemptsLeft * (attemptsLeft + 1));
    }

    protected void sleep(long sleepMillis) {
        try {
            TimeUnit.MILLISECONDS.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            throw new JedisClusterOperationException(e);
        }
    }

    private void releaseConnection(Jedis connection) {
        if (connection != null) {
            connection.close();
        }
    }
}

