/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import java.util.Base64;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class Base64Util {
    public static String encode(byte[] buf) {
        return Base64.getEncoder().encodeToString(buf);
    }

    public static byte[] decode(String src) {
        src = Base64Util.fixBase64Padding(src);
        try {
            return Base64.getDecoder().decode(src);
        }
        catch (IllegalArgumentException e) {
            try {
                return Base64Coder.decodeLines((String)src);
            }
            catch (Exception ignored) {
                throw e;
            }
        }
    }

    public static String decodeString(String src) {
        src = Base64Util.fixBase64Padding(src);
        return new String(Base64.getDecoder().decode(src));
    }

    private static String fixBase64Padding(String b64) {
        int missing = b64.length() % 4;
        if (missing == 2) {
            return b64 + "==";
        }
        if (missing == 3) {
            return b64 + "=";
        }
        if (missing == 1) {
            throw new IllegalArgumentException("Invalid Base64: length mod 4 = 1");
        }
        return b64;
    }

    private Base64Util() {
    }
}

