/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.lumine.mythic.bukkit.utils.gson.GsonSerializable;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import javax.annotation.Nonnull;

public class Percent
implements GsonSerializable {
    private double value;

    public static Percent of(String input) {
        return new Percent(input);
    }

    public static Percent of(double decimalValue) {
        return new Percent(String.valueOf(decimalValue));
    }

    public Percent(String input) {
        this.parse(input);
    }

    private void parse(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Input cannot be null or empty");
        }
        input = input.trim();
        try {
            double decimalValue;
            this.value = input.endsWith("%") ? Double.parseDouble(input.substring(0, input.length() - 1).trim()) / 100.0 : (decimalValue = Double.parseDouble(input));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid percentage format: " + input, e);
        }
    }

    public double asDecimal() {
        return this.value;
    }

    public String asPercentString() {
        return String.format("%.2f%%", this.value * 100.0);
    }

    public boolean rollChance() {
        return Numbers.randomDouble() < this.value;
    }

    @Override
    @Nonnull
    public JsonElement serialize() {
        return new JsonPrimitive((Number)this.value);
    }

    public static Percent deserialize(@Nonnull JsonElement element) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalArgumentException("Invalid JSON for Percent: must be a number.");
        }
        double decimalValue = element.getAsDouble();
        return new Percent(String.valueOf(decimalValue));
    }

    public String toString() {
        return this.asPercentString();
    }
}

