/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.mythic.bukkit.utils.gson.GsonSerializable;
import io.lumine.mythic.bukkit.utils.gson.JsonBuilder;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.serialize.Locus;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;

public class Sound
implements GsonSerializable {
    private final String sound;
    private final float volume;
    private final float pitch;
    private final Category category;

    public static Sound deserialize(String element) {
        Preconditions.checkNotNull((Object)element);
        return new Sound(element);
    }

    public static Sound deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("sound"));
        Preconditions.checkArgument((boolean)object.has("volume"));
        Preconditions.checkArgument((boolean)object.has("pitch"));
        Preconditions.checkArgument((boolean)object.has("category"));
        String sound = object.get("sound").getAsString();
        float volume = object.get("volume").getAsFloat();
        float pitch = object.get("pitch").getAsFloat();
        String source = object.get("category").getAsString();
        return Sound.of(sound, volume, pitch);
    }

    public static Sound of(String input) {
        return new Sound(input);
    }

    public static Sound of(String sound, float volume, float pitch) {
        return new Sound(sound, volume, pitch, Category.MASTER);
    }

    public static Sound of(String sound, float volume, float pitch, Category category) {
        return new Sound(sound, volume, pitch, category);
    }

    private Sound(String sound, float volume, float pitch, Category category) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.category = category;
    }

    private Sound(String input) {
        if (input == null || input.isEmpty()) {
            input = "block.note_block.didgeridoo";
            Log.error("Sound cannot be null or blank");
        }
        String[] parts = input.split(" ");
        this.sound = parts[0];
        this.volume = parts.length > 1 ? Float.parseFloat(parts[1]) : 1.0f;
        this.pitch = parts.length > 2 ? Float.parseFloat(parts[2]) : 1.0f;
        this.category = parts.length > 3 ? Category.get(parts[2]) : Category.MASTER;
    }

    public void play(Player player) {
        Sound.play(player, this.sound, this.category.getSoundCategory(), this.volume, this.pitch);
    }

    public void play(Player player, Location location) {
        Sound.play(player, location, this.sound, this.category.getSoundCategory(), this.volume, this.pitch);
    }

    public void play(Player player, Position location) {
        Sound.play(player, location.toLocation(), this.sound, this.category.getSoundCategory(), this.volume, this.pitch);
    }

    public void play(Player player, Locus location) {
        Sound.play(player, location.toLocation(player.getWorld()), this.sound, this.category.getSoundCategory(), this.volume, this.pitch);
    }

    public void play(Location location) {
        Sound.play(location, this.sound, this.category, this.volume, this.pitch);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("sound", this.sound).add("v", Float.valueOf(this.volume)).add("p", Float.valueOf(this.pitch)).add("category", this.category.toString()).build();
    }

    public String serializeShortForm() {
        return this.sound + " " + this.volume + " " + this.pitch + " " + this.category.toString();
    }

    public static void play(Player player, String sound) {
        Sound.play(player, sound, Category.MASTER, 1.0f, 1.0f);
    }

    public static void play(Player player, String sound, float volume, float pitch) {
        Sound.play(player, sound, Category.MASTER, volume, pitch);
    }

    public static void play(Player player, String sound, Category category, float volume, float pitch) {
        player.playSound(player.getLocation(), sound, category.getSoundCategory(), volume, pitch);
    }

    public static void play(Player player, String sound, SoundCategory category, float volume, float pitch) {
        player.playSound(player.getLocation(), sound, category, volume, pitch);
    }

    public static void play(Player player, Location location, String sound) {
        Sound.play(player, location, sound, Category.MASTER, 1.0f, 1.0f);
    }

    public static void play(Player player, Location location, String sound, float volume, float pitch) {
        Sound.play(player, location, sound, Category.MASTER, volume, pitch);
    }

    public static void play(Player player, Location location, String sound, Category category, float volume, float pitch) {
        player.playSound(location, sound, category.getSoundCategory(), volume, pitch);
    }

    public static void play(Player player, Location location, String sound, SoundCategory category, float volume, float pitch) {
        player.playSound(location, sound, category, volume, pitch);
    }

    public static void play(Location location, String sound) {
        Sound.play(location, sound, 1.0f, 1.0f);
    }

    public static void play(Location location, String sound, float volume, float pitch) {
        for (Player player : location.getWorld().getPlayers()) {
            player.playSound(location, sound, volume, pitch);
        }
    }

    public static void play(Location location, String sound, Category category, float volume, float pitch) {
        for (Player player : location.getWorld().getPlayers()) {
            player.playSound(location, sound, category.getSoundCategory(), volume, pitch);
        }
    }

    public static enum Category {
        MASTER("master", SoundCategory.MASTER),
        MUSIC("music", SoundCategory.MUSIC),
        RECORD("record", SoundCategory.RECORDS),
        WEATHER("weather", SoundCategory.WEATHER),
        BLOCK("block", SoundCategory.BLOCKS),
        HOSTILE("hostile", SoundCategory.HOSTILE),
        NEUTRAL("neutral", SoundCategory.NEUTRAL),
        PLAYER("player", SoundCategory.PLAYERS),
        AMBIENT("ambient", SoundCategory.AMBIENT),
        VOICE("voice", SoundCategory.VOICE);

        private final String name;
        private final SoundCategory soundCategory;

        private Category(String name, SoundCategory soundCategory) {
            this.name = name;
            this.soundCategory = soundCategory;
        }

        public static Category get(String name) {
            try {
                return Category.valueOf(name);
            }
            catch (Throwable ex) {
                return MASTER;
            }
        }

        public String getName() {
            return this.name;
        }

        public SoundCategory getSoundCategory() {
            return this.soundCategory;
        }
    }
}

