/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.ConfigManager;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.IPlaceholder;
import io.lumine.mythic.api.skills.placeholders.PlaceholderAngle;
import io.lumine.mythic.api.skills.placeholders.PlaceholderBoolean;
import io.lumine.mythic.api.skills.placeholders.PlaceholderColor;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderLong;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.placeholders.PlaceholderTime;
import io.lumine.mythic.api.skills.placeholders.PlaceholderVector;
import io.lumine.mythic.api.skills.stats.StatManager;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CrucibleSupport;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.ChromaProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.EnumProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.MaterialProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.Node2StringProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.files.Folders;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.bukkit.utils.numbers.AngleUnit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.tasks.LumineAsyncExecutor;
import io.lumine.mythic.bukkit.utils.tasks.LumineExecutors;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.DropMethod;
import io.lumine.mythic.core.config.LegacyConfigExecutor;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLang;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.WorldScaling;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderAngleImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderBooleanImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderColorImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderDoubleImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderFloatImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderIntImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderLongImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderStringImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderTimeImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderVectorImpl;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.spawning.random.GeneratorType;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;

public class ConfigExecutor
extends ReloadableModule<MythicBukkit>
implements ConfigManager,
PropertyHolder {
    private static final DoubleProp VERSION = Property.Double(Scope.CONFIG_GENERAL, "Version");
    private static final BooleanProp GENERAL_ALLOW_METRICS = Property.Boolean(Scope.CONFIG_GENERAL, "General.AllowMetrics", true);
    private static final BooleanProp GENERAL_CHECK_UPDATES = Property.Boolean(Scope.CONFIG_GENERAL, "General.CheckForUpdates", true);
    private static final BooleanProp GENERAL_COMPATIB_MODE = Property.Boolean(Scope.CONFIG_GENERAL, "General.CompatibilityMode", false);
    private static final BooleanProp GENERAL_ERROR_LOGGING = Property.Boolean(Scope.CONFIG_GENERAL, "General.ErrorLogging", true);
    private static final BooleanProp GENERAL_LOAD_EXAMPLES = Property.Boolean(Scope.CONFIG_GENERAL, "General.LoadExampleConfigs", true);
    private static final StringProp GENERAL_LANGUAGE = Property.String(Scope.CONFIG_GENERAL, "General.Language", "en-us");
    private static final IntProp DEBUG_LEVEL = Property.Int(Scope.CONFIG_GENERAL, "General.DebugLevel", 0);
    private static final IntProp THREAD_POOL = Property.Int(Scope.CONFIG_GENERAL, "General.ThreadPoolSize", -1);
    private static final BooleanProp USE_VIRTUAL_THREADS = Property.Boolean(Scope.CONFIG_GENERAL, "General.UseVirtualThreads", false);
    private static final BooleanProp DEBUG_MODE = Property.Boolean(Scope.CONFIG_GENERAL, "General.DebugMode", false);
    private static final BooleanProp DEBUG_SPAWNERS = Property.Boolean(Scope.CONFIG_GENERAL, "General.DebugSpawners", false);
    private static final BooleanProp ANNOUNCE_OP_RELOAD = Property.Boolean(Scope.CONFIG_GENERAL, "General.AnnounceOpReload", false);
    private static final IntProp CLOCK_SPEED = Property.Int(Scope.CONFIG_GENERAL, "Clock.Main", 1);
    private static final IntProp CLOCK_BARS = Property.Int(Scope.CONFIG_GENERAL, "Clock.Bars", 20);
    private static final IntProp CLOCK_SAVING = Property.Int(Scope.CONFIG_GENERAL, "Clock.Saving", 300);
    private static final IntProp CLOCK_SPAWNS = Property.Int(Scope.CONFIG_GENERAL, "Clock.Spawners", 2);
    private static final IntProp CLOCK_RANDOM_SPAWNING = Property.Int(Scope.CONFIG_GENERAL, "Clock.RandomSpawning", 1);
    private static final IntProp CLOCK_SCANNER = Property.Int(Scope.CONFIG_GENERAL, "Clock.Scanner", 10);
    private static final IntProp CLOCK_CLEANUP = Property.Int(Scope.CONFIG_GENERAL, "Clock.Cleanup", 600);
    private static final BooleanProp COMPAT_HEROES_XP_ENABLE = Property.Boolean(Scope.CONFIG_GENERAL, "Compatibility.Heroes.Enabled", false);
    private static final BooleanProp COMPAT_HEROES_SHOW_XP_MESSAGE = Property.Boolean(Scope.CONFIG_GENERAL, "Compatibility.Heroes.ShowXPMessage", false);
    private static final StringProp COMPAT_HEROES_XP_MESSAGE_FORMAT = Property.String(Scope.CONFIG_GENERAL, "Compatibility.Heroes.XPMessageFormat", "");
    private static final BooleanProp COMPAT_MCMMO_SHOW_XP_MESSAGE = Property.Boolean(Scope.CONFIG_GENERAL, "Compatibility.McMMO.ShowXPMessage", false);
    private static final StringProp COMPAT_MCMMO_XP_MESSAGE_FORMAT = Property.String(Scope.CONFIG_GENERAL, "Compatibility.McMMO.XPMessageFormat", "");
    private static final BooleanProp COMPAT_SKILLAPI_SHOW_XP_MESSAGE = Property.Boolean(Scope.CONFIG_GENERAL, "Compatibility.SkillAPI.ShowXPMessage", false);
    private static final StringProp COMPAT_SKILLAPI_XP_MESSAGE_FORMAT = Property.String(Scope.CONFIG_GENERAL, "Compatibility.SkillAPI.XPMessageFormat", "");
    private static final BooleanProp COMPAT_VAULT_SHOW_MONEY_MESSAGE = Property.Boolean(Scope.CONFIG_GENERAL, "Compatibility.Vault.ShowMoneyMessage", false);
    private static final StringProp COMPAT_VAULT_MONEY_MESSAGE_FORMAT = Property.String(Scope.CONFIG_GENERAL, "Compatibility.Vault.MoneyMessageFormat", "");
    private static final DoubleProp PACKET_MIN_POS_DELTA = Property.Double(Scope.CONFIG_GENERAL, "Packet.MinimumPositionDelta", 7.62939453125E-6);
    private static final BooleanProp CANCEL_DAMAGE_IF_0 = Property.Boolean(Scope.CONFIG_MOBS, "Mobs.CancelDamageIfZero", false);
    private static final StringProp MOBS_KILL_MESSAGE_PREFIX = Property.String(Scope.CONFIG_MOBS, "Mobs.KillMessagePrefix", null);
    private static final StringProp DROPS_DEFAULT_DROPMETHOD = Property.String(Scope.CONFIG_MOBS, "MobDrops.DefaultDropMethod", "VANILLA");
    private static final BooleanProp DROPS_DEFAULT_PERPLAYER = Property.Boolean(Scope.CONFIG_MOBS, "MobDrops.DoPerPlayerDropsByDefault", false);
    private static final BooleanProp DROPS_DEFAULT_LOOTSPLOSION = Property.Boolean(Scope.CONFIG_MOBS, "MobDrops.DoLootsplosionByDefault", false);
    private static final BooleanProp DROPS_DEFAULT_CLIENTSIDE = Property.Boolean(Scope.CONFIG_MOBS, "MobDrops.DoClientsideDropsByDefault", false);
    private static final BooleanProp DROPS_DEFAULT_NAME_HOLOGRAM = Property.Boolean(Scope.CONFIG_MOBS, "MobDrops.DoHologramNameByDefault", false);
    private static final BooleanProp DROPS_DEFAULT_ITEM_GLOW = Property.Boolean(Scope.CONFIG_MOBS, "MobDrops.DoItemGlowByDefault", false);
    private static final BooleanProp DROPS_DEFAULT_ITEM_BEAM = Property.Boolean(Scope.CONFIG_MOBS, "MobDrops.DoItemBeamByDefault", false);
    private static final BooleanProp DROPS_DEFAULT_ITEM_VFX = Property.Boolean(Scope.CONFIG_MOBS, "MobDrops.DoItemVFXByDefault", false);
    private static final MaterialProp DROPS_DEFAULT_ITEM_VFX_MATERIAL = Property.Material(Scope.CONFIG_MOBS, "MobDrops.DefaultItemVFX.Material", Material.POTION);
    private static final IntProp DROPS_DEFAULT_ITEM_VFX_MODEL = Property.Int(Scope.CONFIG_MOBS, "MobDrops.DefaultItemVFX.Model", 1);
    private static final StringProp DROPS_DEFAULT_ITEM_VFX_GENERATION = Property.String(Scope.CONFIG_MOBS, "MobDrops.DefaultItemVFX.Generation", null);
    private static final StringListProp DROPS_DEFAULT_DEATH_HOLOGRAM = Property.StringList(Scope.CONFIG_MOBS, "MobDrops.DefaultDeathHologram");
    private static final IntProp DROPS_DEFAULT_LEADERBOARD_TIMEOUT = Property.Int(Scope.CONFIG_MOBS, "MobDrops.DefaultLeaderboardTimeout", 6000);
    private static final StringListProp DROPS_DEFAULT_CHAT_MESSAGE = Property.StringList(Scope.CONFIG_MOBS, "MobDrops.DefaultDeathChatMessage");
    private static final StringProp DROPS_PER_PLAYER_PERCENT = Property.String(Scope.CONFIG_MOBS, "MobDrops.MinimumDamagePercentForDrops", "1%");
    private static final BooleanProp MOBS_DESPAWN_BY_DEFAULT = Property.Boolean(Scope.CONFIG_MOBS, "DefaultMobOptions.Despawn", true);
    private static final BooleanProp PREVENT_OTHER_DROPS_BY_DEFAULT = Property.Boolean(Scope.CONFIG_MOBS, "DefaultMobOptions.PreventOtherDrops", false);
    private static final BooleanProp PREVENT_VANILLA_DAMAGE_BY_DEFAULT = Property.Boolean(Scope.CONFIG_MOBS, "DefaultMobOptions.PreventVanillaDamage", false);
    private static final StringProp EGG_DEFAULT_ITEM_DISPLAY = Property.String(Scope.CONFIG_MOBS, "MobEggs.DefaultDisplay", "<mob.name> Spawn Egg");
    private static final MaterialProp EGG_DEFAULT_ITEM_MATERIAL = Property.Material(Scope.CONFIG_MOBS, "MobEggs.Material", Material.PIG_SPAWN_EGG);
    private static final StringProp EGG_DEFAULT_ITEM_MODEL = Property.String(Scope.CONFIG_MOBS, "MobEggs.Model", null);
    private static final StringListProp EGG_DEFAULT_ITEM_LORE = Property.StringList(Scope.CONFIG_MOBS, "MobEggs.DefaultLore", Lists.newArrayList((Object[])new String[]{"<dark_gray>A Mythical Egg that can</dark_gray>", "<dark_gray>be used to resurrect a</dark_gray>", "<dark_gray><mob.name></dark_gray>"}));
    private static final DoubleProp HOLOGRAM_GLOBAL_OFFSET = Property.Double(Scope.CONFIG_MOBS, "Holograms.GlobalOffset", 0.25);
    private static final ChromaProp HOLOGRAM_CASTBAR_INFO_BACKGROUND = Property.Chroma(Scope.CONFIG_MOBS, "Holograms.CastBar.InfoBackground", Chroma.of(0, 0, 0, 0));
    private static final StringProp HOLOGRAM_CASTBAR_INFO_BILLBOARDING = Property.String(Scope.CONFIG_MOBS, "Holograms.CastBar.InfoBillboarding", "VERTICAL");
    private static final DoubleProp HOLOGRAM_CASTBAR_INFO_OFFSET = Property.Double(Scope.CONFIG_MOBS, "Holograms.CastBar.InfoOffset", 1.0);
    private static final ChromaProp HOLOGRAM_CASTBAR_CAST_BACKGROUND = Property.Chroma(Scope.CONFIG_MOBS, "Holograms.CastBar.CastBackground", Chroma.of(0, 0, 0, 0));
    private static final StringProp HOLOGRAM_CASTBAR_CAST_BILLBOARDING = Property.String(Scope.CONFIG_MOBS, "Holograms.CastBar.CastBillboarding", "VERTICAL");
    private static final DoubleProp HOLOGRAM_CASTBAR_CAST_OFFSET = Property.Double(Scope.CONFIG_MOBS, "Holograms.CastBar.CastOffset", 1.0);
    private static final ChromaProp HOLOGRAM_HEALTHBAR_BACKGROUND = Property.Chroma(Scope.CONFIG_MOBS, "Holograms.HealthBar.Background", Chroma.of(0, 0, 0, 0));
    private static final StringProp HOLOGRAM_HEALTHBAR_BILLBOARDING = Property.String(Scope.CONFIG_MOBS, "Holograms.HealthBar.Billboarding", "VERTICAL");
    private static final DoubleProp HOLOGRAM_HEALTHBAR_OFFSET = Property.Double(Scope.CONFIG_MOBS, "Holograms.HealthBar.Offset", -0.05);
    private static final IntProp HOLOGRAM_HEALTHBAR_LENGTH = Property.Int(Scope.CONFIG_MOBS, "Holograms.HealthBar.Length", 50);
    private static final StringProp HOLOGRAM_HEALTHBAR_SCALE = Property.String(Scope.CONFIG_MOBS, "Holograms.HealthBar.Scale", "0.4,0.4,0.4");
    private static final ChromaProp HOLOGRAM_NAMEPLATE_BACKGROUND = Property.Chroma(Scope.CONFIG_MOBS, "Holograms.Nameplate.Background", Chroma.of(0, 0, 0, 60));
    private static final StringProp HOLOGRAM_NAMEPLATE_BILLBOARDING = Property.String(Scope.CONFIG_MOBS, "Holograms.Nameplate.Billboarding", "VERTICAL");
    private static final DoubleProp HOLOGRAM_NAMEPLATE_OFFSET = Property.Double(Scope.CONFIG_MOBS, "Holograms.Nameplate.Offset", 0.0);
    private static final StringProp HOLOGRAM_NAMEPLATE_SCALE = Property.String(Scope.CONFIG_MOBS, "Holograms.Nameplate.Scale", "1,1,1");
    private static final ChromaProp HOLOGRAM_SPEECH_BACKGROUND = Property.Chroma(Scope.CONFIG_MOBS, "Holograms.Speech.Background", Chroma.of(255, 255, 255, 100));
    private static final StringProp HOLOGRAM_SPEECH_BILLBOARDING = Property.String(Scope.CONFIG_MOBS, "Holograms.Speech.Billboarding", "VERTICAL");
    private static final DoubleProp HOLOGRAM_SPEECH_OFFSET = Property.Double(Scope.CONFIG_MOBS, "Holograms.Speech.Offset", 0.4);
    private static final StringProp HOLOGRAM_SPEECH_PREFIX = Property.String(Scope.CONFIG_MOBS, "Holograms.Speech.LinePrefix", "<white>");
    private static final StringProp SCALING_EQUATION_DAMAGE = Property.String(Scope.CONFIG_MOBS, "MobLeveling.ScalingEquations.Damage", null);
    private static final StringProp SCALING_EQUATION_HEALTH = Property.String(Scope.CONFIG_MOBS, "MobLeveling.ScalingEquations.Health", null);
    private static final StringProp SCALING_EQUATION_SCALE = Property.String(Scope.CONFIG_MOBS, "MobLeveling.ScalingEquations.Scale", null);
    private static final Node2StringProp SCALING_EQUATIONS = Property.Node2String(Scope.CONFIG_MOBS, "MobLeveling.ScalingEquations");
    private static final Node2StringProp DEFAULT_LEVEL_MODIFIERS = Property.Node2String(Scope.CONFIG_MOBS, "MobLeveling.DefaultLevelModifiers");
    private static final NodeListProp WORLD_SCALING_NODES = Property.NodeList(Scope.CONFIG_MOBS, "MobLeveling.WorldScaling");
    private static final BooleanProp UPDATE_ITEMS = Property.Boolean(Scope.CONFIG_ITEMS, "ItemUpdating.Enabled", true);
    private static final StringProp ITEM_DEFAULT_MATERIAL = Property.String(Scope.CONFIG_ITEMS, "DefaultItemOptions.Material", "STONE");
    private static final StringProp ITEM_DEFAULT_PREVENTENCHANTING = Property.String(Scope.CONFIG_ITEMS, "DefaultItemOptions.PreventEnchanting", "false");
    private static final StringProp ITEM_DEFAULT_PREVENTCRAFTING = Property.String(Scope.CONFIG_ITEMS, "DefaultItemOptions.PreventCrafting", "modeled");
    private static final StringProp ITEM_DEFAULT_PREVENTANVILING = Property.String(Scope.CONFIG_ITEMS, "DefaultItemOptions.PreventAnviling", "default");
    private static final StringProp ITEM_DEFAULT_PREVENTSMITHING = Property.String(Scope.CONFIG_ITEMS, "DefaultItemOptions.PreventSmithing", "default");
    private static final BooleanProp TARGET_SELF = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetSelf", false);
    private static final BooleanProp TARGET_PLAYERS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetPlayers", true);
    private static final BooleanProp TARGET_ARMOR_STANDS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetArmorStands", false);
    private static final BooleanProp TARGET_MARKERS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetMarkers", false);
    private static final BooleanProp TARGET_CREATIVE_MODE = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetCreativeMode", true);
    private static final BooleanProp TARGET_SPECTATOR_MODE = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetSpectatorMode", true);
    private static final BooleanProp TARGET_CITIZENS_NPCS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetCitizensNPCs", false);
    private static final BooleanProp TARGET_ANIMALS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetAnimals", true);
    private static final BooleanProp TARGET_CREATURES = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetCreatures", true);
    private static final BooleanProp TARGET_MONSTERS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetMonsters", true);
    private static final BooleanProp TARGET_WATER_MOBS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetWaterMobs", true);
    private static final BooleanProp TARGET_FLYING_MOBS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetFlyingMobs", true);
    private static final BooleanProp TARGET_SAME_FACTION = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetSameFaction", true);
    private static final BooleanProp TARGET_OWNER = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetOwner", true);
    private static final BooleanProp TARGET_NON_MYTHIC = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetNonMythic", true);
    private static final BooleanProp TARGET_VILLAGERS = Property.Boolean(Scope.CONFIG_SKILLS, "Targeters.DefaultEntityFilters.TargetVillagers", true);
    private static final BooleanProp SPAWNERS_DISABLE_SAVING = Property.Boolean(Scope.CONFIG_SPAWNING, "Spawners.DisableCommandSaving", false);
    private static final EnumProp<GeneratorType> RS_GENERATOR = Property.Enum(Scope.CONFIG_SPAWNING, GeneratorType.class, "RandomSpawning.Generator", GeneratorType.NONE);
    private static final BooleanProp RS_GENERATE_POINTS = Property.Boolean(Scope.CONFIG_SPAWNING, "RandomSpawning.GenerateSpawnPoints", false);
    private static final IntProp RANDOM_SPAWNING_PLAYER_RADIUS_MAX = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.SpawnRadiusPerPlayer", 64);
    private static final IntProp RANDOM_SPAWNING_PLAYER_RADIUS_MIN = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.SpawnRadiusPerPlayerMin", 12);
    private static final IntProp RANDOM_SPAWNING_PLAYER_RADIUS_Y = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.SpawnRadiusPerPlayerY", 16);
    private static final DoubleProp RS_GROUP_DISTANCE = Property.Double(Scope.CONFIG_SPAWNING, "RandomSpawning.PlayerClusterDistance", 24.0);
    private static final DoubleProp RS_LIMIT_MULTIPLIER = Property.Double(Scope.CONFIG_SPAWNING, "RandomSpawning.LimitMultiplier", 1.2);
    private static final DoubleProp RS_GROUP_MULTIPLIER = Property.Double(Scope.CONFIG_SPAWNING, "RandomSpawning.LocalGroupMultiplier", 0.1);
    private static final IntProp RS_LIMIT = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.SpawningLimit", -1);
    private static final IntProp RS_LOCAL_LIMIT = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.LocalSpawningLimit", -1);
    private static final IntProp RS_POINTS_PER_SECOND_LAND = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.PointsPerSecond.Land", 10);
    private static final IntProp RS_POINTS_PER_SECOND_AIR = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.PointsPerSecond.Air", 1);
    private static final IntProp RS_POINTS_PER_SECOND_SEA = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.PointsPerSecond.Sea", 1);
    private static final IntProp RS_POINTS_PER_SECOND_LAVA = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.PointsPerSecond.Lava", 0);
    private static final IntProp RS_POINTS_PER_SECOND_GROUND = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.PointsPerSecond.Ground", 0);
    private static final BooleanProp RS_DESPAWN_VANILLA_OUTSIDE_RADIUS = Property.Boolean(Scope.CONFIG_SPAWNING, "RandomSpawning.DespawnLazyRandomMobs", true);
    private static final IntProp RS_MAX_GENERATION_TIME_MILLIS = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.MaxGenerationTime", 5);
    private static final IntProp RS_MAX_GENERATION_ATTEMPTS = Property.Int(Scope.CONFIG_SPAWNING, "RandomSpawning.MaxGenerationAttempts", 10);
    private static final BooleanProp VANILLA_SPAWNS_DISABLED = Property.Boolean(Scope.CONFIG_SPAWNING, "RandomSpawning.DisableVanillaSpawns", false);
    private static final BooleanProp REPLACE_OBEYS_CAP = Property.Boolean(Scope.CONFIG_SPAWNING, "RandomSpawning.ReplaceObeysCap", false);
    private static final BooleanProp REPLACE_IGNORES_VANILLA = Property.Boolean(Scope.CONFIG_SPAWNING, "RandomSpawning.IgnoreVanillaMobs", false);
    private static final BooleanProp REPLACE_IGNORES_UNNATURAL = Property.Boolean(Scope.CONFIG_SPAWNING, "RandomSpawning.IgnoreUnnaturalMobs", false);
    private static final BooleanProp ITEMS_ENABLE_FANCY_DROPS = Property.Boolean(Scope.CONFIG_ITEMS, "EnableFancyDropEffectsEverywhere", false);
    private final String propertyNode = "Configuration";
    private Boolean allowMetrics = true;
    private Boolean allowUpdateChecking = true;
    private Boolean useCompatibilityMode = false;
    private Boolean loadExampleConfigs = true;
    private String language = "en-us";
    private boolean cacheComponents = false;
    private Boolean fireAPIDeathEvent = true;
    private Boolean fireAPISkillEvent = true;
    private Boolean fireAPICustomSkillEvent = true;
    private int debugLevel = -1;
    private boolean debugMode = false;
    private boolean debugSpawners = false;
    private Boolean doErrorLogging = true;
    private boolean cancelDamageIfZero = false;
    private DropMethod defaultDropMethod = DropMethod.VANILLA;
    private Boolean announceOpReload = false;
    private double packetMinimumPositionDelta = 7.62939453125E-6;
    private Material menuIconGenerationMaterial = Material.PAPER;
    private int menuIconGenerationStartingModel = 88000000;
    private int menuIconGenerationModel = 88000000;
    private int clockIntervalMain = 1;
    private int clockBarUpdating = 20;
    private int clockIntervalRandomSpawning = 1;
    private int clockIntervalSaving = 300;
    private int clockSpawningInterval = 2;
    private int clockScanningInterval = 10;
    private int clockCleaningInterval = 600;
    private String killMessagePrefix = "";
    private Boolean mobsDespawnByDefault = false;
    private Boolean preventOtherDropsByDefault = false;
    private Boolean preventVanillaDamageByDefault = false;
    private Map<String, Expression> statScalingEquations = Maps.newConcurrentMap();
    private Map<String, String> statDefaultLevelModifiers = Maps.newConcurrentMap();
    private Expression scalingEquationDamage = null;
    private Expression scalingEquationHealth = null;
    private Expression scalingEquationScale = null;
    private boolean mobDropsPerPlayer;
    private boolean mobDropsDoLoopslosion;
    private boolean mobDropsAreClientside;
    private boolean mobDropsDoNameHologram;
    private boolean mobDropsDoItemGlow;
    private boolean mobDropsDoItemBeam;
    private boolean mobDropsDoItemVFX;
    private Material mobDropsItemVFXMaterial;
    private int mobDropsItemVFXModel;
    private String mobDropsItemVFXGeneration;
    private List<String> mobDrosDefaultDeathHologram;
    private Integer hologramLeaderboardTimeout;
    private List<String> mobDropsDefaultChatMessage;
    private double mobDropsPerPlayerRequiredDamagePercent;
    private AbstractItemStack defaultMobEggItem;
    private PlaceholderString defaultMobEggDisplay;
    private PlaceholderString defaultMobEggModel;
    private List<PlaceholderString> defaultMobEggLore;
    private float globalMountedHologramOffset = 0.0f;
    private Color hologramCastingBarBackgroundColor;
    private Display.Billboard hologramCastingBarBillboarding;
    private float hologramCastingBarOffset;
    private Color hologramCastingInfoBackgroundColor;
    private Display.Billboard hologramCastingInfoBillboarding;
    private float hologramCastingInfoOffset;
    private Color hologramHealthBarBackgroundColor;
    private Display.Billboard hologramHealthBarBillboarding;
    private float hologramHealthBarOffset;
    private int hologramHealthBarLength;
    private AbstractVector hologramHealthBarScale;
    private Color hologramNameplateBackgroundColor;
    private Display.Billboard hologramNameplateBillboarding;
    private float hologramNameplateOffset;
    private String hologramNameplateScale;
    private Color hologramSpeechBackgroundColor;
    private Display.Billboard hologramSpeechBillboarding;
    private float hologramSpeechOffset;
    private String hologramSpeechLinePrefix;
    private static boolean EnableTimerSkills = true;
    private Boolean skillsIgnoreArmorStandsByDefault = true;
    public static boolean targetSelf = false;
    public static boolean targetPlayers = true;
    public static boolean targetArmorStands = false;
    public static boolean targetMarkers = false;
    public static boolean targetCreativeMode = true;
    public static boolean targetSpectatorMode = true;
    public static boolean targetCitizensNPCs = false;
    public static boolean targetAnimals = true;
    public static boolean targetCreatures = true;
    public static boolean targetMonsters = true;
    public static boolean targetWaterMobs = true;
    public static boolean targetFlyingMobs = true;
    public static boolean targetSameFaction = true;
    public static boolean targetOwner = true;
    public static boolean targetNonMythic = true;
    public static boolean targetVillagers = true;
    public static int SpawnerRange = 40;
    private boolean spawnersDisableSaving = false;
    private GeneratorType randomSpawningGeneratorType;
    private boolean randomSpawningGenerationEnabled = false;
    private int randomSpawningPlayerRadiusMax = 64;
    private int randomSpawningPlayerRadiusMin = 16;
    private int randomSpawningPlayerRadiusY = 16;
    private double randomSpawningGroupDistance = 24.0;
    private double randomSpawningLimitMultiplier = 1.2;
    private double randomSpawningGroupMultiplier = 0.1;
    private int randomSpawningLimit = -1;
    private int randomSpawningLocalLimit = -1;
    private boolean randomSpawningIgnoresVanilla = false;
    private boolean randomSpawningIgnoresUnnatural = false;
    private boolean randomSpawningReplaceObeysCap = false;
    private double randomSpawningTargetPercent = 0.5;
    private int randomSpawningPointsPerSecond = 10;
    private int randomSpawningPointsPerSecondAir = 0;
    private int randomSpawningPointsPerSecondSea = 1;
    private int randomSpawningPointsPerSecondLava = 0;
    private int randomSpawningPointsPerSecondGround = 0;
    private int randomSpawningMaxGenerationTimeMillis = 5;
    private int randomSpawningMaxGenerationAttempts = 10;
    private boolean randomSpawningDespawnVanillaOutsideRadius = false;
    private boolean vanillaSpawnsDisabled = false;
    public static boolean updateItems = true;
    public static String itemDefaultMaterial = "STONE";
    public boolean fancyDropsEnabledEverywhere = false;
    public static boolean compatHeroesXPEnable = false;
    public static boolean compatHeroesShowXPMessage = true;
    public static String compatHeroesXPMessageFormat = "";
    public static boolean compatSkillAPIShowXPMessage = true;
    public static String compatSkillAPIXPMessageFormat = "";
    public static boolean compatVaultShowMoneyMessage = true;
    public static String compatVaultMoneyMessageFormat = "";
    public static boolean compatMcMMOShowXPMessage = true;
    public static String compatMcMMOXPMessageFormat = "";
    private final MythicLang languageManager;
    private final Map<Class<? extends IPlaceholder>, Map<String, IPlaceholder>> placeholderStringCache = new ConcurrentHashMap<Class<? extends IPlaceholder>, Map<String, IPlaceholder>>();
    private static HashSet<Material> transparentBlocks = new HashSet();

    public ConfigExecutor(MythicBukkit core) {
        super(core, false);
        this.languageManager = new MythicLang(core);
    }

    public void firstLoad() {
        this.getConfigFolder();
        this.generateConfigFiles();
        this.debugLevel = (Integer)DEBUG_LEVEL.get(this);
        this.loadConfigSettings();
    }

    @Override
    public void load(MythicBukkit plugin) {
        plugin.getClock().setReloadingPause(true);
        this.getConfigFolder();
        this.generateConfigFiles();
        this.loadConfigSettings();
        try {
            plugin.reloadConfiguration();
            plugin.getPackManager().loadPacks();
            plugin.getPlaceholderManager().load(plugin);
            plugin.getPinManager().load(plugin);
            plugin.getStatManager().load(plugin);
            plugin.getItemManager().load(plugin);
            plugin.getSkillManager().loadSkills();
            plugin.getMobManager().loadMobs();
            plugin.getDropManager().loadDropTables();
            plugin.getRandomSpawningManager().loadRandomSpawns();
            plugin.getSpawnerManager().load(plugin);
            plugin.getMenuManager().load(plugin);
        }
        finally {
            plugin.getClock().setReloadingPause(false);
        }
        long startMillis = System.currentTimeMillis();
        plugin.getClock().runSecondPass();
        long endMillis = System.currentTimeMillis();
        MythicLogger.log("Second passes loaded after " + (endMillis - startMillis) + "ms!");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getMobManager().getMobTypes().size() + " mobs.");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getMobManager().getVanillaTypes().size() + " vanilla mob overrides.");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getMobManager().getMobStacks().size() + " mob stacks.");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getSkillManager().getSkills().size() + " skills.");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getRandomSpawningManager().getNumberOfSpawners() + " random spawns.");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getItemManager().getItems().size() + " mythic items.");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getDropManager().getDropTables().size() + " drop tables.");
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + " Loaded " + plugin.getSpawnerManager().getSpawners().size() + " mob spawners.");
    }

    public void save() {
        MythicLogger.log("Saving plugin data...");
        try {
            ((MythicBukkit)this.getPlugin()).getMobManager().saveCachedActiveMobs();
            ((MythicBukkit)this.getPlugin()).getPlayerManager().saveAll();
            ((MythicBukkit)this.getPlugin()).getWorldManager().saveAll();
            ((MythicBukkit)this.getPlugin()).getVariableManager().save();
            MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + "Saving Finished");
        }
        catch (Error | Exception ex) {
            MythicLogger.log(String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + "An error occurred while saving data");
            ex.printStackTrace();
        }
    }

    public void doClockSave() {
        try {
            ((MythicBukkit)this.getPlugin()).getMobManager().saveCachedActiveMobs();
            ((MythicBukkit)this.getPlugin()).getPlayerManager().saveAll();
            ((MythicBukkit)this.getPlugin()).getWorldManager().saveAll();
            ((MythicBukkit)this.getPlugin()).getVariableManager().save();
            ((MythicBukkit)this.getPlugin()).getSpawnerManager().saveSpawners();
            ((MythicBukkit)this.getPlugin()).getSkillManager().purgeExpiredCooldowns();
        }
        catch (Error | Exception ex) {
            MythicLogger.log(String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.WHITE) + "An error occurred while saving data");
            ex.printStackTrace();
        }
    }

    @Override
    public void unload() {
        ((MythicBukkit)this.plugin).getClock().setReloadingPause(true);
        this.save();
        this.placeholderStringCache.clear();
        ((MythicBukkit)this.plugin).getDropManager().unload();
        ((MythicBukkit)this.plugin).getItemManager().unload();
        ((MythicBukkit)this.plugin).getPinManager().unload();
        ((MythicBukkit)this.plugin).getStatManager().unload();
        ((MythicBukkit)this.plugin).getSpawnerManager().unload();
        ((MythicBukkit)this.plugin).getPlaceholderManager().unload();
        ((MythicBukkit)this.plugin).getMobManager().getTotemManager().unload();
    }

    @Override
    public File getConfigFolder() {
        File configFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "config");
        if (!configFolder.exists()) {
            configFolder.mkdir();
        }
        return configFolder;
    }

    private void generateConfigFiles() {
        File oldConfigFile;
        File statsFile;
        File configSpawningFile;
        File configSkillsFile;
        File configItemsFile;
        File configMobsFile;
        File configGeneralFile;
        File mythicFolder = ((MythicBukkit)this.getPlugin()).getDataFolder();
        File mythicConfigFolder = this.getConfigFolder();
        File mythicLanguageFolder = new File(mythicConfigFolder, "language");
        File mythicMenusFolder = new File(mythicConfigFolder, "menus");
        if (!mythicLanguageFolder.exists()) {
            mythicLanguageFolder.mkdir();
        }
        if (!mythicMenusFolder.exists()) {
            mythicMenusFolder.mkdir();
        }
        if (!(configGeneralFile = new File(mythicConfigFolder, "config-general.yml")).exists() || configGeneralFile.length() == 0L) {
            ((MythicBukkit)this.getPlugin()).saveResource("config-general.yml", configGeneralFile, true);
        }
        if (!(configMobsFile = new File(mythicConfigFolder, "config-mobs.yml")).exists() || configMobsFile.length() == 0L) {
            ((MythicBukkit)this.getPlugin()).saveResource("config-mobs.yml", configMobsFile, true);
        }
        if (!(configItemsFile = new File(mythicConfigFolder, "config-items.yml")).exists() || configItemsFile.length() == 0L) {
            ((MythicBukkit)this.getPlugin()).saveResource("config-items.yml", configItemsFile, true);
        }
        if (!(configSkillsFile = new File(mythicConfigFolder, "config-skills.yml")).exists() || configSkillsFile.length() == 0L) {
            ((MythicBukkit)this.getPlugin()).saveResource("config-skills.yml", configSkillsFile, true);
        }
        if (!(configSpawningFile = new File(mythicConfigFolder, "config-spawning.yml")).exists() || configSpawningFile.length() == 0L) {
            ((MythicBukkit)this.getPlugin()).saveResource("config-spawning.yml", configSpawningFile, true);
        }
        if (!(statsFile = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "stats.yml")).exists()) {
            ((MythicBukkit)this.getPlugin()).saveResource("stats.yml", false);
        }
        if ((oldConfigFile = new File(mythicFolder, "config.yml")).exists() && oldConfigFile.length() > 0L) {
            ((MythicBukkit)this.plugin).reloadConfiguration();
            this.convertLegacyConfigValues();
        }
        if (!this.getLoadExampleConfigs().booleanValue()) {
            return;
        }
    }

    public void loadConfigSettings() {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Settings...", new Object[0]);
        File mythicFolder = ((MythicBukkit)this.getPlugin()).getDataFolder();
        File mythicConfigFolder = this.getConfigFolder();
        File configMobsFile = new File(mythicConfigFolder, "config-mobs.yml");
        File configSpawningFile = new File(mythicConfigFolder, "config-spawning.yml");
        MythicConfig generalConfig = Scope.CONFIG_GENERAL.getConfig().getNestedConfig("Configuration");
        this.allowMetrics = generalConfig.getBoolean("General.AllowMetrics", true);
        this.allowUpdateChecking = (Boolean)GENERAL_CHECK_UPDATES.get(this);
        this.useCompatibilityMode = (Boolean)GENERAL_COMPATIB_MODE.get(this);
        this.doErrorLogging = (Boolean)GENERAL_ERROR_LOGGING.get(this);
        this.loadExampleConfigs = (Boolean)GENERAL_LOAD_EXAMPLES.get(this);
        this.language = (String)GENERAL_LANGUAGE.getset(this);
        this.languageManager.setLanguage(this.language);
        this.languageManager.loadLanguageFile();
        Integer threadLimit = (Integer)THREAD_POOL.getset(this);
        Boolean useVirtualThreads = (Boolean)USE_VIRTUAL_THREADS.getset(this);
        if (threadLimit > 0) {
            ((LumineAsyncExecutor)LumineExecutors.asyncLumine()).setThreadLimit(threadLimit);
        } else if (useVirtualThreads.booleanValue()) {
            ((LumineAsyncExecutor)LumineExecutors.asyncLumine()).useVirtualThreads();
        }
        this.cacheComponents = generalConfig.getBoolean("General.ShareComponents", false);
        this.announceOpReload = (Boolean)ANNOUNCE_OP_RELOAD.get(this);
        this.clockIntervalMain = (Integer)CLOCK_SPEED.get(this);
        this.clockIntervalRandomSpawning = (Integer)CLOCK_RANDOM_SPAWNING.get(this);
        this.clockIntervalSaving = (Integer)CLOCK_SAVING.get(this);
        this.clockBarUpdating = (Integer)CLOCK_BARS.get(this);
        this.clockCleaningInterval = (Integer)CLOCK_CLEANUP.get(this);
        this.clockSpawningInterval = (Integer)CLOCK_SPAWNS.get(this);
        this.clockScanningInterval = (Integer)CLOCK_SCANNER.get(this);
        compatHeroesXPEnable = (Boolean)COMPAT_HEROES_XP_ENABLE.get(this);
        compatHeroesShowXPMessage = (Boolean)COMPAT_HEROES_SHOW_XP_MESSAGE.get(this);
        compatHeroesXPMessageFormat = (String)COMPAT_HEROES_XP_MESSAGE_FORMAT.get(this);
        compatMcMMOShowXPMessage = (Boolean)COMPAT_MCMMO_SHOW_XP_MESSAGE.get(this);
        compatMcMMOXPMessageFormat = (String)COMPAT_MCMMO_XP_MESSAGE_FORMAT.get(this);
        compatSkillAPIShowXPMessage = (Boolean)COMPAT_SKILLAPI_SHOW_XP_MESSAGE.get(this);
        compatSkillAPIXPMessageFormat = (String)COMPAT_SKILLAPI_XP_MESSAGE_FORMAT.get(this);
        compatVaultShowMoneyMessage = (Boolean)COMPAT_VAULT_SHOW_MONEY_MESSAGE.get(this);
        compatVaultMoneyMessageFormat = (String)COMPAT_VAULT_MONEY_MESSAGE_FORMAT.get(this);
        compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
        compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
        compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
        compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        this.packetMinimumPositionDelta = Math.pow((Double)PACKET_MIN_POS_DELTA.get(this), 2.0);
        this.cancelDamageIfZero = (Boolean)CANCEL_DAMAGE_IF_0.get(this);
        this.mobsDespawnByDefault = (Boolean)MOBS_DESPAWN_BY_DEFAULT.get(this);
        this.preventOtherDropsByDefault = (Boolean)PREVENT_OTHER_DROPS_BY_DEFAULT.get(this);
        this.killMessagePrefix = (String)MOBS_KILL_MESSAGE_PREFIX.get(this);
        this.killMessagePrefix = this.killMessagePrefix == null || this.killMessagePrefix.isEmpty() ? null : SkillString.parseMessageSpecialChars(this.killMessagePrefix);
        this.defaultDropMethod = DropMethod.valueOf(((String)DROPS_DEFAULT_DROPMETHOD.getset(this)).toUpperCase());
        this.mobDropsDoLoopslosion = (Boolean)DROPS_DEFAULT_LOOTSPLOSION.getset(this);
        this.mobDropsDoNameHologram = (Boolean)DROPS_DEFAULT_NAME_HOLOGRAM.getset(this);
        this.mobDropsDoItemGlow = (Boolean)DROPS_DEFAULT_ITEM_GLOW.getset(this);
        this.mobDropsDoItemBeam = (Boolean)DROPS_DEFAULT_ITEM_BEAM.getset(this);
        this.mobDropsDoItemVFX = (Boolean)DROPS_DEFAULT_ITEM_VFX.getset(this);
        this.mobDropsItemVFXMaterial = (Material)DROPS_DEFAULT_ITEM_VFX_MATERIAL.getset(this);
        this.mobDropsItemVFXModel = (Integer)DROPS_DEFAULT_ITEM_VFX_MODEL.getset(this);
        this.mobDropsItemVFXGeneration = (String)DROPS_DEFAULT_ITEM_VFX_GENERATION.getset(this);
        ((MythicBukkit)this.getPlugin()).getClock().queueAfterLoad(() -> {
            if (this.mobDropsItemVFXGeneration != null && !this.mobDropsItemVFXGeneration.isEmpty() && ((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().isPresent()) {
                CrucibleSupport crucible = ((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().get();
                crucible.addItemToGeneration(((MythicBukkit)this.getPlugin()).getPackManager().getBasePack(), this.mobDropsItemVFXMaterial, this.mobDropsItemVFXModel, this.mobDropsItemVFXGeneration);
            }
        });
        this.mobDropsPerPlayer = (Boolean)DROPS_DEFAULT_PERPLAYER.getset(this);
        this.mobDropsAreClientside = (Boolean)DROPS_DEFAULT_CLIENTSIDE.getset(this);
        String mobDropsPerPlayerRequiredDamagePercent = (String)DROPS_PER_PLAYER_PERCENT.getset(this);
        if (mobDropsPerPlayerRequiredDamagePercent.endsWith("%")) {
            String number = mobDropsPerPlayerRequiredDamagePercent.replace("%", "");
            this.mobDropsPerPlayerRequiredDamagePercent = Double.parseDouble(number) / 100.0;
        } else {
            this.mobDropsPerPlayerRequiredDamagePercent = Double.parseDouble(mobDropsPerPlayerRequiredDamagePercent);
        }
        this.mobDrosDefaultDeathHologram = (List)DROPS_DEFAULT_DEATH_HOLOGRAM.getset(this);
        this.hologramLeaderboardTimeout = (Integer)DROPS_DEFAULT_LEADERBOARD_TIMEOUT.getset(this);
        this.mobDropsDefaultChatMessage = (List)DROPS_DEFAULT_CHAT_MESSAGE.getset(this);
        Material eggMaterial = (Material)EGG_DEFAULT_ITEM_MATERIAL.getset(this);
        String eggModel = (String)EGG_DEFAULT_ITEM_MODEL.getset(this);
        String eggDisplay = (String)EGG_DEFAULT_ITEM_DISPLAY.getset(this);
        List eggLore = (List)EGG_DEFAULT_ITEM_LORE.getset(this);
        ((MythicBukkit)this.getPlugin()).getClock().queueAfterLoad(() -> {
            this.defaultMobEggDisplay = PlaceholderString.of(eggDisplay);
            this.defaultMobEggModel = PlaceholderString.of(eggModel);
            this.defaultMobEggItem = BukkitAdapter.adapt(eggMaterial);
            OptionalInt maybeNumber = Numbers.parseInteger(eggModel);
            if (maybeNumber.isPresent()) {
                this.defaultMobEggItem.modelData(maybeNumber.getAsInt());
                this.defaultMobEggModel = null;
            } else if (ServerVersion.isBefore(MinecraftVersions.v1_21_3)) {
                this.defaultMobEggModel = null;
            }
            this.defaultMobEggLore = Lists.newArrayList();
            for (String line : eggLore) {
                this.defaultMobEggLore.add(PlaceholderString.of(line));
            }
        });
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_19_4)) {
            this.globalMountedHologramOffset = ((Double)HOLOGRAM_GLOBAL_OFFSET.get(this)).floatValue();
            this.hologramCastingBarBackgroundColor = ((Chroma)HOLOGRAM_CASTBAR_CAST_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramCastingBarBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_CASTBAR_CAST_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.CastBar.CastBillboard");
            }
            this.hologramCastingBarOffset = ((Double)HOLOGRAM_CASTBAR_CAST_OFFSET.get(this)).floatValue();
            this.hologramCastingInfoBackgroundColor = ((Chroma)HOLOGRAM_CASTBAR_INFO_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramCastingInfoBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_CASTBAR_INFO_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.CastBar.InfoBillboard");
            }
            this.hologramCastingInfoOffset = ((Double)HOLOGRAM_CASTBAR_INFO_OFFSET.get(this)).floatValue();
            this.hologramHealthBarBackgroundColor = ((Chroma)HOLOGRAM_HEALTHBAR_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramHealthBarBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_HEALTHBAR_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.HealthBar.Billboard");
            }
            this.hologramHealthBarOffset = ((Double)HOLOGRAM_HEALTHBAR_OFFSET.get(this)).floatValue();
            this.hologramHealthBarLength = (Integer)HOLOGRAM_HEALTHBAR_LENGTH.get(this);
            String hologramHealthBarScale = (String)HOLOGRAM_HEALTHBAR_SCALE.get(this);
            if (hologramHealthBarScale.contains(",")) {
                String[] stringArray = hologramHealthBarScale.split(",");
                if (stringArray.length == 3) {
                    try {
                        double x = Double.parseDouble(stringArray[0]);
                        double y = Double.parseDouble(stringArray[1]);
                        double z = Double.parseDouble(stringArray[2]);
                        this.hologramHealthBarScale = new AbstractVector(x, y, z);
                    }
                    catch (NumberFormatException ex) {
                        MythicLogger.errorGenericConfig("Invalid Scale Option for Holograms.HealthBar.Scale, expected format: x,y,z");
                    }
                } else {
                    MythicLogger.errorGenericConfig("Invalid Scale Option for Holograms.HealthBar.Scale, expected 3 values but found: " + stringArray.length);
                }
            } else {
                try {
                    Double d = Double.valueOf(hologramHealthBarScale);
                    this.hologramHealthBarScale = new AbstractVector(d, d, d);
                }
                catch (Throwable throwable) {
                    MythicLogger.errorGenericConfig("Invalid Scale Option for Holograms.HealthBar.Scale");
                }
            }
            this.hologramNameplateBackgroundColor = ((Chroma)HOLOGRAM_NAMEPLATE_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramNameplateBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_NAMEPLATE_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable throwable) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.Nameplate.Billboard");
            }
            this.hologramNameplateOffset = ((Double)HOLOGRAM_NAMEPLATE_OFFSET.get(this)).floatValue();
            this.hologramNameplateScale = (String)HOLOGRAM_NAMEPLATE_SCALE.get(this);
            this.hologramSpeechBackgroundColor = ((Chroma)HOLOGRAM_SPEECH_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramSpeechBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_SPEECH_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable throwable) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.Speech.Billboard");
            }
            this.hologramSpeechOffset = ((Double)HOLOGRAM_SPEECH_OFFSET.get(this)).floatValue();
            this.hologramSpeechLinePrefix = (String)HOLOGRAM_SPEECH_PREFIX.get(this);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading WorldScaling Settings...", new Object[0]);
        WorldScaling.reset();
        for (String string : (Set)WORLD_SCALING_NODES.get(this)) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "*** Loading WorldScaling for world " + string, new Object[0]);
            WorldScaling.initialize(string, configMobsFile);
        }
        if (MythicBukkit.isVolatile()) {
            for (Map.Entry entry : ((Map)SCALING_EQUATIONS.get(this)).entrySet()) {
                String statName = StatManager.translateLegacyStatAliases((String)entry.getKey());
                String strScalingEquation = (String)entry.getValue();
                if (strScalingEquation == null || strScalingEquation.isEmpty() || strScalingEquation.equalsIgnoreCase("NONE")) continue;
                Expression scalingEquation = new ExpressionBuilder(strScalingEquation.toLowerCase()).variables("l", "v").build();
                this.statScalingEquations.put(statName, scalingEquation);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Default Level Modifiers...", new Object[0]);
        for (Map.Entry entry : ((Map)DEFAULT_LEVEL_MODIFIERS.get(this)).entrySet()) {
            String statName = StatManager.translateLegacyStatAliases((String)entry.getKey());
            this.statDefaultLevelModifiers.put(statName, (String)entry.getValue());
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - {0}: {1}", statName, entry.getValue());
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Finished Load Default Level Modifiers!", new Object[0]);
        updateItems = (Boolean)UPDATE_ITEMS.get(this);
        itemDefaultMaterial = (String)ITEM_DEFAULT_MATERIAL.get(this);
        this.fancyDropsEnabledEverywhere = (Boolean)ITEMS_ENABLE_FANCY_DROPS.get(this);
        targetSelf = (Boolean)TARGET_SELF.get(this);
        targetPlayers = (Boolean)TARGET_PLAYERS.get(this);
        targetArmorStands = (Boolean)TARGET_ARMOR_STANDS.get(this);
        targetMarkers = (Boolean)TARGET_MARKERS.get(this);
        targetCreativeMode = (Boolean)TARGET_CREATIVE_MODE.get(this);
        targetSpectatorMode = (Boolean)TARGET_SPECTATOR_MODE.get(this);
        targetCitizensNPCs = (Boolean)TARGET_CITIZENS_NPCS.get(this);
        targetAnimals = (Boolean)TARGET_ANIMALS.get(this);
        targetCreatures = (Boolean)TARGET_CREATURES.get(this);
        targetMonsters = (Boolean)TARGET_MONSTERS.get(this);
        targetWaterMobs = (Boolean)TARGET_WATER_MOBS.get(this);
        targetFlyingMobs = (Boolean)TARGET_FLYING_MOBS.get(this);
        targetSameFaction = (Boolean)TARGET_SAME_FACTION.get(this);
        targetOwner = (Boolean)TARGET_OWNER.get(this);
        targetNonMythic = (Boolean)TARGET_NON_MYTHIC.get(this);
        targetVillagers = (Boolean)TARGET_VILLAGERS.get(this);
        this.spawnersDisableSaving = (Boolean)SPAWNERS_DISABLE_SAVING.getset(this);
        this.vanillaSpawnsDisabled = (Boolean)VANILLA_SPAWNS_DISABLED.getset(this);
        this.randomSpawningGeneratorType = (GeneratorType)((Object)RS_GENERATOR.get(this));
        this.randomSpawningGenerationEnabled = (Boolean)RS_GENERATE_POINTS.getset(this);
        if (!this.randomSpawningGenerationEnabled && this.randomSpawningGeneratorType != GeneratorType.NONE) {
            this.randomSpawningGenerationEnabled = true;
        } else if (this.randomSpawningGenerationEnabled && this.randomSpawningGeneratorType == GeneratorType.NONE) {
            this.randomSpawningGeneratorType = GeneratorType.CLUSTER;
        }
        this.randomSpawningPlayerRadiusMax = (Integer)RANDOM_SPAWNING_PLAYER_RADIUS_MAX.getset(this);
        this.randomSpawningPlayerRadiusMin = (Integer)RANDOM_SPAWNING_PLAYER_RADIUS_MIN.getset(this);
        this.randomSpawningPlayerRadiusY = (Integer)RANDOM_SPAWNING_PLAYER_RADIUS_Y.getset(this);
        this.randomSpawningGroupDistance = (Double)RS_GROUP_DISTANCE.getset(this);
        this.randomSpawningLimitMultiplier = (Double)RS_LIMIT_MULTIPLIER.getset(this);
        this.randomSpawningGroupMultiplier = (Double)RS_GROUP_MULTIPLIER.getset(this);
        this.randomSpawningLimit = (Integer)RS_LIMIT.getset(this);
        this.randomSpawningLocalLimit = (Integer)RS_LOCAL_LIMIT.getset(this);
        this.randomSpawningIgnoresVanilla = (Boolean)REPLACE_IGNORES_VANILLA.getset(this);
        this.randomSpawningIgnoresUnnatural = (Boolean)REPLACE_IGNORES_UNNATURAL.getset(this);
        this.randomSpawningReplaceObeysCap = (Boolean)REPLACE_OBEYS_CAP.getset(this);
        this.randomSpawningPointsPerSecond = (Integer)RS_POINTS_PER_SECOND_LAND.get(this);
        this.randomSpawningPointsPerSecondAir = (Integer)RS_POINTS_PER_SECOND_AIR.get(this);
        this.randomSpawningPointsPerSecondSea = (Integer)RS_POINTS_PER_SECOND_SEA.get(this);
        this.randomSpawningPointsPerSecondLava = (Integer)RS_POINTS_PER_SECOND_LAVA.get(this);
        this.randomSpawningPointsPerSecondGround = (Integer)RS_POINTS_PER_SECOND_GROUND.get(this);
        this.randomSpawningDespawnVanillaOutsideRadius = (Boolean)RS_DESPAWN_VANILLA_OUTSIDE_RADIUS.get(this);
        this.randomSpawningMaxGenerationTimeMillis = (Integer)RS_MAX_GENERATION_TIME_MILLIS.get(this);
        this.randomSpawningMaxGenerationAttempts = (Integer)RS_MAX_GENERATION_ATTEMPTS.getset(this);
    }

    public HashSet<Material> getTransparentBlocks() {
        return transparentBlocks;
    }

    public boolean shouldUpdateItems() {
        return updateItems;
    }

    @Override
    public MythicConfig createConfig(File file) {
        return new MythicConfigImpl(file);
    }

    @Override
    public MythicConfig createConfig(FileConfiguration fileConfiguration) {
        return new MythicConfigImpl((ConfigurationSection)fileConfiguration);
    }

    @Override
    public MythicConfig createConfig(String node, FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(node, (ConfigurationSection)fileConfiguration);
    }

    @Override
    public MythicConfig createConfig(String node, File file) {
        return new MythicConfigImpl(node, file);
    }

    @Override
    public MythicConfig createConfig(String node, File file, FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(node, file, (ConfigurationSection)fileConfiguration);
    }

    @Override
    public MythicLineConfig createLineConfig(File file, String line) {
        return new MythicLineConfigImpl(file, line);
    }

    private <P extends IPlaceholder> P getOrCreatePlaceholderLine(Class<P> type, String key, Supplier<P> factory) {
        if (key == null) {
            return (P)((IPlaceholder)factory.get());
        }
        return (P)this.placeholderStringCache.computeIfAbsent(type, t2 -> new ConcurrentHashMap()).computeIfAbsent(key, k -> (IPlaceholder)factory.get());
    }

    @Override
    public PlaceholderAngle createPlaceholderAngle(String s2, AngleUnit defaultUnit) {
        String cacheKey = s2 == null ? null : s2 + defaultUnit.name();
        return this.getOrCreatePlaceholderLine(PlaceholderAngle.class, cacheKey, () -> PlaceholderAngleImpl.of(s2, defaultUnit));
    }

    @Override
    public PlaceholderBoolean createPlaceholderBoolean(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderBoolean.class, s2, () -> PlaceholderBooleanImpl.of(s2));
    }

    @Override
    public PlaceholderColor createPlaceholderColor(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderColor.class, s2, () -> new PlaceholderColorImpl(this.createPlaceholderString(s2)));
    }

    @Override
    public PlaceholderDouble createPlaceholderDouble(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderDouble.class, s2, () -> PlaceholderDoubleImpl.of(s2));
    }

    @Override
    public PlaceholderFloat createPlaceholderFloat(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderFloat.class, s2, () -> PlaceholderFloatImpl.of(s2));
    }

    @Override
    public PlaceholderInt createPlaceholderInt(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderInt.class, s2, () -> PlaceholderIntImpl.of(s2));
    }

    @Override
    public PlaceholderLong createPlaceholderLong(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderLong.class, s2, () -> PlaceholderLongImpl.of(s2));
    }

    @Override
    public PlaceholderString createPlaceholderString(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderString.class, s2, () -> PlaceholderStringImpl.of(s2));
    }

    @Override
    public PlaceholderTime createPlaceholderTime(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderTime.class, s2, () -> PlaceholderTimeImpl.of(s2));
    }

    @Override
    public PlaceholderVector createPlaceholderVector(String s2) {
        return this.getOrCreatePlaceholderLine(PlaceholderVector.class, s2, () -> PlaceholderVectorImpl.of(s2));
    }

    @Override
    public MythicLineConfig createLineConfig(String line) {
        return new MythicLineConfigImpl(line);
    }

    public Optional<Expression> getStatScalingEquation(StatType statType) {
        return Optional.ofNullable(this.statScalingEquations.get(statType.getKey()));
    }

    public Optional<String> getStatDefaultLevelModifier(StatType statType) {
        return Optional.ofNullable(this.statDefaultLevelModifiers.get(statType.getKey()));
    }

    private void convertLegacyConfigValues() {
        File oldConfigFile = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "config.yml");
        if (!oldConfigFile.exists() || oldConfigFile.length() == 0L) {
            return;
        }
        LegacyConfigExecutor oldConfig = new LegacyConfigExecutor((MythicBukkit)this.getPlugin());
        oldConfig.loadSettings();
        GENERAL_ALLOW_METRICS.set(this, oldConfig.getAllowMetrics());
        GENERAL_CHECK_UPDATES.set(this, oldConfig.getAllowUpdateChecking());
        GENERAL_COMPATIB_MODE.set(this, oldConfig.getUseCompatibilityMode());
        GENERAL_ERROR_LOGGING.set(this, oldConfig.getDoErrorLogging());
        GENERAL_LOAD_EXAMPLES.set(this, oldConfig.getLoadExampleConfigs());
        DEBUG_LEVEL.set(this, Integer.valueOf(oldConfig.getDebugLevel()));
        DEBUG_MODE.set(this, Boolean.valueOf(oldConfig.isDebugMode()));
        DEBUG_SPAWNERS.set(this, Boolean.valueOf(oldConfig.isDebugSpawners()));
        CLOCK_SPEED.set(this, Integer.valueOf(oldConfig.getClockIntervalMain()));
        CLOCK_BARS.set(this, Integer.valueOf(oldConfig.getBossBarUpdateInterval()));
        CLOCK_SAVING.set(this, Integer.valueOf(oldConfig.getClockIntervalSaving()));
        CLOCK_SPAWNS.set(this, Integer.valueOf(oldConfig.getSpawningInterval()));
        CLOCK_RANDOM_SPAWNING.set(this, Integer.valueOf(oldConfig.getClockIntervalRandomSpawning()));
        CLOCK_SCANNER.set(this, Integer.valueOf(oldConfig.getScanInterval()));
        CLOCK_CLEANUP.set(this, Integer.valueOf(oldConfig.getClnrInterval()));
        COMPAT_HEROES_XP_ENABLE.set(this, Boolean.valueOf(oldConfig.compatHeroesXPEnable));
        COMPAT_HEROES_SHOW_XP_MESSAGE.set(this, Boolean.valueOf(oldConfig.compatHeroesShowXPMessage));
        COMPAT_HEROES_XP_MESSAGE_FORMAT.set(this, oldConfig.compatHeroesXPMessageFormat);
        COMPAT_MCMMO_SHOW_XP_MESSAGE.set(this, Boolean.valueOf(oldConfig.compatMcMMOShowXPMessage));
        COMPAT_MCMMO_XP_MESSAGE_FORMAT.set(this, oldConfig.compatMcMMOXPMessageFormat);
        COMPAT_SKILLAPI_SHOW_XP_MESSAGE.set(this, Boolean.valueOf(oldConfig.compatSkillAPIShowXPMessage));
        COMPAT_SKILLAPI_XP_MESSAGE_FORMAT.set(this, oldConfig.compatSkillAPIXPMessageFormat);
        COMPAT_VAULT_SHOW_MONEY_MESSAGE.set(this, Boolean.valueOf(oldConfig.compatVaultShowMoneyMessage));
        COMPAT_VAULT_MONEY_MESSAGE_FORMAT.set(this, oldConfig.compatVaultMoneyMessageFormat);
        MOBS_DESPAWN_BY_DEFAULT.set(this, oldConfig.getMobsDespawnByDefault());
        CANCEL_DAMAGE_IF_0.set(this, Boolean.valueOf(oldConfig.isCancelDamageIfZero()));
        MOBS_KILL_MESSAGE_PREFIX.set(this, oldConfig.getKillMessagePrefix());
        PREVENT_OTHER_DROPS_BY_DEFAULT.set(this, Boolean.valueOf(oldConfig.getPreventOtherDropsByDefault()));
        SCALING_EQUATION_DAMAGE.set(this, oldConfig.getScalingEquationDamage());
        SCALING_EQUATION_HEALTH.set(this, oldConfig.getScalingEquationHealth());
        UPDATE_ITEMS.set(this, Boolean.valueOf(oldConfig.updateItems));
        TARGET_SELF.set(this, Boolean.valueOf(oldConfig.targetSelf));
        TARGET_PLAYERS.set(this, Boolean.valueOf(oldConfig.targetPlayers));
        TARGET_ARMOR_STANDS.set(this, Boolean.valueOf(oldConfig.targetArmorStands));
        TARGET_MARKERS.set(this, Boolean.valueOf(oldConfig.targetMarkers));
        TARGET_CREATIVE_MODE.set(this, Boolean.valueOf(oldConfig.targetCreativeMode));
        TARGET_SPECTATOR_MODE.set(this, Boolean.valueOf(oldConfig.targetSpectatorMode));
        TARGET_CITIZENS_NPCS.set(this, Boolean.valueOf(oldConfig.targetCitizensNPCs));
        TARGET_ANIMALS.set(this, Boolean.valueOf(oldConfig.targetAnimals));
        TARGET_CREATURES.set(this, Boolean.valueOf(oldConfig.targetCreatures));
        TARGET_MONSTERS.set(this, Boolean.valueOf(oldConfig.targetMonsters));
        TARGET_WATER_MOBS.set(this, Boolean.valueOf(oldConfig.targetWaterMobs));
        TARGET_FLYING_MOBS.set(this, Boolean.valueOf(oldConfig.targetFlyingMobs));
        TARGET_SAME_FACTION.set(this, Boolean.valueOf(oldConfig.targetSameFaction));
        TARGET_OWNER.set(this, Boolean.valueOf(oldConfig.targetOwner));
        TARGET_NON_MYTHIC.set(this, Boolean.valueOf(oldConfig.targetNonMythic));
        TARGET_VILLAGERS.set(this, Boolean.valueOf(oldConfig.targetVillagers));
        RS_GENERATE_POINTS.set(this, Boolean.valueOf(oldConfig.rsGeneratePoints));
        RANDOM_SPAWNING_PLAYER_RADIUS_MAX.set(this, Integer.valueOf(oldConfig.randomSpawningPlayerRadiusMax));
        RANDOM_SPAWNING_PLAYER_RADIUS_MIN.set(this, Integer.valueOf(oldConfig.randomSpawningPlayerRadiusMin));
        RANDOM_SPAWNING_PLAYER_RADIUS_Y.set(this, Integer.valueOf(oldConfig.randomSpawningPlayerRadiusY));
        RS_POINTS_PER_SECOND_LAND.set(this, Integer.valueOf(oldConfig.rsPointsPerSecondLand));
        RS_POINTS_PER_SECOND_AIR.set(this, Integer.valueOf(oldConfig.rsPointsPerSecondAir));
        RS_POINTS_PER_SECOND_SEA.set(this, Integer.valueOf(oldConfig.rsPointsPerSecondSea));
        RS_POINTS_PER_SECOND_LAVA.set(this, Integer.valueOf(oldConfig.rsPointsPerSecondLava));
        RS_POINTS_PER_SECOND_GROUND.set(this, Integer.valueOf(oldConfig.rsPointsPerSecondGround));
        RS_DESPAWN_VANILLA_OUTSIDE_RADIUS.set(this, Boolean.valueOf(oldConfig.rsDespawnVanillaOutsideRadius));
        RS_MAX_GENERATION_TIME_MILLIS.set(this, Integer.valueOf(oldConfig.rsMaxGenerationTimeMillis));
        VANILLA_SPAWNS_DISABLED.set(this, Boolean.valueOf(oldConfig.vanillaSpawnsDisabled));
        File newConfigFile = new File(this.getConfigFolder(), "config-mobs.yml");
        String newPath = "Configuration.MobLeveling.WorldScaling";
        YamlConfiguration oldSection = YamlConfiguration.loadConfiguration((File)oldConfigFile);
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)newConfigFile);
        if (oldSection.contains("Configuration.Mobs.Scaling")) {
            for (String world : oldSection.getConfigurationSection("Configuration.Mobs.Scaling").getKeys(false)) {
                Object value = oldSection.get("Configuration.Mobs.Scaling." + world);
                newConfig.set("Configuration.MobLeveling.WorldScaling." + world, value);
            }
        }
        try {
            newConfig.save(newConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File oldConfigFileNew = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "config.yml.old");
        File oldDataFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "SavedData");
        File newDataFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "data");
        try {
            Files.move((File)oldConfigFile, (File)oldConfigFileNew);
            if (oldDataFolder.exists() && oldDataFolder.isDirectory() && newDataFolder.exists() && newDataFolder.isDirectory()) {
                Folders.moveDirectoryContents(oldDataFolder, newDataFolder);
                Folders.deleteDirectory(oldDataFolder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized int getIconGenerationModel() {
        return this.menuIconGenerationModel++;
    }

    @Override
    public String getPropertyNode() {
        return this.propertyNode;
    }

    public Boolean getAllowMetrics() {
        return this.allowMetrics;
    }

    public Boolean getAllowUpdateChecking() {
        return this.allowUpdateChecking;
    }

    public Boolean getUseCompatibilityMode() {
        return this.useCompatibilityMode;
    }

    @Override
    public Boolean getLoadExampleConfigs() {
        return this.loadExampleConfigs;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isCacheComponents() {
        return this.cacheComponents;
    }

    public Boolean getFireAPIDeathEvent() {
        return this.fireAPIDeathEvent;
    }

    public Boolean getFireAPISkillEvent() {
        return this.fireAPISkillEvent;
    }

    public Boolean getFireAPICustomSkillEvent() {
        return this.fireAPICustomSkillEvent;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isDebugSpawners() {
        return this.debugSpawners;
    }

    public Boolean getDoErrorLogging() {
        return this.doErrorLogging;
    }

    public boolean isCancelDamageIfZero() {
        return this.cancelDamageIfZero;
    }

    public DropMethod getDefaultDropMethod() {
        return this.defaultDropMethod;
    }

    public Boolean getAnnounceOpReload() {
        return this.announceOpReload;
    }

    public double getPacketMinimumPositionDelta() {
        return this.packetMinimumPositionDelta;
    }

    public Material getMenuIconGenerationMaterial() {
        return this.menuIconGenerationMaterial;
    }

    @Override
    public int getClockIntervalMain() {
        return this.clockIntervalMain;
    }

    public int getClockBarUpdating() {
        return this.clockBarUpdating;
    }

    public int getClockIntervalRandomSpawning() {
        return this.clockIntervalRandomSpawning;
    }

    public int getClockIntervalSaving() {
        return this.clockIntervalSaving;
    }

    public int getClockSpawningInterval() {
        return this.clockSpawningInterval;
    }

    public int getClockScanningInterval() {
        return this.clockScanningInterval;
    }

    public int getClockCleaningInterval() {
        return this.clockCleaningInterval;
    }

    public String getKillMessagePrefix() {
        return this.killMessagePrefix;
    }

    public Boolean getMobsDespawnByDefault() {
        return this.mobsDespawnByDefault;
    }

    public Boolean getPreventOtherDropsByDefault() {
        return this.preventOtherDropsByDefault;
    }

    public Boolean getPreventVanillaDamageByDefault() {
        return this.preventVanillaDamageByDefault;
    }

    public Map<String, Expression> getStatScalingEquations() {
        return this.statScalingEquations;
    }

    public Map<String, String> getStatDefaultLevelModifiers() {
        return this.statDefaultLevelModifiers;
    }

    public Expression getScalingEquationDamage() {
        return this.scalingEquationDamage;
    }

    public Expression getScalingEquationHealth() {
        return this.scalingEquationHealth;
    }

    public Expression getScalingEquationScale() {
        return this.scalingEquationScale;
    }

    public boolean isMobDropsPerPlayer() {
        return this.mobDropsPerPlayer;
    }

    public boolean isMobDropsDoLoopslosion() {
        return this.mobDropsDoLoopslosion;
    }

    public boolean isMobDropsAreClientside() {
        return this.mobDropsAreClientside;
    }

    public boolean isMobDropsDoNameHologram() {
        return this.mobDropsDoNameHologram;
    }

    public boolean isMobDropsDoItemGlow() {
        return this.mobDropsDoItemGlow;
    }

    public boolean isMobDropsDoItemBeam() {
        return this.mobDropsDoItemBeam;
    }

    public boolean isMobDropsDoItemVFX() {
        return this.mobDropsDoItemVFX;
    }

    public Material getMobDropsItemVFXMaterial() {
        return this.mobDropsItemVFXMaterial;
    }

    public int getMobDropsItemVFXModel() {
        return this.mobDropsItemVFXModel;
    }

    public String getMobDropsItemVFXGeneration() {
        return this.mobDropsItemVFXGeneration;
    }

    public List<String> getMobDrosDefaultDeathHologram() {
        return this.mobDrosDefaultDeathHologram;
    }

    public Integer getHologramLeaderboardTimeout() {
        return this.hologramLeaderboardTimeout;
    }

    public List<String> getMobDropsDefaultChatMessage() {
        return this.mobDropsDefaultChatMessage;
    }

    public double getMobDropsPerPlayerRequiredDamagePercent() {
        return this.mobDropsPerPlayerRequiredDamagePercent;
    }

    public AbstractItemStack getDefaultMobEggItem() {
        return this.defaultMobEggItem;
    }

    public PlaceholderString getDefaultMobEggDisplay() {
        return this.defaultMobEggDisplay;
    }

    public PlaceholderString getDefaultMobEggModel() {
        return this.defaultMobEggModel;
    }

    public List<PlaceholderString> getDefaultMobEggLore() {
        return this.defaultMobEggLore;
    }

    public float getGlobalMountedHologramOffset() {
        return this.globalMountedHologramOffset;
    }

    public Color getHologramCastingBarBackgroundColor() {
        return this.hologramCastingBarBackgroundColor;
    }

    public Display.Billboard getHologramCastingBarBillboarding() {
        return this.hologramCastingBarBillboarding;
    }

    public float getHologramCastingBarOffset() {
        return this.hologramCastingBarOffset;
    }

    public Color getHologramCastingInfoBackgroundColor() {
        return this.hologramCastingInfoBackgroundColor;
    }

    public Display.Billboard getHologramCastingInfoBillboarding() {
        return this.hologramCastingInfoBillboarding;
    }

    public float getHologramCastingInfoOffset() {
        return this.hologramCastingInfoOffset;
    }

    public Color getHologramHealthBarBackgroundColor() {
        return this.hologramHealthBarBackgroundColor;
    }

    public Display.Billboard getHologramHealthBarBillboarding() {
        return this.hologramHealthBarBillboarding;
    }

    public float getHologramHealthBarOffset() {
        return this.hologramHealthBarOffset;
    }

    public int getHologramHealthBarLength() {
        return this.hologramHealthBarLength;
    }

    public AbstractVector getHologramHealthBarScale() {
        return this.hologramHealthBarScale;
    }

    public Color getHologramNameplateBackgroundColor() {
        return this.hologramNameplateBackgroundColor;
    }

    public Display.Billboard getHologramNameplateBillboarding() {
        return this.hologramNameplateBillboarding;
    }

    public float getHologramNameplateOffset() {
        return this.hologramNameplateOffset;
    }

    public String getHologramNameplateScale() {
        return this.hologramNameplateScale;
    }

    public Color getHologramSpeechBackgroundColor() {
        return this.hologramSpeechBackgroundColor;
    }

    public Display.Billboard getHologramSpeechBillboarding() {
        return this.hologramSpeechBillboarding;
    }

    public float getHologramSpeechOffset() {
        return this.hologramSpeechOffset;
    }

    public String getHologramSpeechLinePrefix() {
        return this.hologramSpeechLinePrefix;
    }

    public static boolean isEnableTimerSkills() {
        return EnableTimerSkills;
    }

    public Boolean getSkillsIgnoreArmorStandsByDefault() {
        return this.skillsIgnoreArmorStandsByDefault;
    }

    public static boolean isTargetSelf() {
        return targetSelf;
    }

    public static boolean isTargetPlayers() {
        return targetPlayers;
    }

    public static boolean isTargetArmorStands() {
        return targetArmorStands;
    }

    public static boolean isTargetMarkers() {
        return targetMarkers;
    }

    public static boolean isTargetCreativeMode() {
        return targetCreativeMode;
    }

    public static boolean isTargetSpectatorMode() {
        return targetSpectatorMode;
    }

    public static boolean isTargetCitizensNPCs() {
        return targetCitizensNPCs;
    }

    public static boolean isTargetAnimals() {
        return targetAnimals;
    }

    public static boolean isTargetCreatures() {
        return targetCreatures;
    }

    public static boolean isTargetMonsters() {
        return targetMonsters;
    }

    public static boolean isTargetWaterMobs() {
        return targetWaterMobs;
    }

    public static boolean isTargetFlyingMobs() {
        return targetFlyingMobs;
    }

    public static boolean isTargetSameFaction() {
        return targetSameFaction;
    }

    public static boolean isTargetOwner() {
        return targetOwner;
    }

    public static boolean isTargetNonMythic() {
        return targetNonMythic;
    }

    public static boolean isTargetVillagers() {
        return targetVillagers;
    }

    public boolean isSpawnersDisableSaving() {
        return this.spawnersDisableSaving;
    }

    public GeneratorType getRandomSpawningGeneratorType() {
        return this.randomSpawningGeneratorType;
    }

    public boolean isRandomSpawningGenerationEnabled() {
        return this.randomSpawningGenerationEnabled;
    }

    public int getRandomSpawningPlayerRadiusMax() {
        return this.randomSpawningPlayerRadiusMax;
    }

    public int getRandomSpawningPlayerRadiusMin() {
        return this.randomSpawningPlayerRadiusMin;
    }

    public int getRandomSpawningPlayerRadiusY() {
        return this.randomSpawningPlayerRadiusY;
    }

    public double getRandomSpawningGroupDistance() {
        return this.randomSpawningGroupDistance;
    }

    public double getRandomSpawningLimitMultiplier() {
        return this.randomSpawningLimitMultiplier;
    }

    public double getRandomSpawningGroupMultiplier() {
        return this.randomSpawningGroupMultiplier;
    }

    public int getRandomSpawningLimit() {
        return this.randomSpawningLimit;
    }

    public int getRandomSpawningLocalLimit() {
        return this.randomSpawningLocalLimit;
    }

    public boolean isRandomSpawningIgnoresVanilla() {
        return this.randomSpawningIgnoresVanilla;
    }

    public boolean isRandomSpawningIgnoresUnnatural() {
        return this.randomSpawningIgnoresUnnatural;
    }

    public boolean isRandomSpawningReplaceObeysCap() {
        return this.randomSpawningReplaceObeysCap;
    }

    public double getRandomSpawningTargetPercent() {
        return this.randomSpawningTargetPercent;
    }

    public int getRandomSpawningPointsPerSecond() {
        return this.randomSpawningPointsPerSecond;
    }

    public int getRandomSpawningPointsPerSecondAir() {
        return this.randomSpawningPointsPerSecondAir;
    }

    public int getRandomSpawningPointsPerSecondSea() {
        return this.randomSpawningPointsPerSecondSea;
    }

    public int getRandomSpawningPointsPerSecondLava() {
        return this.randomSpawningPointsPerSecondLava;
    }

    public int getRandomSpawningPointsPerSecondGround() {
        return this.randomSpawningPointsPerSecondGround;
    }

    public int getRandomSpawningMaxGenerationTimeMillis() {
        return this.randomSpawningMaxGenerationTimeMillis;
    }

    public int getRandomSpawningMaxGenerationAttempts() {
        return this.randomSpawningMaxGenerationAttempts;
    }

    public boolean isRandomSpawningDespawnVanillaOutsideRadius() {
        return this.randomSpawningDespawnVanillaOutsideRadius;
    }

    public boolean isVanillaSpawnsDisabled() {
        return this.vanillaSpawnsDisabled;
    }

    public static String getItemDefaultMaterial() {
        return itemDefaultMaterial;
    }

    public boolean isFancyDropsEnabledEverywhere() {
        return this.fancyDropsEnabledEverywhere;
    }

    static {
        for (Material m4 : Material.values()) {
            if (!m4.isTransparent() && m4.isSolid() && m4.isOccluding()) continue;
            transparentBlocks.add(m4);
        }
    }
}

