/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops.droppables;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.numbers.RandomDouble;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.glow.GlowColor;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Optional;

public abstract class ItemDrop
extends Drop {
    protected Optional<Boolean> lootsplosionEnabled;
    protected Optional<Boolean> clientSideDropsEnabled;
    protected Optional<Boolean> hologramNameEnabled;
    protected Optional<Boolean> itemGlowEnabled;
    protected Optional<Boolean> itemBeamEnabled;
    protected Optional<Boolean> itemVFXEnabled;
    protected GlowColor itemGlow = null;
    protected Chroma itemBeam = null;
    protected String itemVfxMaterial;
    protected int itemVfxData;
    protected String itemVfxModel;
    protected long pityModifier;
    protected boolean resetPity;
    protected String pityCategory;
    protected double minDamage;
    protected int requiredPlacement;
    protected String displayBillboarding;
    protected int displayBrightness;
    protected String vfxColor;
    protected double fortuneMod = 0.0;
    protected double lootingMod = 0.0;

    public ItemDrop(String line, MythicLineConfig config) {
        super(line, config);
        this.lootsplosionEnabled = Optional.ofNullable(config.getBooleanNullable(new String[]{"lootsplosion", "lootsplosionenabled", "ls"}));
        this.clientSideDropsEnabled = Optional.ofNullable(config.getBooleanNullable(new String[]{"clientsidedrops", "clientsidedropsenabled", "csd"}));
        this.hologramNameEnabled = Optional.ofNullable(config.getBooleanNullable(new String[]{"hologramname", "hologramnameenabled", "hn"}));
        this.itemGlowEnabled = Optional.ofNullable(config.getBooleanNullable(new String[]{"itemglow", "itemglowenabled", "ig"}));
        String glowColor = config.getString(new String[]{"itemglowcolor", "glowcolor", "gc"}, null, new String[0]);
        if (glowColor != null) {
            try {
                this.itemGlow = GlowColor.valueOf(glowColor);
            }
            catch (Throwable ex) {
                MythicLogger.errorDropConfig(this, config, "Invalid ItemGlow Color specified");
                ex.printStackTrace();
            }
        }
        this.itemBeamEnabled = Optional.ofNullable(config.getBooleanNullable(new String[]{"itembeam", "itembeamenabled", "ib"}));
        Chroma beamColor = config.getColor(new String[]{"itembeamcolor", "beamColor", "bc"}, null);
        if (beamColor != null) {
            try {
                this.itemBeam = beamColor;
            }
            catch (Throwable ex) {
                MythicLogger.errorDropConfig(this, config, "Invalid BeamColor Color specified");
            }
        }
        this.itemVFXEnabled = Optional.ofNullable(config.getBooleanNullable(new String[]{"itemvfx", "ivfx", "vfx"}));
        this.itemVfxMaterial = config.getString(new String[]{"vfxmaterial", "vfxmat", "vfxm"}, null, new String[0]);
        this.itemVfxData = config.getInteger(new String[]{"vfxdata", "vfxd"}, 0);
        PlaceholderString modelString = config.getPlaceholderString(new String[]{"vfxmodel", "vfxitemmodel"}, null, new String[0]);
        if (modelString != null) {
            this.itemVfxModel = modelString.get();
        }
        this.vfxColor = config.getString(new String[]{"vfxcolor", "vfxc", "color"}, null, new String[0]);
        this.pityModifier = config.getLong(new String[]{"pitymodifier", "pitymod", "pmod"}, 0L);
        this.resetPity = config.getBoolean(new String[]{"resetpity", "resetp", "rp"}, false);
        this.pityCategory = config.getString(new String[]{"pcategory", "pitycategory", "category"}, "DEFAULT", new String[0]);
        this.minDamage = config.getDouble(new String[]{"damage", "mindamage", "min"}, 0.0);
        this.requiredPlacement = config.getInteger(new String[]{"top", "placement", "required"}, Integer.MAX_VALUE);
        this.displayBillboarding = config.getString(new String[]{"billboarding", "billboard", "bill"}, "VERTICAL", new String[0]);
        this.displayBrightness = config.getInteger(new String[]{"brightness", "bright", "b"}, 0);
        boolean fortune = config.getBoolean("fortune", false);
        this.fortuneMod = config.getDouble(new String[]{"fortunemod"}, fortune ? 1.0 : 0.0);
        boolean looting = config.getBoolean("looting", false);
        this.lootingMod = config.getDouble(new String[]{"lootingmod"}, fortune ? 1.0 : 0.0);
    }

    public ItemDrop(String line, MythicLineConfig config, double amount) {
        super(line, config, amount);
    }

    public ItemDrop(String line, MythicLineConfig config, RandomDouble amount) {
        super(line, config, amount);
    }

    protected int rollBonuses(DropMetadata meta, int amount) {
        AbstractEntity cause;
        if (this.fortuneMod > 0.0 && meta.getCause().isPresent() && (cause = meta.getCause().get()).isPlayer()) {
            AbstractPlayer player = cause.asPlayer();
            int fortuneLevel = player.getFortuneLevel();
            amount = this.getFortuneMultiplier(fortuneLevel) * amount;
        }
        return amount;
    }

    protected int getFortuneMultiplier(int fortuneLevel) {
        if (fortuneLevel <= 0) {
            return 1;
        }
        int baseWeight = 2;
        int totalWeight = baseWeight + fortuneLevel;
        int randomWeight = Numbers.floor(Math.random() * (double)totalWeight * this.fortuneMod);
        if (randomWeight < baseWeight) {
            return 1;
        }
        return 2 + (randomWeight - baseWeight);
    }

    public Optional<Boolean> getLootsplosionEnabled() {
        return this.lootsplosionEnabled;
    }

    public Optional<Boolean> getClientSideDropsEnabled() {
        return this.clientSideDropsEnabled;
    }

    public Optional<Boolean> getHologramNameEnabled() {
        return this.hologramNameEnabled;
    }

    public Optional<Boolean> getItemGlowEnabled() {
        return this.itemGlowEnabled;
    }

    public Optional<Boolean> getItemBeamEnabled() {
        return this.itemBeamEnabled;
    }

    public Optional<Boolean> getItemVFXEnabled() {
        return this.itemVFXEnabled;
    }

    public GlowColor getItemGlow() {
        return this.itemGlow;
    }

    public Chroma getItemBeam() {
        return this.itemBeam;
    }

    public String getItemVfxMaterial() {
        return this.itemVfxMaterial;
    }

    public int getItemVfxData() {
        return this.itemVfxData;
    }

    public String getItemVfxModel() {
        return this.itemVfxModel;
    }

    public long getPityModifier() {
        return this.pityModifier;
    }

    public boolean isResetPity() {
        return this.resetPity;
    }

    public String getPityCategory() {
        return this.pityCategory;
    }

    public double getMinDamage() {
        return this.minDamage;
    }

    public int getRequiredPlacement() {
        return this.requiredPlacement;
    }

    public String getDisplayBillboarding() {
        return this.displayBillboarding;
    }

    public int getDisplayBrightness() {
        return this.displayBrightness;
    }

    public String getVfxColor() {
        return this.vfxColor;
    }
}

