/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.lumine.mythic.api.adapters.AbstractAttributeModifier;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractItemStackRarity;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBannerComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlockStateComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlocksAttacksComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemEquippableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemFoodComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemGliderComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemSpawnerComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemToolComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTooltipComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTrialSpawnerComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTrimComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemUseCooldownComponent;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderColor;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitAttribute;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentBukkitItemStack;
import io.lumine.mythic.bukkit.events.MythicApplyEnchantEvent;
import io.lumine.mythic.bukkit.events.MythicMobItemGenerateEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.gson.GsonProvider;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.serialize.Base64Util;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.items.LegacyItemConverter;
import io.lumine.mythic.core.items.Version;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import io.lumine.mythic.core.menus.items.ItemMenuContext;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMetadataKey;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.jnbt.ByteTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTagBuilder;
import io.lumine.mythic.core.utils.jnbt.DoubleTag;
import io.lumine.mythic.core.utils.jnbt.ListTag;
import io.lumine.mythic.core.utils.jnbt.PlaceholderDoubleTag;
import io.lumine.mythic.core.utils.jnbt.PlaceholderFloatTag;
import io.lumine.mythic.core.utils.jnbt.PlaceholderIntTag;
import io.lumine.mythic.core.utils.jnbt.PlaceholderStringTag;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class MythicItem
implements Comparable<MythicItem>,
MenuData<ItemMenuContext> {
    private final MythicConfig config;
    private AbstractItemStack cachedBaseItem;
    private ItemStack cachedMenuItem;
    private boolean imported = false;
    private final String internalName;
    private final Pack pack;
    private final File file;
    private String group = "OTHER";
    private String displayName;
    private String strMaterial;
    private Material material;
    private int customModelData;
    @Deprecated
    private byte data;
    private int amount = 1;
    private PlaceholderInt durability;
    private PlaceholderInt maxDurability;
    private int maxStackSize;
    private Boolean enchantGlint;
    private Boolean fireResistant;
    private AbstractItemStackRarity rarity;
    private PlaceholderInt maxEnchantments;
    private Boolean preventEnchanting;
    private Boolean preventAnvilWith;
    private Boolean preventCraftingWith;
    private Boolean preventSmithingWith;
    private PlaceholderColor dropColor;
    private PlaceholderColor color;
    private DyeColor shieldColor;
    private PlaceholderString armorTrim;
    private String player;
    private String skinURL;
    private UUID skinUUID;
    private Optional<String> loreTemplate = Optional.empty();
    private List<PlaceholderString> lore;
    private Map<Enchantment, PlaceholderInt> enchantments = Maps.newConcurrentMap();
    private Collection<AbstractItemComponent> components = Lists.newArrayList();
    private PlaceholderString bookAuthor;
    private PlaceholderString bookTitle;
    private List<PlaceholderString> bookPages;
    private List<String> potionEffects;
    private List<String> fireworkColors;
    private List<String> fireworkFadeColors;
    private AbstractItemFoodComponent foodData;
    private AbstractItemPotionComponent potionData;
    private AbstractItemEquippableComponent equippableData;
    private AbstractItemUseCooldownComponent useCooldownData;
    private AbstractItemToolComponent toolData;
    private AbstractItemTooltipComponent tooltipComponent;
    private AbstractItemSpawnerComponent spawnerData;
    private AbstractItemTrimComponent trimComponent;
    private NamespacedKey itemModel;
    private Map<String, Tag> itemNBT = new HashMap<String, Tag>();
    private final List<AbstractAttributeModifier> itemAttributes = new ArrayList<AbstractAttributeModifier>();
    private final Map<String, Tag> itemOptions = new HashMap<String, Tag>();
    private final List<String> hideOptions = new ArrayList<String>();
    private final List<String> placeOptions = new ArrayList<String>();
    private final List<String> breakOptions = new ArrayList<String>();
    private boolean unbreakable;
    private boolean hideFlags;
    private String mythicTypeOverride;
    private Boolean appendType = true;
    private boolean preventStacking = false;
    private boolean generateUUID = false;
    private boolean generateTimestamp = false;
    private boolean dropLootsplosion = false;
    private boolean dropClientSide = false;
    private boolean dropHologram = false;
    private boolean dropVFX = false;
    private String dropVFXMaterial = null;
    private int dropVFXData = 0;
    private String dropVFXColor = null;
    private String dropBillboarding = "VERTICAL";
    private int dropBrightness = 0;
    private Version itemVersion;
    private boolean preserveStatRatioOnUpdate = true;
    private String dropGlowColor = null;
    private Chroma dropBeamColor = null;
    private boolean dropGlow = false;
    private boolean dropBeam = false;
    private final Map<SkillTrigger<?>, Queue<SkillMechanic>> dropSkills = new HashMap();

    private static MythicBukkit getPlugin() {
        return MythicBukkit.inst();
    }

    public MythicItem(Pack pack, File file, String internalName) {
        this.pack = pack;
        this.file = file;
        this.internalName = internalName;
        this.config = new MythicConfigImpl(internalName, file);
        this.config.load();
        this.config.set("Material", "STONE");
        this.config.set("Display", internalName);
        this.config.save();
        this.loadItem();
    }

    public MythicItem(Pack pack, File file, String internalName, MythicConfig mc) {
        this.pack = pack;
        this.config = mc;
        this.file = file;
        this.internalName = internalName;
        this.loadItem();
    }

    public void loadItem() {
        List<String> canBreak;
        List<String> canPlaceOn;
        List<String> hideOptions;
        AbstractItemComponent componentData;
        this.itemNBT.clear();
        this.itemOptions.clear();
        this.hideOptions.clear();
        this.placeOptions.clear();
        this.breakOptions.clear();
        this.dropLootsplosion = this.config.getBoolean("DropOptions.DropLootsplosion", false);
        this.dropClientSide = this.config.getBoolean("DropOptions.DropClientSide", false);
        this.dropHologram = this.config.getBoolean("DropOptions.DropHologram", false);
        this.dropVFX = this.config.getBoolean("DropOptions.DropVFX", false);
        this.dropVFXMaterial = this.config.getString("DropOptions.DropVFXMaterial", null);
        this.dropVFXData = this.config.getInteger("DropOptions.DropVFXData", 0);
        this.dropVFXColor = this.config.getString("DropOptions.DropVFXColor", null);
        this.dropBillboarding = this.config.getString("DropOptions.DropBillboarding", "VERTICAL");
        this.dropBrightness = this.config.getInteger("DropOptions.DropBrightness", 0);
        this.mythicTypeOverride = this.internalName;
        this.data = (byte)this.config.getInteger("Data", 0);
        this.durability = this.config.getPlaceholderInt(new String[]{"Options.Durability", "Durability"}, String.valueOf(this.data));
        this.maxDurability = this.config.getPlaceholderInt(new String[]{"Options.MaxDurability", "MaxDurability", "CustomDurability.Durability"}, "0");
        if (this.config.isSet("ItemStack")) {
            ItemStack is = this.config.getItemStack("ItemStack", null);
            if (is != null) {
                this.cachedBaseItem = BukkitAdapter.adapt(is);
                try {
                    this.displayName = is.getItemMeta().getDisplayName();
                    this.lore = new ArrayList<PlaceholderString>();
                    for (String s2 : is.getItemMeta().getLore()) {
                        this.lore.add(PlaceholderString.of(s2));
                    }
                    this.imported = true;
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "Couldn't get name/lore of ItemStack");
                }
            } else {
                MythicLogger.errorItemConfig(this, this.config, "Failed to load imported Bukkit ItemStack");
                this.cachedBaseItem = BukkitAdapter.adapt(Material.STONE);
            }
        } else {
            this.strMaterial = this.config.getString(new String[]{"Id", "Material"}, ConfigExecutor.getItemDefaultMaterial(), new String[0]).toUpperCase();
            this.setupMaterial(this.strMaterial);
        }
        this.group = this.config.getString(new String[]{"Group", "ItemType", "Options.Group", "Options.ItemType"}, "OTHER", new String[0]);
        this.amount = this.config.getInteger("Amount", 1);
        this.displayName = SkillString.parseMessageSpecialChars(this.config.getString("Display"));
        if (this.config.isList("Lore")) {
            this.lore = this.config.getPlaceholderStringList("Lore");
        } else if (this.config.isConfigurationSection("Lore")) {
            this.loreTemplate = Optional.ofNullable(this.config.getString("Lore.Template", null));
        }
        this.bookAuthor = this.config.getPlaceholderString("Author", "Unknown");
        this.bookTitle = this.config.getPlaceholderString("Title", "Unknown");
        if (this.config.isList("Pages")) {
            this.bookPages = this.config.getPlaceholderStringList("Pages");
        }
        this.fireworkColors = this.config.getStringList("Firework.Colors");
        this.fireworkFadeColors = this.config.getStringList("Firework.FadeColors");
        if (this.config.isSet("Rarity")) {
            try {
                this.rarity = AbstractItemStackRarity.valueOf(this.config.getString("Rarity").toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorItemConfig(this, this.config, "Couldn't load rarity");
            }
        }
        if (this.config.isSet("TooltipStyle")) {
            this.tooltipComponent = new AbstractItemTooltipComponent(this, this.config);
            this.components.add(this.tooltipComponent);
        }
        if (this.config.isSet("BannerLayers")) {
            componentData = new AbstractItemBannerComponent(this, this.config);
            this.components.add(componentData);
        }
        if (this.config.isSet("Equippable")) {
            this.equippableData = new AbstractItemEquippableComponent(this, this.config.getNestedConfig("Equippable"));
            this.components.add(this.equippableData);
        }
        if (this.config.isSet("Food")) {
            componentData = new AbstractItemFoodComponent(this, this.config.getNestedConfig("Food"));
            this.components.add(componentData);
        }
        if (this.config.isSet("Consumable") && (componentData = MythicItem.getPlugin().getBootstrap().createItemConsumableComponent(this, this.config.getNestedConfig("Consumable"))) != null) {
            this.components.add(componentData);
        }
        if (this.config.isSet("Potion") || this.config.isSet("PotionEffects")) {
            componentData = new AbstractItemPotionComponent(this, this.config);
            this.components.add(componentData);
        }
        if (this.config.isSet("Tool")) {
            componentData = new AbstractItemToolComponent(this, this.config.getNestedConfig("Tool"));
            this.components.add(componentData);
        }
        if (this.config.isSet("Spawner")) {
            componentData = new AbstractItemSpawnerComponent(this, this.config.getNestedConfig("Spawner"));
            this.components.add(componentData);
        }
        if (this.config.isSet("TrialSpawner")) {
            componentData = new AbstractItemTrialSpawnerComponent(this, this.config.getNestedConfig("TrialSpawner"));
            this.components.add(componentData);
        }
        if (this.config.isSet("UseCooldown")) {
            componentData = new AbstractItemUseCooldownComponent(this, this.config.getNestedConfig("UseCooldown"));
            this.components.add(componentData);
        }
        if (this.config.isSet("BlocksAttacks") || this.config.isSet("Options.BlocksAttacks")) {
            componentData = new AbstractItemBlocksAttacksComponent(this);
            this.components.add(componentData);
        }
        if (this.config.isSet("Glider") || this.config.isSet("Options.Glider")) {
            componentData = new AbstractItemGliderComponent(this);
            this.components.add(componentData);
        }
        if (this.config.isSet("DeathProtection") && (componentData = MythicItem.getPlugin().getBootstrap().createItemDeathProtectionComponent(this, this.config.getNestedConfig("DeathProtection"))) != null) {
            this.components.add(componentData);
        }
        if (this.config.isSet("BlockStates")) {
            componentData = new AbstractItemBlockStateComponent(this, this.config);
            this.components.add(componentData);
        }
        if (this.config.isConfigurationSection("Trim")) {
            this.trimComponent = new AbstractItemTrimComponent(this, this.config.getNestedConfig("Trim"));
        } else if (this.config.isConfigurationSection("Options.Trim")) {
            this.trimComponent = new AbstractItemTrimComponent(this, this.config.getNestedConfig("Options.Trim"));
        } else if (this.config.isSet("Trim") || this.config.isSet("Options.Trim")) {
            String pattern;
            String armorTrim = this.config.getString(new String[]{"Trim", "Options.Trim"}, null, new String[0]);
            String material = "iron";
            String[] parts = armorTrim.split("\\.", 2);
            if (parts.length > 1) {
                material = parts[0];
                pattern = parts[1];
            } else {
                pattern = armorTrim;
            }
            this.trimComponent = new AbstractItemTrimComponent(this, material, pattern);
        }
        if (this.trimComponent != null) {
            this.components.add(this.trimComponent);
        }
        if (this.material == Material.SHIELD) {
            try {
                this.shieldColor = DyeColor.valueOf((String)this.config.getString("Options.Color", null));
            }
            catch (Throwable armorTrim) {}
        } else {
            this.color = this.config.getPlaceholderColor("Options.Color", null);
        }
        try {
            this.shieldColor = DyeColor.valueOf((String)this.config.getString("Options.Color", null));
        }
        catch (Throwable armorTrim) {
            // empty catch block
        }
        this.player = this.config.getString("Options.Player");
        Object skinId = this.config.getString("Options.SkinID", null);
        if (skinId != null) {
            skinId = "https://textures.minecraft.net/texture/" + (String)skinId;
        }
        this.skinURL = this.config.getString("Options.SkinURL", (String)skinId);
        String skinTexture = this.config.getString("Options.SkinTexture");
        if (skinTexture != null) {
            try {
                String decoded = Base64Util.decodeString(skinTexture);
                GsonProvider.parser();
                JsonObject obj = JsonParser.parseString((String)decoded).getAsJsonObject();
                this.skinURL = obj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            }
            catch (Throwable ex) {
                MythicLogger.errorItemConfig(this, this.config, "Invalid SkinTexture provided");
            }
        }
        if (this.skinURL != null) {
            this.skinUUID = MythicUtil.getUUIDFromString(this.skinURL);
        }
        this.unbreakable = this.config.getBoolean("Options.Indestructible", false);
        this.unbreakable = this.config.getBoolean("Options.Indestructable", this.unbreakable);
        this.unbreakable = this.config.getBoolean("Options.Unbreakable", this.unbreakable);
        this.hideFlags = this.config.getBoolean("Options.HideFlags", false);
        this.appendType = this.config.getBoolean("Options.AppendType", true);
        String model = this.config.getString("Model", "-1");
        OptionalInt maybeNumber = Numbers.parseInteger(model = this.config.getString("Options.Model", model));
        if (maybeNumber.isPresent()) {
            this.customModelData = maybeNumber.getAsInt();
            model = null;
        }
        Object itemModel = this.config.getString("ItemModel", model);
        itemModel = this.config.getString("Options.ItemModel", model);
        if (itemModel != null) {
            if (!((String)itemModel).contains(":")) {
                itemModel = "minecraft:" + (String)itemModel;
            }
            this.itemModel = NamespacedKey.fromString((String)itemModel);
        }
        this.customModelData = this.config.getInteger("Options.CustomModelData", this.customModelData);
        this.customModelData = this.config.getInteger("CustomModelData", this.customModelData);
        this.maxEnchantments = PlaceholderInt.of(this.config.getString("Options.MaxEnchants", "-1"));
        this.preventEnchanting = this.config.getBoolean("Options.PreventVanillaEnchanting", false);
        this.preventEnchanting = this.config.getBoolean("Options.PreventEnchanting", this.preventEnchanting);
        this.preventCraftingWith = this.config.getBoolean("Options.PreventVanillaCrafting", this.customModelData > 0);
        this.preventCraftingWith = this.config.getBoolean("Options.PreventCrafting", this.preventCraftingWith);
        this.preventAnvilWith = this.config.getBoolean("Options.PreventVanillaAnvil", this.customModelData > 0);
        this.preventAnvilWith = this.config.getBoolean("Options.PreventAnvil", this.preventAnvilWith);
        this.preventSmithingWith = this.config.getBoolean("Options.PreventVanillaSmithing", this.customModelData > 0);
        this.preventSmithingWith = this.config.getBoolean("Options.PreventSmithing", this.preventSmithingWith);
        this.itemVersion = Version.parse(this.config.getString("ItemUpdater.Version", "0"));
        this.preserveStatRatioOnUpdate = this.config.getBoolean("ItemUpdater.PreserveStatRatio", true);
        this.dropGlowColor = this.config.getString("Options.DropGlowColor", null);
        this.dropBeamColor = this.config.getColor("Options.DropBeamColor", null);
        if (this.dropGlowColor != null) {
            this.dropGlow = true;
        }
        if (this.dropBeamColor != null) {
            this.dropBeam = true;
        }
        List<String> dropSkills = this.config.getStringList("DropSkills");
        for (String s3 : dropSkills) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Loading mechanic line: {0}", s3);
            s3 = MythicLineConfigImpl.unparseBlock(s3);
            SkillMechanic ms = MythicItem.getPlugin().getSkillManager().getMechanic(s3);
            if (ms != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Base skill found.", new Object[0]);
                if (!this.dropSkills.containsKey(ms.getTrigger())) {
                    this.dropSkills.put(ms.getTrigger(), new LinkedList());
                }
                this.dropSkills.get(ms.getTrigger()).add(ms);
                continue;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Base skill was not found.", new Object[0]);
        }
        double mmoPvEDamage = this.config.getDouble("MMOItemsStats.PvEDamage", -1.0);
        if (mmoPvEDamage > -1.0) {
            this.itemOptions.put("MMOITEMS_PVE_DAMAGE", new DoubleTag(mmoPvEDamage));
        }
        if ((hideOptions = this.config.getStringList("Hide")) != null) {
            for (String hide : hideOptions) {
                if ((hide = hide.toUpperCase()).startsWith("HIDE_")) {
                    this.hideOptions.add(hide);
                    continue;
                }
                String f = "HIDE_" + hide;
                this.hideOptions.add(f);
            }
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                hideOptions.remove("HIDE_POTION_EFFECTS");
            }
        }
        if ((canPlaceOn = this.config.getStringList("CanPlaceOn")) != null) {
            this.placeOptions.addAll(canPlaceOn);
        }
        if ((canBreak = this.config.getStringList("CanBreak")) != null) {
            this.breakOptions.addAll(canBreak);
        }
        this.maxStackSize = this.config.getInt("Options.StackSize", this.material.getMaxStackSize());
        this.enchantGlint = this.config.getBoolean("Options.Glint", false);
        if (this.config.getString("Options.FireResistant") != null) {
            this.fireResistant = this.config.getBoolean("Options.FireResistant");
        }
        this.preventStacking = this.config.getBoolean("Options.PreventStacking", false);
        this.generateUUID = this.config.getBoolean("Options.GenerateUUID", false);
        this.generateTimestamp = this.config.getBoolean("Options.GenerateTimestamp", false);
        if (this.config.isSet("NBT")) {
            try {
                this.itemNBT = this.parseNBTNode("NBT");
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "NBT tags are configured incorrectly.");
                MythicLogger.handleMinorError(ex);
            }
        }
        if (this.config.isSet("Attributes")) {
            try {
                for (String slot : this.config.getKeys("Attributes")) {
                    for (String attr : this.config.getKeys("Attributes." + slot)) {
                        String value;
                        String configuration = this.config.getString("Attributes." + slot + "." + attr);
                        String[] fields = configuration.split(" ");
                        String rawValue = fields[0];
                        AbstractAttributeModifier.Operation operation = null;
                        BukkitAttribute attribute = BukkitAttribute.get(attr);
                        NamespacedKey attributeKey = Optional.ofNullable(attribute).map(BukkitAttribute::getAttributeKey).orElse(NamespacedKey.minecraft((String)attr.toLowerCase()));
                        if (fields.length > 1) {
                            operation = AbstractAttributeModifier.Operation.parse(fields[1]);
                        }
                        if ((value = rawValue).endsWith("%")) {
                            value = String.valueOf(Double.parseDouble(configuration.substring(0, configuration.length() - 1)) / 100.0);
                            if (operation == null) {
                                operation = AbstractAttributeModifier.Operation.ADD_SCALAR;
                            }
                        }
                        if (operation == null) {
                            operation = attributeKey.toString().equals(BukkitAttribute.getAttributeKey("ATTACK_SPEED")) || attributeKey.toString().equals(BukkitAttribute.getAttributeKey("MOVEMENT_SPEED")) ? AbstractAttributeModifier.Operation.ADD_SCALAR : AbstractAttributeModifier.Operation.ADD;
                        }
                        String tagIdString = "this.internalName_" + attributeKey.toString() + "_" + slot.toUpperCase(Locale.ENGLISH) + "_" + operation.toString();
                        UUID tagUUID = MythicUtil.getUUIDFromString(tagIdString);
                        this.itemAttributes.add(new AbstractAttributeModifier(attributeKey, tagUUID, PlaceholderDouble.of(value), operation, EquipSlot.of(slot.toUpperCase(Locale.ENGLISH))));
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "Attributes are configured incorrectly.");
                ex.printStackTrace();
            }
        }
        MythicItem.getPlugin().getClock().queuePostReload(() -> {
            List<String> enchantmentsIn = this.config.getStringList("Enchantments");
            for (String in : enchantmentsIn) {
                if (this.addEnchantment(in)) continue;
                MythicLogger.errorItemConfig(this, this.config, "Invalid enchantment configured: " + in);
            }
            this.buildItemCache();
        });
    }

    private Map<String, Tag> parseNBTNode(String node) {
        MythicConfig config = this.config;
        ConcurrentMap tags = Maps.newConcurrentMap();
        for (String baseKey : config.getKeys(node)) {
            String innerNode = node + "." + baseKey;
            if (config.isConfigurationSection(innerNode)) {
                tags.put(baseKey, CompoundTag.create(tag -> tag.putAll(this.parseNBTNode(innerNode))));
                continue;
            }
            if (config.isMapList(innerNode)) {
                List<Map<?, ?>> rawMaps = config.getMapList(innerNode);
                List<CompoundTag> compounds = rawMaps.stream().map(map -> CompoundTag.create(t2 -> {
                    for (Map.Entry e : map.entrySet()) {
                        t2.put(e.getKey().toString(), this.getNbtValue(e.getValue().toString()));
                    }
                })).toList();
                tags.put(baseKey, new ListTag(CompoundTag.class, compounds));
                continue;
            }
            if (config.isList(innerNode)) {
                List<Tag> parsed = config.getStringList(innerNode).stream().map(this::getNbtValue).toList();
                Class<StringTag> elemType = parsed.isEmpty() ? StringTag.class : parsed.get(0).getClass();
                tags.put(baseKey, new ListTag(elemType, parsed));
                continue;
            }
            Tag nbtValue = this.getNbtValue(config.getString(innerNode));
            tags.put(baseKey, nbtValue);
        }
        return tags;
    }

    private Tag getNbtValue(String string) {
        if (string.startsWith("int/")) {
            return new PlaceholderIntTag(PlaceholderInt.of(string.substring(4)));
        }
        if (string.startsWith("float/")) {
            return new PlaceholderFloatTag(PlaceholderFloat.of(string.substring(6)));
        }
        if (string.startsWith("double/")) {
            return new PlaceholderDoubleTag(PlaceholderDouble.of(string.substring(7)));
        }
        if (string.startsWith("byte/")) {
            return new ByteTag(Byte.parseByte(string.substring(5)));
        }
        if (string.startsWith("bool/")) {
            return new ByteTag(Boolean.parseBoolean(string.substring(5)) ? (byte)1 : 0);
        }
        if (string.startsWith("boolean/")) {
            return new ByteTag(Boolean.parseBoolean(string.substring(8)) ? (byte)1 : 0);
        }
        return new PlaceholderStringTag(PlaceholderString.of(string));
    }

    public void buildItemCache() {
        try {
            this.cachedMenuItem = BukkitAdapter.adapt(this.generateItemStack(1));
        }
        catch (Throwable ex) {
            MythicLogger.errorItemConfig(this, this.config, "Failed to generate cached menu item");
            this.cachedMenuItem = new ItemStack(Material.BARRIER);
            ex.printStackTrace();
        }
        String displayName = this.displayName == null ? "<gray>(No Display Name)" : this.displayName;
        String materialName = this.material == null ? "<gray>Material Not Set" : this.material.toString();
        this.cachedMenuItem = ItemFactory.of(this.cachedMenuItem).hideAttributes().name("<green><bold>" + this.internalName).prependLore(() -> {
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add("<red> ");
            lines.add("<yellow>" + materialName + " <gray>(Model: <aqua>" + this.customModelData + "<gray>)");
            lines.add("<red> ");
            lines.add(displayName);
            return lines.iterator();
        }).lore(() -> {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("<red> ");
            lines.add("<rainbow>\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583");
            lines.add("<gray>\u22b3 <yellow>Left-Click to get Item");
            lines.add("<gray>\u22b3 <yellow>Right-Click to Edit");
            return lines.iterator();
        }).build();
    }

    @Deprecated
    public ItemStack getCachedBaseItem() {
        return BukkitAdapter.adapt(this.cachedBaseItem);
    }

    @Deprecated
    public String getMaterialName() {
        return this.strMaterial;
    }

    public boolean setMaterial(String material) {
        if (this.setupMaterial(material)) {
            if (this.config.isSet("Id")) {
                this.config.setSave("Id", material);
            } else {
                this.config.setSave("Material", material);
            }
            this.buildItemCache();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setupMaterial(String material) {
        this.strMaterial = material;
        try {
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
                this.material = Material.AIR;
                try {
                    Material material2 = this.material = this.data == 0 ? Material.valueOf((String)this.strMaterial) : LegacyItemConverter.getMaterial(this.strMaterial, this.data);
                    if (this.material != null || this.data <= 0) return true;
                    this.material = Material.valueOf((String)this.strMaterial);
                    return true;
                }
                catch (Exception ex) {
                    this.material = LegacyItemConverter.getMaterial(this.strMaterial, this.data);
                    if (this.material != null || this.data <= 0) return true;
                    this.material = Material.valueOf((String)this.strMaterial);
                    return true;
                }
                finally {
                    this.cachedBaseItem = BukkitAdapter.adapt(this.material);
                }
            } else {
                this.material = this.strMaterial.matches("[0-9]*") ? LegacyItemConverter.getMaterial(this.strMaterial, (byte)0) : Material.valueOf((String)this.strMaterial);
                this.cachedBaseItem = BukkitAdapter.adapt(this.material).data(this.data).amount(this.amount * this.amount);
            }
            return true;
        }
        catch (Exception ex) {
            this.material = Material.STONE;
            this.cachedBaseItem = BukkitAdapter.adapt(this.material);
            MythicLogger.errorItemConfig(this, this.config, "Material type '" + this.strMaterial + "' not found");
            return false;
        }
    }

    public List<String> getLore() {
        ArrayList ret = Lists.newArrayList();
        if (this.lore == null) {
            return ret;
        }
        for (PlaceholderString pl : this.lore) {
            ret.add(pl.toString());
        }
        return ret;
    }

    public List<PlaceholderString> getLoreRaw() {
        return this.lore;
    }

    public boolean addEnchantment(String in) {
        String[] split = in.split(" ");
        Enchantment ench = null;
        PlaceholderInt enchLevel = PlaceholderInt.of("1");
        try {
            NamespacedKey key = NamespacedKey.fromString((String)split[0].toLowerCase(Locale.ROOT));
            if (key != null) {
                ench = (Enchantment)Registry.ENCHANTMENT.get(key);
            }
            if (ench == null && in.contains(":")) {
                split = in.split(":");
                ench = Enchantment.getByName((String)split[0]);
            }
        }
        catch (Error | Exception ex) {
            MythicLogger.errorItemConfig(this, this.config, "Could not apply enchantment");
            MythicLogger.handleMinorError(ex);
            return false;
        }
        if (ench == null) {
            MythicLogger.errorItemConfig(this, this.config, "Enchantment '" + split[0] + "' not found");
            return false;
        }
        if (split.length > 1) {
            enchLevel = PlaceholderInt.of(split[1]);
        }
        this.enchantments.put(ench, enchLevel);
        return true;
    }

    public AbstractItemStack generateItemStack(int amount) {
        return this.generateItemStack(new DropMetadataImpl(null, null), amount);
    }

    public AbstractItemStack generateItemStack(int amount, Map<String, Object> metadata) {
        DropMetadataImpl dropMetaData = new DropMetadataImpl(null, null);
        dropMetaData.setMetadata(metadata);
        return this.generateItemStack(dropMetaData, amount);
    }

    @Deprecated
    public AbstractItemStack generateItemStack(int amount, AbstractEntity dropper, AbstractEntity trigger) {
        SkillCaster d = MythicItem.getPlugin().getSkillManager().getCasterNullable(dropper);
        return this.generateItemStack(new DropMetadataImpl(d, trigger), amount);
    }

    public AbstractItemStack generateItemStack(DropMetadata meta, int amount) {
        int durability;
        int repairCost;
        if (this.imported) {
            return this.cachedBaseItem.copy();
        }
        AbstractEntity dropper = Optional.ofNullable(meta).flatMap(m4 -> m4.getDropper().map(SkillCaster::getEntity)).orElse(null);
        AbstractItemStack itemStack = this.cachedBaseItem.copy().amount(this.cachedBaseItem.getAmount() * amount);
        if (this.customModelData != -1) {
            itemStack.modelData(this.customModelData);
        }
        if (this.unbreakable) {
            itemStack.breakable(false);
        }
        if (!this.placeOptions.isEmpty()) {
            itemStack.canPlaceOn(this.placeOptions.stream().map(it -> Material.valueOf((String)it.toUpperCase(Locale.ROOT))).toList());
        }
        if (!this.breakOptions.isEmpty()) {
            itemStack.canBreak(this.breakOptions.stream().map(it -> Material.valueOf((String)it.toUpperCase(Locale.ROOT))).toList());
        }
        int n = repairCost = !this.config.getBoolean("Options.Repairable", true) ? Integer.MAX_VALUE : this.config.getInteger("RepairCost", -1);
        if (repairCost != -1) {
            itemStack.repairCost(repairCost);
        }
        if (this.maxStackSize > 0) {
            itemStack.maxStackSize(this.maxStackSize);
        }
        if (this.enchantGlint.booleanValue()) {
            itemStack.enchantmentGlow(true);
        }
        for (AbstractItemComponent abstractItemComponent : this.components) {
            abstractItemComponent.apply(this, meta, itemStack);
        }
        if (this.itemModel != null) {
            itemStack.itemModel(this.itemModel);
        }
        if (this.displayName != null) {
            itemStack.name(Text.parse(this.displayName));
        }
        if (MythicItem.getPlugin().getCompatibility().getCrucible().isEmpty() && this.lore != null && !this.lore.isEmpty()) {
            ArrayList<Component> loreBuilder = new ArrayList<Component>();
            for (PlaceholderString pl : this.lore) {
                String str = pl.get(meta);
                if ((str = SkillString.parseMessageSpecialChars(str)).contains("{")) {
                    Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                    while (pMatcher.find()) {
                        int min2 = Integer.parseInt(pMatcher.group(1));
                        int max = Integer.parseInt(pMatcher.group(2));
                        int num = Numbers.randomInt(max - min2) + min2;
                        str = str.replace(pMatcher.group(0), "" + num);
                    }
                }
                loreBuilder.add(Text.parse(str));
            }
            itemStack.lore(loreBuilder);
        }
        if (this.preventStacking) {
            itemStack.unstackable();
            this.maxStackSize = 1;
        }
        itemStack.customData(CompoundTagBuilder.create().putAll(this.itemOptions).putAll(this.itemNBT).build());
        if (!this.itemAttributes.isEmpty()) {
            this.itemAttributes.forEach(itemStack::addAttributeModifier);
        }
        if (this.appendType.booleanValue()) {
            itemStack.mythicItemType(this.mythicTypeOverride);
        }
        if (this.itemVersion.hasVersion()) {
            itemStack.mythicItemVersion(this.itemVersion.getNumeralVersion());
        }
        if (this.preventEnchanting.booleanValue()) {
            itemStack.preventEnchanting();
        }
        if (this.preventAnvilWith.booleanValue()) {
            itemStack.preventRepairingWith();
        }
        if (this.preventCraftingWith.booleanValue()) {
            itemStack.preventCraftingWith();
        }
        if (this.preventSmithingWith.booleanValue()) {
            itemStack.preventSmithingWith();
        }
        if (this.generateUUID) {
            itemStack.UUID(UUID.randomUUID());
        }
        if (this.generateTimestamp) {
            itemStack.timestamp(System.currentTimeMillis());
        }
        if (!this.maxDurability.isStaticallyEqualTo(0)) {
            itemStack.maxDurability(this.maxDurability.get(meta, dropper));
        }
        if ((durability = this.durability.get(meta, Optional.ofNullable(meta).flatMap(DropMetadata::getCause).orElse(null))) > 0) {
            itemStack.durability(Numbers.clamp(durability, 1, itemStack.getMaxDurability()));
        }
        if (this.player != null) {
            itemStack.skullOwner(this.player, this.skinUUID);
        } else if (this.skinURL != null) {
            itemStack.skullTexture(URI.create(this.skinURL));
        }
        if (itemStack instanceof BukkitItemStack) {
            BukkitItemStack bukkitItemStack = (BukkitItemStack)itemStack;
            bukkitItemStack.editMeta(m4 -> this.buildBook((ItemMeta)m4, meta));
            if (this.material == Material.FIREWORK_ROCKET) {
                bukkitItemStack.editMeta(this::buildFirework);
            }
            if (this.material == Material.FIREWORK_STAR) {
                bukkitItemStack.editMeta(this::buildFireworkCharge);
            }
            if (this.data > 0) {
                bukkitItemStack.editMeta(MapMeta.class, m4 -> {
                    m4.setMapId((int)this.data);
                    m4.setMapView(Bukkit.getMap((int)this.data));
                });
            }
            if (this.color != null) {
                bukkitItemStack.editMeta(m4 -> this.setItemColor((ItemMeta)m4, meta));
            }
        }
        if (itemStack instanceof ItemComponentBukkitItemStack) {
            ItemComponentBukkitItemStack itemComponentBukkitItemStack = (ItemComponentBukkitItemStack)itemStack;
            if (this.rarity != null) {
                itemComponentBukkitItemStack.rarity(this.rarity);
            }
            if (this.fireResistant != null) {
                itemComponentBukkitItemStack.fireResistant(this.fireResistant);
            }
        }
        if (this.enchantments != null) {
            this.setEnchantments(dropper, itemStack);
        }
        if (!this.hideOptions.isEmpty()) {
            itemStack.flags(this.hideOptions.stream().map(AbstractItemFlag::valueOf).toList());
        }
        if (this.hideFlags) {
            itemStack.hideAll();
        }
        ItemStack itemStack2 = BukkitAdapter.adapt(itemStack);
        DropMetadata fmeta = meta.deeperClone();
        fmeta.setMetadata(PlaceholderMetadataKey.ITEM_STACK, (Object)itemStack2);
        fmeta.setMetadata(PlaceholderMetadataKey.MYTHIC_TYPE, (Object)this.internalName);
        MythicMobItemGenerateEvent generateEvent = new MythicMobItemGenerateEvent(this, fmeta, itemStack2);
        Events.callSync(generateEvent);
        return BukkitAdapter.adapt(generateEvent.getItemStack());
    }

    private void setEnchantments(AbstractEntity entity, AbstractItemStack itemStack) {
        if (this.enchantments == null || this.enchantments.isEmpty()) {
            return;
        }
        int enchantmentCount = Optional.ofNullable(entity).map(this.maxEnchantments::get).orElseGet(this.maxEnchantments::get);
        ArrayList enchantsToApply = Lists.newArrayList(this.enchantments.keySet());
        if (enchantmentCount > 0) {
            Collections.shuffle(enchantsToApply);
        } else {
            enchantmentCount = enchantsToApply.size();
        }
        for (int i = 0; i < enchantmentCount; ++i) {
            Enchantment enchant = (Enchantment)enchantsToApply.get(i);
            int enchantLevel = this.enchantments.get(enchant).get(entity);
            if (enchantLevel == 0) continue;
            this.applyEnchantToItem(itemStack, enchant, enchantLevel);
        }
    }

    private void applyEnchantToItem(AbstractItemStack itemStack, Enchantment enchant, int enchantLevel) {
        MythicApplyEnchantEvent event = new MythicApplyEnchantEvent(BukkitAdapter.adapt(itemStack), enchant, enchantLevel);
        Events.callAndReturn(event);
        if (event.getWasHandled().booleanValue()) {
            return;
        }
        itemStack.enchant(enchant, enchantLevel);
    }

    private void buildFirework(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        if (!(im instanceof FireworkMeta)) {
            return;
        }
        FireworkMeta pm = (FireworkMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.addEffect(builder.build());
    }

    private void buildFireworkCharge(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        if (!(im instanceof FireworkEffectMeta)) {
            return;
        }
        FireworkEffectMeta pm = (FireworkEffectMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.setEffect(builder.build());
    }

    private void buildBook(ItemMeta im, DropMetadata dropMetadata) {
        BookMeta bookMeta;
        block10: {
            block9: {
                if (!(im instanceof BookMeta)) break block9;
                bookMeta = (BookMeta)im;
                if (this.bookPages != null) break block10;
            }
            return;
        }
        String author = this.bookAuthor.get(dropMetadata);
        if (ServerVersion.isPaper()) {
            bookMeta.author(MiniMessage.miniMessage().deserialize((Object)author));
        } else {
            bookMeta.setAuthor(Text.toLegacy(Text.parse(author)));
        }
        String title = this.bookTitle.get(dropMetadata);
        if (ServerVersion.isPaper()) {
            bookMeta.title(MiniMessage.miniMessage().deserialize((Object)title));
        } else {
            bookMeta.setTitle(Text.toLegacy(Text.parse(title)));
        }
        for (PlaceholderString page : this.bookPages) {
            String contents = page.get(dropMetadata);
            if (ServerVersion.isPaper()) {
                bookMeta.addPages(new Component[]{MiniMessage.miniMessage().deserialize((Object)contents)});
                continue;
            }
            Component component = Text.parse(contents);
            bookMeta.addPage(new String[]{Text.toLegacy(component)});
        }
    }

    private void setItemColor(ItemMeta itemMeta, DropMetadata dropMetadata) {
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            leatherArmorMeta.setColor(this.color.get(dropMetadata).toBukkitColor());
        } else if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            potionMeta.setColor(this.color.get(dropMetadata).toBukkitColor());
        }
    }

    @Override
    public int compareTo(MythicItem o) {
        return this.internalName.compareTo(o.getInternalName());
    }

    @Override
    public Icon<ItemMenuContext> getIcon() {
        return IconBuilder.create().itemStack(this.cachedMenuItem).hideFlags().click((context, player) -> {
            player.performCommand("mythicmobs i get " + this.internalName);
            player.playSound(player.getLocation(), "entity.experience_orb.pickup", 1.0f, 1.0f);
        }).rightClick((context, player) -> {
            ItemEditorMenuContext ctx = new ItemEditorMenuContext(this, (ItemMenuContext)context);
            MythicItem.getPlugin().getMenuManager().getItemEditorMenu().open((Player)player, ctx);
        }).build();
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public ItemStack getCachedMenuItem() {
        return this.cachedMenuItem;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Pack getPack() {
        return this.pack;
    }

    public File getFile() {
        return this.file;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setStrMaterial(String strMaterial) {
        this.strMaterial = strMaterial;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    public int getAmount() {
        return this.amount;
    }

    public PlaceholderInt getDurability() {
        return this.durability;
    }

    public void setDurability(PlaceholderInt durability) {
        this.durability = durability;
    }

    public PlaceholderInt getMaxDurability() {
        return this.maxDurability;
    }

    public void setMaxDurability(PlaceholderInt maxDurability) {
        this.maxDurability = maxDurability;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public Boolean getEnchantGlint() {
        return this.enchantGlint;
    }

    public Boolean getFireResistant() {
        return this.fireResistant;
    }

    public void setFireResistant(Boolean fireResistant) {
        this.fireResistant = fireResistant;
    }

    public AbstractItemStackRarity getRarity() {
        return this.rarity;
    }

    public void setRarity(AbstractItemStackRarity rarity) {
        this.rarity = rarity;
    }

    public PlaceholderInt getMaxEnchantments() {
        return this.maxEnchantments;
    }

    public void setMaxEnchantments(PlaceholderInt maxEnchantments) {
        this.maxEnchantments = maxEnchantments;
    }

    public Boolean getPreventEnchanting() {
        return this.preventEnchanting;
    }

    public void setPreventEnchanting(Boolean preventEnchanting) {
        this.preventEnchanting = preventEnchanting;
    }

    public Boolean getPreventAnvilWith() {
        return this.preventAnvilWith;
    }

    public void setPreventAnvilWith(Boolean preventAnvilWith) {
        this.preventAnvilWith = preventAnvilWith;
    }

    public Boolean getPreventCraftingWith() {
        return this.preventCraftingWith;
    }

    public void setPreventCraftingWith(Boolean preventCraftingWith) {
        this.preventCraftingWith = preventCraftingWith;
    }

    public Boolean getPreventSmithingWith() {
        return this.preventSmithingWith;
    }

    public void setPreventSmithingWith(Boolean preventSmithingWith) {
        this.preventSmithingWith = preventSmithingWith;
    }

    public PlaceholderColor getDropColor() {
        return this.dropColor;
    }

    public void setDropColor(PlaceholderColor dropColor) {
        this.dropColor = dropColor;
    }

    public PlaceholderColor getColor() {
        return this.color;
    }

    public void setColor(PlaceholderColor color) {
        this.color = color;
    }

    public DyeColor getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(DyeColor shieldColor) {
        this.shieldColor = shieldColor;
    }

    public PlaceholderString getArmorTrim() {
        return this.armorTrim;
    }

    public void setArmorTrim(PlaceholderString armorTrim) {
        this.armorTrim = armorTrim;
    }

    public String getPlayer() {
        return this.player;
    }

    public String getSkinURL() {
        return this.skinURL;
    }

    public UUID getSkinUUID() {
        return this.skinUUID;
    }

    public Optional<String> getLoreTemplate() {
        return this.loreTemplate;
    }

    public void setLore(List<PlaceholderString> lore) {
        this.lore = lore;
    }

    public Map<Enchantment, PlaceholderInt> getEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(Map<Enchantment, PlaceholderInt> enchantments) {
        this.enchantments = enchantments;
    }

    public Collection<AbstractItemComponent> getComponents() {
        return this.components;
    }

    public void setComponents(Collection<AbstractItemComponent> components) {
        this.components = components;
    }

    public PlaceholderString getBookAuthor() {
        return this.bookAuthor;
    }

    public void setBookAuthor(PlaceholderString bookAuthor) {
        this.bookAuthor = bookAuthor;
    }

    public PlaceholderString getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(PlaceholderString bookTitle) {
        this.bookTitle = bookTitle;
    }

    public List<PlaceholderString> getBookPages() {
        return this.bookPages;
    }

    public void setBookPages(List<PlaceholderString> bookPages) {
        this.bookPages = bookPages;
    }

    public List<String> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPotionEffects(List<String> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public List<String> getFireworkColors() {
        return this.fireworkColors;
    }

    public void setFireworkColors(List<String> fireworkColors) {
        this.fireworkColors = fireworkColors;
    }

    public List<String> getFireworkFadeColors() {
        return this.fireworkFadeColors;
    }

    public void setFireworkFadeColors(List<String> fireworkFadeColors) {
        this.fireworkFadeColors = fireworkFadeColors;
    }

    public AbstractItemFoodComponent getFoodData() {
        return this.foodData;
    }

    public void setFoodData(AbstractItemFoodComponent foodData) {
        this.foodData = foodData;
    }

    public AbstractItemPotionComponent getPotionData() {
        return this.potionData;
    }

    public void setPotionData(AbstractItemPotionComponent potionData) {
        this.potionData = potionData;
    }

    public AbstractItemEquippableComponent getEquippableData() {
        return this.equippableData;
    }

    public void setEquippableData(AbstractItemEquippableComponent equippableData) {
        this.equippableData = equippableData;
    }

    public AbstractItemUseCooldownComponent getUseCooldownData() {
        return this.useCooldownData;
    }

    public void setUseCooldownData(AbstractItemUseCooldownComponent useCooldownData) {
        this.useCooldownData = useCooldownData;
    }

    public AbstractItemToolComponent getToolData() {
        return this.toolData;
    }

    public void setToolData(AbstractItemToolComponent toolData) {
        this.toolData = toolData;
    }

    public AbstractItemTooltipComponent getTooltipComponent() {
        return this.tooltipComponent;
    }

    public void setTooltipComponent(AbstractItemTooltipComponent tooltipComponent) {
        this.tooltipComponent = tooltipComponent;
    }

    public AbstractItemSpawnerComponent getSpawnerData() {
        return this.spawnerData;
    }

    public void setSpawnerData(AbstractItemSpawnerComponent spawnerData) {
        this.spawnerData = spawnerData;
    }

    public AbstractItemTrimComponent getTrimComponent() {
        return this.trimComponent;
    }

    public void setTrimComponent(AbstractItemTrimComponent trimComponent) {
        this.trimComponent = trimComponent;
    }

    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(NamespacedKey itemModel) {
        this.itemModel = itemModel;
    }

    public Map<String, Tag> getItemNBT() {
        return this.itemNBT;
    }

    public List<String> getHideOptions() {
        return this.hideOptions;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public boolean isHideFlags() {
        return this.hideFlags;
    }

    public String getMythicTypeOverride() {
        return this.mythicTypeOverride;
    }

    public void setMythicTypeOverride(String mythicTypeOverride) {
        this.mythicTypeOverride = mythicTypeOverride;
    }

    public Boolean getAppendType() {
        return this.appendType;
    }

    public void setAppendType(Boolean appendType) {
        this.appendType = appendType;
    }

    public boolean isPreventStacking() {
        return this.preventStacking;
    }

    public boolean isGenerateUUID() {
        return this.generateUUID;
    }

    public boolean isGenerateTimestamp() {
        return this.generateTimestamp;
    }

    public boolean isDropLootsplosion() {
        return this.dropLootsplosion;
    }

    public boolean isDropClientSide() {
        return this.dropClientSide;
    }

    public boolean isDropHologram() {
        return this.dropHologram;
    }

    public boolean isDropVFX() {
        return this.dropVFX;
    }

    public String getDropVFXMaterial() {
        return this.dropVFXMaterial;
    }

    public int getDropVFXData() {
        return this.dropVFXData;
    }

    public String getDropVFXColor() {
        return this.dropVFXColor;
    }

    public String getDropBillboarding() {
        return this.dropBillboarding;
    }

    public int getDropBrightness() {
        return this.dropBrightness;
    }

    public Version getItemVersion() {
        return this.itemVersion;
    }

    public boolean isPreserveStatRatioOnUpdate() {
        return this.preserveStatRatioOnUpdate;
    }

    public String getDropGlowColor() {
        return this.dropGlowColor;
    }

    public Chroma getDropBeamColor() {
        return this.dropBeamColor;
    }

    public boolean isDropGlow() {
        return this.dropGlow;
    }

    public boolean isDropBeam() {
        return this.dropBeam;
    }

    public Map<SkillTrigger<?>, Queue<SkillMechanic>> getDropSkills() {
        return this.dropSkills;
    }
}

